/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisAutoExitRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAutoExitService;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoExitItem;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoExitSelectReaderItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAutoExitController
extends BaseController
implements VisAutoExitRemote {
    @Autowired
    private VisAutoExitService visAutoExitService;

    @RequiresPermissions(value={"vis:autoExit:view"})
    public ModelAndView index() {
        List visAutoExitItemList = this.visAutoExitService.synchronousReaders();
        this.request.setAttribute("tempList", (Object)visAutoExitItemList);
        return new ModelAndView("vis/autoExit/visAutoExit");
    }

    @RequiresPermissions(value={"vis:autoExit:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visAutoExitService.getItemById(id));
        }
        return new ModelAndView("vis/autoExit/editVisAutoExit");
    }

    @RequiresPermissions(value={"vis:autoExit:edit"})
    public ZKResultMsg save(VisAutoExitItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visAutoExitService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VisAutoExitItem condition) {
        Pager pager = this.visAutoExitService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.visAutoExitService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectAutoExitReaderList(VisAutoExitSelectReaderItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.visAutoExitService.getNoExistAutoExitFilterArea(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_autoExitPlace", opType="vis_leftMenu_autoExitPlace", requestParams={"delIds", "devSnReaderName"}, opContent="vis_leftMenu_autoExitPlace")
    public ZKResultMsg savePoint() {
        ZKResultMsg res = new ZKResultMsg();
        String delIds = this.request.getParameter("delIds");
        String autoExitIds = this.request.getParameter("autoExitIds");
        this.visAutoExitService.savePoint(delIds, autoExitIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

