/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthAppRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthAppService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAppItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthAppController
extends BaseController
implements AuthAppRemote {
    @Autowired
    private AuthAppService authAppService;

    @RequiresPermissions(value={"auth:app"})
    public ModelAndView index() {
        return new ModelAndView("auth/app/authApp");
    }

    @RequiresPermissions(value={"auth:app:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.authAppService.getItemById(id));
        }
        return new ModelAndView("auth/app/editAuthApp");
    }

    @RequiresPermissions(value={"auth:app:edit"})
    public ZKResultMsg save(AuthAppItem item) {
        ZKResultMsg res = new ZKResultMsg();
        AuthAppItem appItem = this.authAppService.findByLicenseIdAndType(item.getLicenseId(), item.getType());
        if (appItem != null && !appItem.getId().equals(item.getId())) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"auth_license_serverError3", (Object[])new Object[0]));
        }
        this.authAppService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"auth:app:refresh"})
    public DxGrid list(AuthAppItem codition) {
        Pager pager = this.authAppService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"auth:app:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.authAppService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }
}

