/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;

public class PersRegularUtil {
    protected static final Pattern pinPattern = Pattern.compile("[0-9a-zA-Z]+");
    protected static final Pattern cardPattern = Pattern.compile("[0-9a-fA-F]+");
    public static Pattern zeroPattern = Pattern.compile("^0.*");
    public static Pattern carnumberPattern = Pattern.compile("^[0-9A-Z\\u4e00-\\u9fa5]+$");
    private static String[] provinceCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] powFactor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static char[] verifyValue = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    private static String idNumberPattern = "^[1-9][0-9]{5}(?:19|20)?[0-9]{2}(?:0[1-9]|1[012])(?:0[1-9]|[12][0-9]|3[01])[0-9]{3}[0-9Xx]?$";
    private static Pattern regex = Pattern.compile(idNumberPattern);
    public static Pattern emailPattern = Pattern.compile("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*$");

    public static boolean hasNumberOrLetter(String pin) {
        return pinPattern.matcher(pin).matches();
    }

    public static boolean isHex(String cardNo) {
        return cardPattern.matcher(cardNo).matches();
    }

    public static boolean hasSpecialChar(String value) {
        String[] specialChars;
        for (String c : specialChars = new String[]{"<", ">", "`", "~", "!", "@", "#", "$", "%", "^", "*", "?", "/", "|", "\\", ":", ";", "=", "\"", "'", ",", "--", "+"}) {
            if (!value.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean idNumberCheck(String idNum) {
        if (null == (idNum = idNum.toUpperCase()) || idNum.trim().length() != 18) {
            return false;
        }
        char checkValue = PersRegularUtil.getCheckValue(idNum);
        return regex.matcher(idNum).find() && PersRegularUtil.isValidProvinceId(idNum.substring(0, 2)) && checkValue == idNum.charAt(17) && PersRegularUtil.isValidDate(idNum.substring(6, 14));
    }

    private static boolean isValidProvinceId(String provinceId) {
        for (String id : provinceCode) {
            if (!id.equals(provinceId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    private static char getCheckValue(String idNum) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += Integer.parseInt(idNum.substring(i, i + 1)) * powFactor[i];
        }
        return verifyValue[sum % 11];
    }
}

