/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService;

import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.WebsocketServerInitializer;
import com.zkteco.zkbiosecurity.park.websocketService.WsDispatcher;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="websocketServerImpl")
@Lazy(value=false)
public class WebsocketServerImpl {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketServerImpl.class);
    @Autowired
    private WsDispatcher wsDispatcher;
    @Autowired
    private ChannelService channelService;
    @Value(value="${security.require-ssl:false}")
    private String ishttps;
    @Value(value="${park.webSocketPort:7397}")
    private int port;
    public static boolean isSSL;
    private Channel channel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebsocketServerInitializer(this.wsDispatcher, this.channelService, this.ishttps));
            this.channel = serverBootstrap.bind(this.port).sync().channel();
            logger.info(String.format("Websocket Server started on port:%s ", this.port));
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.error("Websocket Server Start Failed!", (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

