/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisFluidTransactionService;
import com.zkteco.zkbiosecurity.sis.thread.SicmGateSocketThread;
import com.zkteco.zkbiosecurity.sis.websocket.SicmGateDeviceInfo;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=111000)
public class SisGateDevCommServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisGateDevCommServer.class);
    public static int maxThreadCount = 4;
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisFluidTransactionService sisFluidTransactionService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private Map<String, SicmGateSocketThread> gateDeviceThreadMap = new HashMap<String, SicmGateSocketThread>();
    ServerSocket serverSocket = null;

    public void run(String ... strings) {
        new SicmGateDeviceListenThread("GateDeviceListenThread").start();
        new SicmGateDeviceCmdSendThread("GateDeviceCmdSendThread").start();
        new SicmGateDeviceImmeCmdThread("GateDeviceImmeCmdThread").start();
        new SicmGateDeviceConnectStatusThread("GateDeviceConnectStatusThread").start();
    }

    private boolean addDevToMonitorThread(String deviceIp, Socket socket) {
        boolean result;
        block5: {
            result = false;
            try {
                if (!SicmGateDeviceInfo.allGateDeviceMap.containsKey(deviceIp)) {
                    result = true;
                    SicmGateDeviceInfo devInfo = this.assembleDevInfoData(deviceIp, socket);
                    int curThreadCount = this.gateDeviceThreadMap.size();
                    String threadName = "";
                    if (curThreadCount < maxThreadCount) {
                        threadName = "SICM_GATE_" + (SicmGateDeviceInfo.allGateDeviceMap.size() - 1) % maxThreadCount;
                        SicmGateSocketThread TcpIPDevsMonitorThread = new SicmGateSocketThread(threadName, SicmGateDeviceInfo.allGateDeviceMap);
                        TcpIPDevsMonitorThread.addDevToThread(devInfo);
                        TcpIPDevsMonitorThread.start();
                        this.gateDeviceThreadMap.put(threadName, TcpIPDevsMonitorThread);
                        break block5;
                    }
                    int averageCount = SicmGateDeviceInfo.allGateDeviceMap.size() / maxThreadCount;
                    Set<String> threadNameSet = this.gateDeviceThreadMap.keySet();
                    for (String name : threadNameSet) {
                        SicmGateSocketThread curThread = this.gateDeviceThreadMap.get(name);
                        if (curThread.getDevInfoList().size() > averageCount) continue;
                        curThread.addDevToThread(devInfo);
                        break block5;
                    }
                    break block5;
                }
                SicmGateDeviceInfo.allGateDeviceMap.get(deviceIp).setSocket(socket);
                result = true;
            }
            catch (Exception e) {
                result = false;
                this.logger.info((Object)("addDevToMonitorThread exception:" + e));
            }
        }
        return result;
    }

    private SicmGateDeviceInfo assembleDevInfoData(String ipAddress, Socket socket) {
        SicmGateDeviceInfo devInfo = new SicmGateDeviceInfo(ipAddress, socket);
        SicmGateDeviceInfo.allGateDeviceMap.put(ipAddress, devInfo);
        return devInfo;
    }

    private boolean deviceLogin(String ipAddress, Socket socket) {
        boolean registerFlag = false;
        try {
            JSONObject sendData = new JSONObject();
            sendData.put("ip_address", (Object)ipAddress);
            this.sisDeviceService.registryDevice(sendData);
            registerFlag = true;
            this.addDevToMonitorThread(ipAddress, socket);
            this.logger.info((Object)(">>>deviceLogin success<<<" + ipAddress));
        }
        catch (Exception e) {
            registerFlag = false;
            this.logger.info((Object)(">>>\u6ce8\u518c\u5b89\u68c0\u95e8\u8bbe\u5907\u5931\u8d25<<<" + ipAddress));
            this.logger.info((Object)("deviceLogin exception: " + e));
        }
        return registerFlag;
    }

    private Boolean isSocketClose(Socket socket) {
        try {
            socket.sendUrgentData(255);
            return false;
        }
        catch (Exception e) {
            this.logger.info((Object)("isSocketClose exception: " + e));
            return true;
        }
    }

    class SicmGateDeviceImmeCmdThread
    extends Thread {
        SicmGateDeviceImmeCmdThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Thread.sleep(10000L);
                    Iterator<String> iterator = SicmGateDeviceInfo.allGateDeviceMap.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        String key = iterator.next();
                        SicmGateDeviceInfo.allGateDeviceMap.get(key).getImmeCmdAndSend();
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SisGateDevCommServer.this.logger.error((Object)("SicmGateDeviceImmeCmdThread exception: " + e));
                return;
            }
        }
    }

    class SicmGateDeviceConnectStatusThread
    extends Thread {
        SicmGateDeviceConnectStatusThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                long time = System.currentTimeMillis();
                while (true) {
                    if (System.currentTimeMillis() - time <= 30000L) {
                        continue;
                    }
                    for (String key : SicmGateDeviceInfo.allGateDeviceMap.keySet()) {
                        if (!SisGateDevCommServer.this.stringRedisTemplate.hasKey((Object)("SIS_GATE_DEVICE_STATUS_" + key)).booleanValue()) continue;
                        Socket socket = SicmGateDeviceInfo.allGateDeviceMap.get(key).getSocket();
                        Boolean isClose = SisGateDevCommServer.this.isSocketClose(socket);
                        if (!isClose.booleanValue()) {
                            SisGateDevCommServer.this.stringRedisTemplate.opsForValue().set((Object)("SIS_GATE_DEVICE_STATUS_" + key), (Object)"0", 35L, TimeUnit.SECONDS);
                            SisGateDevCommServer.this.sisDeviceService.setBoradGateStatusData();
                            continue;
                        }
                        SisGateDevCommServer.this.logger.info((Object)("Gate Device offline \uff1a==========" + key));
                    }
                    time = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                SisGateDevCommServer.this.logger.info((Object)("SicmGateDeviceConnectStatusThread exception: " + e));
                return;
            }
        }
    }

    class SicmGateDeviceCmdSendThread
    extends Thread {
        SicmGateDeviceCmdSendThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(10000L);
                block2: while (true) {
                    Iterator<String> iterator = SicmGateDeviceInfo.allGateDeviceMap.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        String key = iterator.next();
                        SicmGateDeviceInfo.allGateDeviceMap.get(key).getCmdAndSend();
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SisGateDevCommServer.this.logger.error((Object)("SicmGateDeviceCmdSendThread exception: " + e));
                return;
            }
        }
    }

    class SicmGateDeviceListenThread
    extends Thread {
        SicmGateDeviceListenThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30000L);
                SisGateDevCommServer.this.serverSocket = new ServerSocket(6000);
                Socket client = null;
                while (true) {
                    client = SisGateDevCommServer.this.serverSocket.accept();
                    InetAddress address = client.getInetAddress();
                    String clientIp = address.getHostAddress();
                    OutputStream outputStream = client.getOutputStream();
                    byte[] readDevId = new byte[]{104, 50, 50, 50, 52, 52, -32, 70};
                    outputStream.write(readDevId);
                    outputStream.flush();
                    SisGateDevCommServer.this.deviceLogin(clientIp, client);
                }
            }
            catch (Exception e) {
                SisGateDevCommServer.this.logger.error((Object)("SicmGateDeviceListenThread exception: " + e));
                return;
            }
        }
    }
}

