/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleDeviceEventRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceEventService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceEventItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleDeviceEventController
extends BaseController
implements EleDeviceEventRemote {
    @Autowired
    private EleDeviceEventService eleDeviceEventService;

    @RequiresPermissions(value={"ele:deviceEvent"})
    public ModelAndView index() {
        return new ModelAndView("ele/deviceEvent/eleDeviceEvent");
    }

    @RequiresPermissions(value={"ele:deviceEvent:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleDeviceEventService.getItemById(id));
        }
        return new ModelAndView("ele/deviceEvent/editEleDeviceEvent");
    }

    @RequiresPermissions(value={"ele:deviceEvent:edit"})
    public ZKResultMsg save(EleDeviceEventItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleDeviceEventService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:deviceEvent:refresh"})
    public DxGrid list(EleDeviceEventItem condition) {
        Pager pager = this.eleDeviceEventService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:deviceEvent:del"})
    public ZKResultMsg del(String ids) {
        this.eleDeviceEventService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem tree() {
        List eventList = this.eleDeviceEventService.getAllEventNameDistinct();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (EleDeviceEventItem event : eventList) {
            TreeItem item = new TreeItem();
            item.setId(event.getName());
            item.setText(I18nUtil.i18nCode((String)event.getName(), (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

