/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.acc.api.vo.AccApiLevelItem;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/accLevel"})
@Api(tags={"AccLevel"}, description="acc level")
public class AccApiLevelController {
    private static final Logger log = LoggerFactory.getLogger(AccApiLevelController.class);
    @Autowired
    private AccLevelService accLevelService;

    @ApiOperation(value="Get AccLevel By Id", notes="Return AccLevel Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getById/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getById(@PathVariable String id) {
        AccLevelItem accLevel = this.accLevelService.getItemById(id);
        AccApiLevelItem accApiLevelItem = AccApiLevelItem.createApiLevel((AccLevelItem)accLevel);
        return ApiResultMessage.successMessage((Object)accApiLevelItem);
    }

    @ApiOperation(value="Get AccLevel By Name", notes="Return AccLevel Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getByName/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getByName(@PathVariable String name) {
        AccLevelItem accLevelItem = this.accLevelService.getItemByName(name);
        AccApiLevelItem accApiLevelItem = AccApiLevelItem.createApiLevel((AccLevelItem)accLevelItem);
        return ApiResultMessage.successMessage((Object)accApiLevelItem);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get AccLevel List", notes="Return AccLevel List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage rs = new ApiResultMessage();
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.failedMessage((int)-90);
        }
        ArrayList apiAccLevels = Lists.newArrayList();
        List accLevelItemList = this.accLevelService.getItemsByPage((BaseItem)new AccLevelItem(), pageNo - 1, pageSize.intValue()).getData();
        if (!accLevelItemList.isEmpty()) {
            accLevelItemList.forEach(accLevelItem -> {
                AccApiLevelItem accApiLevelItem = AccApiLevelItem.createApiLevel((AccLevelItem)accLevelItem);
                if (accApiLevelItem != null) {
                    apiAccLevels.add(accApiLevelItem);
                }
            });
        }
        rs.setData((Object)apiAccLevels);
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/syncPerson"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Sync Person Level", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage syncPerson(@RequestParam(name="pin") String pin, @RequestParam(name="levelIds") String levelIds) {
        ApiResultMessage rs = null;
        try {
            rs = this.accLevelService.syncApiPersonLevel(pin, levelIds);
        }
        catch (Exception e) {
            log.error("api accLevel/syncPerson error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Delete Person Level", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage deleteLevel(@RequestParam String pin, @RequestParam String levelIds) {
        ApiResultMessage rs = null;
        try {
            rs = this.accLevelService.deleteApiPersonLevel(pin, levelIds);
        }
        catch (Exception e) {
            log.error("api accLevel/deleteLevel error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/syncLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Sync Level", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage syncLevel(@RequestParam(name="levelId") String levelId) {
        ApiResultMessage rs = null;
        try {
            rs = this.accLevelService.syncApiLevel(levelId);
        }
        catch (Exception e) {
            log.error("api accLevel/syncLevel error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

