/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.bean.ResponseInfo;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.AccPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.AiPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.AttPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.InsPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PidPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PosIDPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PosPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PsgPushProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.SecurityProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushProcessor {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AdmsCacheManager admsCacheManager;
    @Autowired
    private AccPushProcessor accPushProcessor;
    @Autowired
    private AttPushProcessor attPushProcessor;
    @Autowired
    private PosPushProcessor posPushProcessor;
    @Autowired
    private PidPushProcessor pidPushProcessor;
    @Autowired
    private PsgPushProcessor psgPushProcessor;
    @Autowired
    private InsPushProcessor insPushProcessor;
    @Autowired
    private AiPushProcessor aiPushProcessor;
    @Autowired
    private SecurityProcessor securityProcessor;
    @Autowired
    private PosIDPushProcessor posIDPushProcessor;

    public ResponseInfo requestData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn, String uri, String requestPath) throws Exception {
        String moduleType = this.validateDevice(sn, uri);
        this.admsCacheManager.updateDevHeartbeat(sn);
        String devJson = this.admsCacheManager.getDeviceInfo(sn);
        String rs = "OK";
        String encoding = "UTF-8";
        if (StringUtils.isBlank((CharSequence)devJson) && (uri.contains("/iclock/getrequest") || uri.contains("/iclock/posrequest"))) {
            rs = this.checkReturnResult(moduleType);
        } else if (!this.admsCacheManager.getDevEnabledState(sn)) {
            rs = moduleType.equals("acc") ? "406" : "UNKNOWN DEVICE";
            this.log.info("device sn=" + sn + " diabled ......");
        } else {
            switch (moduleType) {
                case "acc": {
                    rs = this.accPushProcessor.handleReqData(ctx, httpRequest, sn);
                    break;
                }
                case "att": {
                    rs = this.attPushProcessor.handleReqData(ctx, httpRequest, sn);
                    encoding = this.attPushProcessor.getEncoding(sn);
                    break;
                }
                case "pos": {
                    rs = this.posPushProcessor.handleReqData(ctx, httpRequest, sn);
                    encoding = "GB18030";
                    break;
                }
                case "posid": {
                    rs = this.posIDPushProcessor.handleReqData(ctx, httpRequest, sn);
                    break;
                }
                case "pid": {
                    rs = this.pidPushProcessor.handleReqData(ctx, httpRequest, sn);
                    encoding = this.pidPushProcessor.getEncoding(sn);
                    break;
                }
                case "psg": {
                    rs = this.psgPushProcessor.handleReqData(ctx, httpRequest, sn);
                    break;
                }
                case "ins": {
                    rs = this.insPushProcessor.handleReqData(ctx, httpRequest, sn);
                    encoding = this.insPushProcessor.getEncoding(sn);
                    break;
                }
                case "ai": {
                    rs = this.aiPushProcessor.handleReqData(ctx, httpRequest, sn);
                    break;
                }
                default: {
                    rs = "UNKNOWN DEVICE";
                }
            }
        }
        this.log.debug("responese to device result=" + rs);
        return new ResponseInfo(rs, encoding);
    }

    private String checkReturnResult(String moduleType) {
        String rs = "UNKNOWN DEVICE";
        if ("acc".equals(moduleType) || "psg".equals(moduleType)) {
            rs = "406";
        }
        return rs;
    }

    private String validateDevice(String sn, String uri) {
        String moduleType = this.admsCacheManager.getDevModuleType(sn);
        String deviceType = RequestUtil.getParams(uri, "DeviceType");
        if (StringUtils.isBlank((CharSequence)moduleType)) {
            boolean isAtt;
            boolean isPos;
            if (StringUtils.isNotBlank((CharSequence)deviceType)) {
                this.admsCacheManager.setDevModuleType(sn, deviceType);
                return deviceType;
            }
            boolean bl = isPos = uri.startsWith("/iclock/cpos") || uri.startsWith("/iclock/posrequest") || uri.startsWith("/iclock/posdevicecmd");
            if (isPos) {
                moduleType = "pos";
                this.admsCacheManager.setDevModuleType(sn, moduleType);
                return moduleType;
            }
            boolean bl2 = isAtt = uri.contains("options") && uri.contains("pushver") && uri.contains("language");
            if (isAtt) {
                moduleType = "att";
                this.admsCacheManager.setDevModuleType(sn, moduleType);
                return moduleType;
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)deviceType) && !deviceType.equals(moduleType)) {
                this.admsCacheManager.setDevModuleType(sn, deviceType);
                this.admsCacheManager.removeCmdReturnKey("cache:adms:authDevice:" + sn);
                return deviceType;
            }
            return moduleType;
        }
        return "acc";
    }

    public ResponseInfo securityAuth(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn, String uri) throws Exception {
        String rs = this.securityProcessor.handleReqData(ctx, httpRequest, sn);
        return new ResponseInfo(rs, "UTF-8");
    }
}

