/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisPackageTransactionRemote;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisPackageTransactionService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import com.zkteco.zkbiosecurity.sis.vo.SisPackageTransactionItem;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisPackageTransactionController
extends ExportController
implements SisPackageTransactionRemote {
    @Autowired
    private SisPackageTransactionService sisPackageTransactionService;
    @Autowired
    private SisDeviceService sisDeviceService;

    public ModelAndView index() {
        return new ModelAndView("sis/reports/sisPackageTransaction");
    }

    @RequiresPermissions(value={"sis:packageTransaction:refresh"})
    public DxGrid list(SisPackageTransactionItem condition) {
        if (StringUtils.equals((CharSequence)"1", (CharSequence)condition.getIsLable())) {
            condition.setEventType(new Short("1"));
        }
        Pager pager = this.sisPackageTransactionService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        if (StringUtils.equals((CharSequence)"1", (CharSequence)condition.getIntelligenceRecognition())) {
            List list = pager.getData();
            for (SisPackageTransactionItem item : list) {
                item.setPackagePhotoPath(item.getDangerousGoodsPhotoPath());
                item.setPackagePhotoPath2(item.getDangerousGoodsPhotoPath2());
            }
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:packageTransaction:del"})
    @LogRequest(module="acc_module", object="acc_dev_linkage", opType="common_op_del", requestParams={"names"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.sisPackageTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem getSelectList() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        ArrayList<String> modelList = new ArrayList<String>();
        SisDeviceItem condition = new SisDeviceItem();
        condition.setInType("5030");
        List sisDeviceItemList = this.sisDeviceService.getByCondition(condition);
        if (!sisDeviceItemList.isEmpty()) {
            TreeItem item = null;
            for (SisDeviceItem sisDeviceItem : sisDeviceItemList) {
                item = new TreeItem();
                item.setId(sisDeviceItem.getModel());
                item.setText(sisDeviceItem.getModel());
                if (modelList.contains(sisDeviceItem.getModel())) continue;
                modelList.add(sisDeviceItem.getModel());
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"sis:packageTransaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        SisPackageTransactionItem sisPassBatTransactionItem = new SisPackageTransactionItem();
        this.setConditionValue((BaseItem)sisPassBatTransactionItem);
        List itemList = this.sisPackageTransactionService.getItemData(SisPackageTransactionItem.class, (BaseItem)sisPassBatTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, SisPackageTransactionItem.class);
    }

    public ZKResultMsg getDeviceLatestTrans() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String devIds = this.request.getParameter("devIds");
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            JSONArray data = this.sisPackageTransactionService.getLatestTransByDevIds(devIds);
            resultMsg.setData((Object)data);
        }
        return resultMsg;
    }

    public ZKResultMsg isFileExist(String vidLinkageHandle) {
        boolean isExist = this.sisPackageTransactionService.isFileExist(vidLinkageHandle);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)String.valueOf(isExist)));
    }

    public ZKResultMsg getPackageCounts() throws ParseException {
        ZKResultMsg resultMsg = new ZKResultMsg();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        String staet = this.request.getParameter("effectStartTime");
        startTime = sdf.parse(staet);
        String end = this.request.getParameter("effectEndTime");
        endTime = sdf.parse(end);
        JSONObject ret = this.sisPackageTransactionService.getAllDevicePackageCounts(startTime, endTime);
        resultMsg.setData((Object)ret);
        return resultMsg;
    }

    public ZKResultMsg getArtworkMaster(String uniqueKey) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        SisPackageTransactionItem item = this.sisPackageTransactionService.findItemByUniqueKey(uniqueKey);
        resultMsg.setData((Object)item);
        return resultMsg;
    }

    public ZKResultMsg getDevicePackageDate() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject obj = this.sisPackageTransactionService.getDoardPackageDate();
        resultMsg.setData((Object)obj);
        return resultMsg;
    }

    public ZKResultMsg getDeviceWarningPackageDate() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject obj = this.sisPackageTransactionService.getDoardWarningPackageDate();
        resultMsg.setData((Object)obj);
        return resultMsg;
    }
}

