/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.EmptyUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.constants.InsDeviceConstant;
import com.zkteco.zkbiosecurity.ins.remote.InsDeviceRemote;
import com.zkteco.zkbiosecurity.ins.service.InsDeviceOptionService;
import com.zkteco.zkbiosecurity.ins.service.InsDeviceService;
import com.zkteco.zkbiosecurity.ins.vo.InsDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsDeviceController
extends BaseController
implements InsDeviceRemote {
    @Autowired
    private InsDeviceService insDeviceService;
    @Autowired
    private InsDeviceOptionService insDeviceOptionService;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;

    @RequiresPermissions(value={"ins:device"})
    public ModelAndView index() {
        return new ModelAndView("ins/device/insDevice");
    }

    @RequiresPermissions(value={"ins:device:edit"})
    public ModelAndView edit(String id, String ipAddress, String devSn) {
        InsDeviceItem insDeviceItem = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            insDeviceItem = this.insDeviceService.getItemById(id);
        } else {
            insDeviceItem = new InsDeviceItem();
            insDeviceItem.setDevName(devSn);
            insDeviceItem.setSn(devSn);
            insDeviceItem.setIpAddress(ipAddress);
            insDeviceItem.setIsRegDevice(Boolean.valueOf(false));
            insDeviceItem.setTimeZone(DateFormatUtils.format((Date)new Date(), (String)"Z"));
        }
        this.request.setAttribute("item", (Object)insDeviceItem);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("ins/device/editInsDevice");
    }

    @LogRequest(module="ins_module", object="ins_device_manager", opType="common_op_add", requestParams={"devName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"ins:device:edit"})
    public ZKResultMsg save(InsDeviceItem item) {
        if (StringUtils.isBlank((CharSequence)item.getId())) {
            item.setStatus(Boolean.valueOf(true));
        } else {
            this.insDeviceService.updateEditInfo(item.getId(), item.getDevName(), item.getAuthAreaId(), item.getTimeZone(), item.getIsRegDevice());
        }
        ZKResultMsg res = this.insDeviceService.authDevice(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:device:refresh"})
    public DxGrid list(InsDeviceItem codition) {
        Pager pager = this.insDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        List insDeviceItems = pager.getData();
        if (EmptyUtil.isNotEmpty((Collection)insDeviceItems)) {
            for (InsDeviceItem insDeviceItem : insDeviceItems) {
                insDeviceItem.setWaitCmdCount(this.insDeviceService.getWaitCmdCount(insDeviceItem.getSn()));
                insDeviceItem.setOnlineStatus(this.insDeviceService.getDevStatus(insDeviceItem.getSn()));
            }
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="ins_module", object="ins_device_manager", opType="common_op_del", requestParams={"devName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"ins:device:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.insDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getAllIPSn() {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.insDeviceService.getAllIPSn()));
    }

    @RequiresPermissions(value={"ins:device:search"})
    public ZKResultMsg searchDev(Long nowTime) {
        HashMap<String, Object> devInfo = new HashMap<String, Object>();
        List devcieItems = this.insDeviceService.searchDeviceList();
        devInfo.put("devCount", devcieItems.size());
        devInfo.put("devData", devcieItems);
        devInfo.put("nowTime", nowTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(devInfo));
    }

    public boolean isExistDevName(String devName) {
        return this.insDeviceService.isExistDevName(devName);
    }

    public boolean isExistSn(String sn) {
        return this.insDeviceService.isExistSn(sn);
    }

    @RequiresPermissions(value={"ins:device:search"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("ins/device/opInsSearchDev");
    }

    @RequiresPermissions(value={"ins:device:enable"})
    @LogRequest(module="ins_module", object="ins_device_manager", opType="common_enable", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg enable(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:disable"})
    @LogRequest(module="ins_module", object="ins_device_manager", opType="common_disable", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg disable(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:syncdev"})
    @LogRequest(module="ins_module", object="ins_device_manager", opType="ins_op_syncDev", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg syncDev(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.syncDev(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public ZKResultMsg checkDeviceStatus(String ids) {
        if (!this.insDeviceService.checkDeviceStatus(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"ins_device_disabledOrOffline", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"ins:device:reboot"})
    @LogRequest(module="ins_module", object="ins_device_manager", opType="common_dev_reboot", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg reboot(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.reboot(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:getdevopt"})
    public ZKResultMsg getDevOpt(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.getDevOpt(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:queryOption"})
    public ZKResultMsg queryDeviceOption(String devId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        Map optionMap = this.insDeviceOptionService.getOptionMapByDevId(devId);
        if (optionMap.isEmpty()) {
            return resultMsg;
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        int i = 0;
        while (i < InsDeviceConstant.INS_DEVICE_OPTION_SHOWLIST.size()) {
            String optionName = null;
            String optionValue = null;
            jsonObject = new JSONObject();
            if (i < 4) {
                String optionKey1 = (String)InsDeviceConstant.INS_DEVICE_OPTION_SHOWLIST.get(i);
                String optionKey2 = (String)InsDeviceConstant.INS_DEVICE_OPTION_SHOWLIST.get(i + 1);
                optionName = I18nUtil.i18nCode((String)((String)InsDeviceConstant.INS_DEVICE_OPTION_I18N.get(optionKey1)), (Object[])new Object[0]) + "/" + I18nUtil.i18nCode((String)((String)InsDeviceConstant.INS_DEVICE_OPTION_I18N.get(optionKey2)), (Object[])new Object[0]);
                optionValue = optionKey2.contains("AttLog") ? (String)optionMap.get(optionKey1) + "/" + Integer.valueOf((String)optionMap.get(optionKey2)) * 10000 : (optionKey2.contains("FaceCount") || optionKey2.contains("PhotoCount") ? (optionMap.get(optionKey1) == null ? "0" : (String)optionMap.get(optionKey1)) + "/" + (String)optionMap.get(optionKey2) : (String)optionMap.get(optionKey1) + "/" + Integer.valueOf((String)optionMap.get(optionKey2)) * 100);
                jsonObject.put("optionName", (Object)optionName);
                jsonObject.put("optionValue", (Object)optionValue);
                i += 2;
            } else {
                String optionKey = (String)InsDeviceConstant.INS_DEVICE_OPTION_SHOWLIST.get(i);
                optionName = I18nUtil.i18nCode((String)((String)InsDeviceConstant.INS_DEVICE_OPTION_I18N.get(optionKey)), (Object[])new Object[0]);
                optionValue = (String)optionMap.get(optionKey);
                jsonObject.put("optionName", (Object)optionName);
                jsonObject.put("optionValue", (Object)optionValue);
                ++i;
            }
            jsonArray.add((Object)jsonObject);
        }
        resultMsg.setData((Object)jsonArray);
        return resultMsg;
    }

    @RequiresPermissions(value={"ins:device:setstamp"})
    public ModelAndView setStamp(String ids) {
        boolean isRegDevice = this.insDeviceService.checkIsRegDeviceById(ids);
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("isRegDevice", (Object)isRegDevice);
        return new ModelAndView("ins/device/insSetStamp");
    }

    @RequiresPermissions(value={"ins:device:fillpin"})
    public ModelAndView fillPin(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("ins/device/insSetFillPin");
    }

    @RequiresPermissions(value={"ins:device:sendqraddress"})
    public ModelAndView sendQrAddress(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("qrCodeAddress", (Object)this.insDeviceService.getQrCode());
        return new ModelAndView("ins/device/insSendQrAddress");
    }

    @RequiresPermissions(value={"ins:device:sendqraddress"})
    public ZKResultMsg setQrCodeAddress(String ids, String qrCodeAddress) {
        ZKResultMsg zKResultMsg = this.insDeviceService.setQrCodeAddress(ids, qrCodeAddress);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:fillpin"})
    public ZKResultMsg getPersonInfo(String ids, String pin) {
        ZKResultMsg zKResultMsg = this.insDeviceService.getPersonInfo(ids, pin);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:setstamp"})
    public ZKResultMsg reUpload(String ids) {
        String isUploadInsLog = this.request.getParameter("isUploadInsLog") == null ? "0" : "1";
        String isUploadOperLog = this.request.getParameter("isUploadOperLog") == null ? "0" : "1";
        String isUploadPersonPhoto = this.request.getParameter("isUploadPersonPhoto") == null ? "0" : "1";
        ZKResultMsg zKResultMsg = this.insDeviceService.reUpload(ids, isUploadInsLog, isUploadOperLog, isUploadPersonPhoto);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:deletecmd"})
    @LogRequest(module="ins_module", object="ins_leftMenu_device", opType="ins_op_deleteCmd", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg deleteCmd(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.deleteCmd(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:clearinslog"})
    @LogRequest(module="ins_module", object="ins_leftMenu_device", opType="ins_op_clearInsLog", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg clearInsLog(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.clearInsLog(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"ins:device:clearinspic"})
    @LogRequest(module="ins_module", object="ins_leftMenu_device", opType="ins_op_clearInsPic", requestParams={"names"}, opContent="common_dev_name")
    public ZKResultMsg clearInsPic(String ids) {
        ZKResultMsg zKResultMsg = this.insDeviceService.clearInsPic(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public ZKResultMsg checkExitIsRegDevice(String ids) {
        if (!this.insDeviceService.checkDeviceStatus(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"ins_device_disabledOrOffline", (Object[])new Object[0]));
        }
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (this.insDeviceService.checkIsRegDeviceById(ids)) {
            resultMsg.setRet("isReg");
        } else {
            resultMsg.setRet("noIsReg");
        }
        return resultMsg;
    }
}

