/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.gss.GSSCallbackHandler;
import org.postgresql.gss.GssAction;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class MakeGSS {
    public static void authenticate(PGStream pgStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, Logger logger, boolean useSpnego) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" <=BE AuthenticationReqGSS");
        }
        Object result = null;
        if (jaasApplicationName == null) {
            jaasApplicationName = "pgjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
            lc.login();
            Subject sub = lc.getSubject();
            GssAction action = new GssAction(pgStream, host, user, password, kerberosServerName, logger, useSpnego);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e2) {
            throw new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)e2);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

