/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedUpdatableResultSet;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

class UpdatableResultSet
extends GeneratedUpdatableResultSet {
    static final int concurrencyType = 1008;
    static final int BEGIN_COLUMN_INDEX = 0;
    private int wasNull;
    private static int _MIN_STREAM_SIZE = 4000;
    OracleResultSet resultSet;
    boolean isCachedRset;
    OracleStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    UpdatableResultSet(OracleStatement oracleStatement, OracleResultSet oracleResultSet) throws SQLException {
        super(oracleStatement, oracleResultSet);
        this.resultSet = oracleResultSet;
        this.scrollStmt = oracleStatement;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.wasNull = -1;
        this.rsetMetaData = null;
        this.columnCount = 0;
        this.getInternalMetadata();
        this.isCachedRset = true;
    }

    @Override
    void ensureOpen() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.resultSet == null || this.scrollStmt == null || this.scrollStmt.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            if (this.deleteStmt != null) {
                this.deleteStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            this.cancelRowInserts();
            this.connection = LogicalConnection.closedConnection;
            this.resultSet = null;
            this.scrollStmt = null;
            this.rsetMetaData = null;
            this.scrollStmt = null;
            this.deleteStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.indexColsChanged = null;
            this.rowBuffer = null;
            this.m_nullIndicator = null;
            this.typeInfo = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            switch (this.wasNull) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 4: {
                    return this.resultSet.wasNull();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.scrollStmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            SQLWarning sQLWarning = this.resultSet.getWarnings();
            if (this.sqlWarning == null) {
                return sQLWarning;
            }
            SQLWarning sQLWarning2 = this.sqlWarning;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
            return this.sqlWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.sqlWarning = null;
            this.resultSet.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.resultSet.getAuthorizationIndicator(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                this.isRowDeleted = false;
                return this.resultSet.isValidRow();
            }
            return this.resultSet.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                return this.resultSet.isFirst();
            }
            return this.resultSet.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.resultSet.isFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.resultSet.isLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.beforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.afterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.resultSet.getRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.absolute(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                --n2;
                this.isRowDeleted = false;
            }
            return this.resultSet.relative(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.previous();
        }
    }

    @Override
    void addToTempLobsToFree(Clob clob) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(clob);
    }

    @Override
    void addToTempLobsToFree(Blob blob) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(blob);
    }

    @Override
    void cleanTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
    }

    @Override
    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.findColumn(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchDirection(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchDirection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchSize();
        }
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return this.scrollStmt.realRsetType.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1008;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.isRowDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.prepareInsertRowStatement();
            this.prepareInsertRowBinds();
            this.executeInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n2 = this.getNumColumnsChanged();
            if (n2 > 0) {
                this.prepareUpdateRowStatement(n2);
                this.prepareUpdateRowBinds(n2);
                this.executeUpdateRow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.prepareDeleteRowStatement();
            this.prepareDeleteRowBinds();
            this.executeDeleteRow();
            this.isRowDeleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.resultSet.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isUpdating) {
                this.isUpdating = false;
                this.clearRowBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                return;
            }
            this.isRowDeleted = false;
            this.isInserting = true;
            if (this.rowBuffer == null) {
                this.rowBuffer = new Object[this.getColumnCount()];
            }
            if (this.m_nullIndicator == null) {
                this.m_nullIndicator = new boolean[this.getColumnCount()];
            }
            this.clearRowBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.cancelRowInserts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            assert (clazz != null) : "type: null";
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            T t2 = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    t2 = datum.toClass(clazz);
                }
            } else {
                this.setIsNull(4);
                t2 = this.resultSet.getObject(n2, clazz);
            }
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet.getColumnCount();
        }
        return this.columnCount;
    }

    @Override
    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return this.rsetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRowChanges() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isInserting) {
                this.cancelRowInserts();
            }
            if (this.isUpdating) {
                this.cancelRowUpdates();
            }
        }
    }

    @Override
    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearRowBuffer();
        }
    }

    @Override
    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void clearRowBuffer() {
        int n2;
        if (this.rowBuffer != null) {
            for (n2 = 0; n2 < this.rowBuffer.length; ++n2) {
                this.rowBuffer[n2] = null;
            }
        }
        if (this.m_nullIndicator != null) {
            for (n2 = 0; n2 < this.m_nullIndicator.length; ++n2) {
                this.m_nullIndicator[n2] = false;
            }
        }
        if (this.typeInfo != null) {
            for (n2 = 0; n2 < this.typeInfo.length; ++n2) {
                if (this.typeInfo[n2] == null) continue;
                for (int i2 = 0; i2 < this.typeInfo[n2].length; ++i2) {
                    this.typeInfo[n2][i2] = 0;
                }
            }
        }
        this.cleanTempLobs();
    }

    @Override
    protected void setRowBufferAt(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum, null);
    }

    @Override
    protected void setRowBufferAt(int n2, Object object, int[] nArray) throws SQLException {
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isUpdating = true;
        }
        if (n2 < 1 || n2 > this.getColumnCount()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setRowBufferAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.m_nullIndicator[i2] = false;
            }
        }
        if (nArray != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[n2 - 1] = nArray;
        }
        this.rowBuffer[n2 - 1] = object;
        this.m_nullIndicator[n2 - 1] = object == null;
    }

    @Override
    protected Datum getRowBufferDatumAt(int n2) throws SQLException {
        Object object;
        if (n2 < 1 || n2 > this.getColumnCount()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Datum datum = null;
        if (this.rowBuffer != null && (object = this.rowBuffer[n2 - 1]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n2), null, oracleResultSetMetaData.isNCHAR(n2));
                this.rowBuffer[n2 - 1] = datum;
            }
        }
        return datum;
    }

    @Override
    protected Object getRowBufferAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[n2 - 1];
        }
        return null;
    }

    @Override
    protected boolean isRowBufferUpdatedAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[n2 - 1] != null || this.m_nullIndicator[n2 - 1];
    }

    private void prepareInsertRowStatement() throws SQLException {
        if (this.insertStmt == null) {
            String string = this.scrollStmt.sqlObject.getInsertSqlForUpdatableResultSet(this);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.insertStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.insertStmt, n2);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i2 = 1; i2 <= this.getColumnCount(); ++i2) {
            Object object = this.getRowBufferAt(i2);
            if (object != null) {
                if (object instanceof Reader) {
                    if (oracleResultSetMetaData.isNCHAR(i2)) {
                        this.insertStmt.setFormOfUse(n2 + i2 - 1, (short)2);
                    }
                    this.insertStmt.setCharacterStream(n2 + i2 - 1, (Reader)object, this.typeInfo[i2 - 1][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[i2 - 1][1] == 2) {
                        this.insertStmt.setBinaryStream(n2 + i2 - 1, (InputStream)object, this.typeInfo[i2 - 1][0]);
                        continue;
                    }
                    if (this.typeInfo[i2 - 1][1] != 1) continue;
                    this.insertStmt.setAsciiStream(n2 + i2 - 1, (InputStream)object, this.typeInfo[i2 - 1][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(i2);
                if (oracleResultSetMetaData.isNCHAR(i2)) {
                    this.insertStmt.setFormOfUse(n2 + i2 - 1, (short)2);
                }
                this.insertStmt.setOracleObject(n2 + i2 - 1, datum);
                continue;
            }
            int n3 = this.getInternalMetadata().getColumnType(i2);
            if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003 || n3 == 2009) {
                this.insertStmt.setNull(n2 + i2 - 1, n3, this.getInternalMetadata().getColumnTypeName(i2));
                continue;
            }
            this.insertStmt.setNull(n2 + i2 - 1, n3);
        }
    }

    private void executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private int getNumColumnsChanged() throws SQLException {
        int n2 = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                if (this.rowBuffer[i2] == null && (this.rowBuffer[i2] != null || !this.m_nullIndicator[i2])) continue;
                this.indexColsChanged[n2++] = i2;
            }
        }
        return n2;
    }

    private void prepareUpdateRowStatement(int n2) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        String string = this.scrollStmt.sqlObject.getUpdateSqlForUpdatableResultSet(this, n2, this.rowBuffer, this.indexColsChanged);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
        this.updateStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
        if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
            this.updateStmt.setEscapeProcessing(true);
        }
    }

    private void prepareUpdateRowBinds(int n2) throws SQLException {
        int n3 = 1;
        n3 = this.prepareSubqueryBinds(this.updateStmt, n3);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.indexColsChanged[i2];
            Object object = this.getRowBufferAt(n4 + 1);
            if (object != null) {
                if (object instanceof Reader) {
                    if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                        this.updateStmt.setFormOfUse(n3, (short)2);
                    }
                    this.updateStmt.setCharacterStream(n3++, (Reader)object, this.typeInfo[n4][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[n4][1] == 2) {
                        this.updateStmt.setBinaryStream(n3++, (InputStream)object, this.typeInfo[n4][0]);
                        continue;
                    }
                    if (this.typeInfo[n4][1] != 1) continue;
                    this.updateStmt.setAsciiStream(n3++, (InputStream)object, this.typeInfo[n4][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(n4 + 1);
                if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                    this.updateStmt.setFormOfUse(n3, (short)2);
                }
                this.updateStmt.setOracleObject(n3++, datum);
                continue;
            }
            int n5 = this.getInternalMetadata().getColumnType(n4 + 1);
            if (n5 == 2006 || n5 == 2002 || n5 == 2008 || n5 == 2007 || n5 == 2003 || n5 == 2009) {
                this.updateStmt.setNull(n3++, n5, this.getInternalMetadata().getColumnTypeName(n4 + 1));
                continue;
            }
            if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                this.updateStmt.setFormOfUse(n3, (short)2);
            }
            this.updateStmt.setNull(n3++, n5);
        }
        this.prepareCompareSelfBinds(this.updateStmt, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateRow() throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isCachedRset) {
                this.refreshRows(this.getRow(), 1);
                this.cancelRowUpdates();
            }
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    @Override
    int refreshRows(int n2, int n3) throws SQLException {
        return this.resultSet.refreshRows(n2, n3);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            String string = this.scrollStmt.sqlObject.getDeleteSqlForUpdatableResultSet(this);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.deleteStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.deleteStmt, n2);
        this.prepareCompareSelfBinds(this.deleteStmt, n2);
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.isCachedRset) {
            this.removeCurrentRowFromCache();
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        this.resultSet.removeCurrentRowFromCache();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        oraclePreparedStatement.setRowId(n2, ((InsensitiveScrollableResultSet)this.resultSet).getPrependedRowId());
        return n2 + 1;
    }

    private int prepareSubqueryBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        return n2 + this.scrollStmt.copyBinds(oraclePreparedStatement, n2 - 1);
    }

    @Override
    protected void setIsNull(int n2) {
        this.wasNull = n2;
    }

    @Override
    protected void setIsNull(boolean bl) {
        this.setIsNull(bl ? 1 : 2);
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
        this.resultSet.doneFetchingRows(bl);
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }
}

