/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.fabric.proto.xmlrpc;

import com.mysql.fabric.FabricCommunicationException;
import com.mysql.fabric.proto.xmlrpc.XmlRpcMethodCaller;
import com.mysql.fabric.xmlrpc.Client;
import com.mysql.fabric.xmlrpc.base.Array;
import com.mysql.fabric.xmlrpc.base.Member;
import com.mysql.fabric.xmlrpc.base.MethodCall;
import com.mysql.fabric.xmlrpc.base.MethodResponse;
import com.mysql.fabric.xmlrpc.base.Param;
import com.mysql.fabric.xmlrpc.base.Params;
import com.mysql.fabric.xmlrpc.base.Struct;
import com.mysql.fabric.xmlrpc.base.Value;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InternalXmlRpcMethodCaller
implements XmlRpcMethodCaller {
    private Client xmlRpcClient;

    public InternalXmlRpcMethodCaller(String url) throws FabricCommunicationException {
        try {
            this.xmlRpcClient = new Client(url);
        }
        catch (MalformedURLException ex) {
            throw new FabricCommunicationException(ex);
        }
    }

    private Object unwrapValue(Value v2) {
        if (v2.getType() == 8) {
            return this.methodResponseArrayToList((Array)v2.getValue());
        }
        if (v2.getType() == 7) {
            HashMap<String, Object> s2 = new HashMap<String, Object>();
            for (Member m2 : ((Struct)v2.getValue()).getMember()) {
                s2.put(m2.getName(), this.unwrapValue(m2.getValue()));
            }
            return s2;
        }
        return v2.getValue();
    }

    private List methodResponseArrayToList(Array array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Value v2 : array.getData().getValue()) {
            result.add(this.unwrapValue(v2));
        }
        return result;
    }

    public void setHeader(String name, String value) {
        this.xmlRpcClient.setHeader(name, value);
    }

    public void clearHeader(String name) {
        this.xmlRpcClient.clearHeader(name);
    }

    public List call(String methodName, Object[] args) throws FabricCommunicationException {
        MethodCall methodCall = new MethodCall();
        Params p2 = new Params();
        if (args == null) {
            args = new Object[]{};
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2] == null) {
                throw new NullPointerException("nil args unsupported");
            }
            if (String.class.isAssignableFrom(args[i2].getClass())) {
                p2.addParam(new Param(new Value((String)args[i2])));
                continue;
            }
            if (Double.class.isAssignableFrom(args[i2].getClass())) {
                p2.addParam(new Param(new Value((Double)args[i2])));
                continue;
            }
            if (Integer.class.isAssignableFrom(args[i2].getClass())) {
                p2.addParam(new Param(new Value((Integer)args[i2])));
                continue;
            }
            throw new IllegalArgumentException("Unknown argument type: " + args[i2].getClass());
        }
        methodCall.setMethodName(methodName);
        methodCall.setParams(p2);
        try {
            MethodResponse resp = this.xmlRpcClient.execute(methodCall);
            return this.methodResponseArrayToList((Array)resp.getParams().getParam().get(0).getValue().getValue());
        }
        catch (Exception ex) {
            throw new FabricCommunicationException("Error during call to `" + methodName + "' (args=" + args + ")", ex);
        }
    }
}

