/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;

final class StreamTabName
extends StreamPacket {
    private TDSReader tdsReader;
    private TDSReaderMark tableNamesMark;

    StreamTabName() {
        super(164);
    }

    @Override
    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        if (164 != tDSReader.readUnsignedByte()) assert (false) : "Not a TABNAME token";
        this.tdsReader = tDSReader;
        int n2 = tDSReader.readUnsignedShort();
        this.tableNamesMark = tDSReader.mark();
        tDSReader.skip(n2);
    }

    void applyTo(Column[] columnArray, int n2) throws SQLServerException {
        int n3;
        TDSReaderMark tDSReaderMark = this.tdsReader.mark();
        this.tdsReader.reset(this.tableNamesMark);
        SQLIdentifier[] sQLIdentifierArray = new SQLIdentifier[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            sQLIdentifierArray[n3] = this.tdsReader.readSQLIdentifier();
        }
        for (n3 = 0; n3 < columnArray.length; ++n3) {
            Column column = columnArray[n3];
            if (column.getTableNum() <= 0) continue;
            column.setTableName(sQLIdentifierArray[column.getTableNum() - 1]);
        }
        this.tdsReader.reset(tDSReaderMark);
    }
}

