/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerBlobOutputStream;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerBlob
implements Blob,
Serializable {
    private byte[] value;
    private SQLServerConnection con;
    private boolean isClosed = false;
    ArrayList<Closeable> activeStreams = new ArrayList(1);
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerBlob");
    private static int baseID = 0;
    private final String traceID = " SQLServerBlob:" + SQLServerBlob.nextInstanceID();

    public final String toString() {
        return this.traceID;
    }

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    @Deprecated
    public SQLServerBlob(SQLServerConnection sQLServerConnection, byte[] byArray) {
        this.con = sQLServerConnection;
        if (null == byArray) {
            throw new NullPointerException(SQLServerException.getErrString("R_cantSetNull"));
        }
        this.value = byArray;
        if (logger.isLoggable(Level.FINE)) {
            String string = null != sQLServerConnection ? sQLServerConnection.toString() : "null connection";
            logger.fine(this.toString() + " created by (" + string + ")");
        }
    }

    SQLServerBlob(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.value = new byte[0];
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerConnection.toString() + ")");
        }
    }

    SQLServerBlob(BaseInputStream baseInputStream) throws SQLServerException {
        this.value = baseInputStream.getBytes();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (null connection)");
        }
    }

    @Override
    public void free() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (!this.isClosed) {
            if (null != this.activeStreams) {
                for (Closeable closeable : this.activeStreams) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        logger.fine(this.toString() + " ignored IOException closing stream " + closeable + ": " + iOException.getMessage());
                    }
                }
                this.activeStreams = null;
            }
            this.value = null;
            this.isClosed = true;
        }
    }

    private final void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_isFreed"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{"Blob"}), null, true);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        return this.getBinaryStreamInternal(0, this.value.length);
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    private InputStream getBinaryStreamInternal(int n2, int n3) {
        assert (null != this.value);
        assert (n2 >= 0);
        assert (0 <= n3 && n3 <= this.value.length - n2);
        assert (null != this.activeStreams);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.value, n2, n3);
        this.activeStreams.add(byteArrayInputStream);
        return byteArrayInputStream;
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        Object[] objectArray;
        Object object;
        this.checkClosed();
        if (l2 < 1L) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n2 < 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (--l2 > (long)this.value.length) {
            l2 = this.value.length;
        }
        if ((long)n2 > (long)this.value.length - l2) {
            n2 = (int)((long)this.value.length - l2);
        }
        object = new byte[n2];
        System.arraycopy(this.value, (int)l2, object, 0, n2);
        return object;
    }

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        return this.value.length;
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == blob) {
            return -1L;
        }
        return this.position(blob.getBytes(1L, (int)blob.length()), l2);
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
        }
        if (null == byArray) {
            return -1L;
        }
        for (int i2 = (int)(--l2); i2 <= this.value.length - byArray.length; ++i2) {
            boolean bl = true;
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                if (this.value[i2 + i3] == byArray[i3]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i2 + 1;
        }
        return -1L;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        Object object;
        this.checkClosed();
        if (l2 < 0L) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if ((long)this.value.length > l2) {
            object = new byte[(int)l2];
            System.arraycopy(this.value, 0, object, 0, (int)l2);
            this.value = (byte[])object;
        }
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(new Object[]{l2}), null, true);
        }
        return new SQLServerBlobOutputStream(this, l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        this.checkClosed();
        if (null == byArray) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        Object[] objectArray;
        Object object;
        this.checkClosed();
        if (null == byArray) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_cantSetNull"), null, true);
        }
        if (n2 < 0 || n2 > byArray.length) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidOffset"));
            objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (n3 < 0 || n3 > byArray.length - n2) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            objectArray = new Object[]{new Integer(n3)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if (l2 <= 0L || l2 > (long)(this.value.length + 1)) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPositionIndex"));
            objectArray = new Object[]{new Long(l2)};
            SQLServerException.makeFromDriverError(this.con, null, ((Format)object).format(objectArray), null, true);
        }
        if ((long)n3 >= (long)this.value.length - --l2) {
            DataTypes.getCheckedLength(this.con, JDBCType.BLOB, l2 + (long)n3, false);
            assert (l2 + (long)n3 <= Integer.MAX_VALUE);
            object = new byte[(int)l2 + n3];
            System.arraycopy(this.value, 0, object, 0, (int)l2);
            System.arraycopy(byArray, n2, object, (int)l2, n3);
            this.value = (byte[])object;
        } else {
            System.arraycopy(byArray, n2, this.value, (int)l2, n3);
        }
        return n3;
    }
}

