/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESConstants;
import com.sun.crypto.provider.DESKey;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.util.KeyUtil;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private boolean generateSecret = false;
    private BigInteger init_p = null;
    private BigInteger init_g = null;
    private BigInteger x = BigInteger.ZERO;
    private BigInteger y = BigInteger.ZERO;

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(key, null, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.generateSecret = false;
        this.init_p = null;
        this.init_g = null;
        if (params != null && !(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Diffie-Hellman parameters expected");
        }
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Diffie-Hellman private key expected");
        }
        DHPrivateKey dhPrivKey = (DHPrivateKey)key;
        if (params != null) {
            this.init_p = ((DHParameterSpec)params).getP();
            this.init_g = ((DHParameterSpec)params).getG();
        }
        BigInteger priv_p = dhPrivKey.getParams().getP();
        BigInteger priv_g = dhPrivKey.getParams().getG();
        if (this.init_p != null && priv_p != null && !this.init_p.equals(priv_p)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_g != null && priv_g != null && !this.init_g.equals(priv_g)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.init_p == null && priv_p == null || this.init_g == null && priv_g == null) {
            throw new InvalidKeyException("Missing parameters");
        }
        this.init_p = priv_p;
        this.init_g = priv_g;
        this.x = dhPrivKey.getX();
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof javax.crypto.interfaces.DHPublicKey)) {
            throw new InvalidKeyException("Diffie-Hellman public key expected");
        }
        javax.crypto.interfaces.DHPublicKey dhPubKey = (javax.crypto.interfaces.DHPublicKey)key;
        if (this.init_p == null || this.init_g == null) {
            throw new IllegalStateException("Not initialized");
        }
        BigInteger pub_p = dhPubKey.getParams().getP();
        BigInteger pub_g = dhPubKey.getParams().getG();
        if (pub_p != null && !this.init_p.equals(pub_p)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (pub_g != null && !this.init_g.equals(pub_g)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        KeyUtil.validate(dhPubKey);
        this.y = dhPubKey.getY();
        this.generateSecret = true;
        if (!lastPhase) {
            byte[] intermediate = this.engineGenerateSecret();
            return new DHPublicKey(new BigInteger(1, intermediate), this.init_p, this.init_g);
        }
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        int expectedLen = this.init_p.bitLength() + 7 >>> 3;
        byte[] result = new byte[expectedLen];
        try {
            this.engineGenerateSecret(result, 0);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (!this.generateSecret) {
            throw new IllegalStateException("Key agreement has not been completed yet");
        }
        if (sharedSecret == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        BigInteger modulus = this.init_p;
        int expectedLen = modulus.bitLength() + 7 >>> 3;
        if (sharedSecret.length - offset < expectedLen) {
            throw new ShortBufferException("Buffer too short for shared secret");
        }
        this.generateSecret = false;
        byte[] secret = this.y.modPow(this.x, modulus).toByteArray();
        if (secret.length == expectedLen) {
            System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        } else if (secret.length < expectedLen) {
            System.arraycopy(secret, 0, sharedSecret, offset + (expectedLen - secret.length), secret.length);
        } else if (secret.length == expectedLen + 1 && secret[0] == 0) {
            System.arraycopy(secret, 1, sharedSecret, offset, expectedLen);
        } else {
            throw new ProviderException("Generated secret is out-of-range");
        }
        return expectedLen;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("null algorithm");
        }
        if (!algorithm.equalsIgnoreCase("TlsPremasterSecret") && !AllowKDF.VALUE) {
            throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + algorithm);
        }
        byte[] secret = this.engineGenerateSecret();
        if (algorithm.equalsIgnoreCase("DES")) {
            return new DESKey(secret);
        }
        if (algorithm.equalsIgnoreCase("DESede") || algorithm.equalsIgnoreCase("TripleDES")) {
            return new DESedeKey(secret);
        }
        if (algorithm.equalsIgnoreCase("Blowfish")) {
            int keysize = secret.length;
            if (keysize >= 56) {
                keysize = 56;
            }
            SecretKeySpec skey = new SecretKeySpec(secret, 0, keysize, "Blowfish");
            return skey;
        }
        if (algorithm.equalsIgnoreCase("AES")) {
            int keysize = secret.length;
            SecretKeySpec skey = null;
            for (int idx = AESConstants.AES_KEYSIZES.length - 1; skey == null && idx >= 0; --idx) {
                if (keysize < AESConstants.AES_KEYSIZES[idx]) continue;
                keysize = AESConstants.AES_KEYSIZES[idx];
                skey = new SecretKeySpec(secret, 0, keysize, "AES");
            }
            if (skey == null) {
                throw new InvalidKeyException("Key material is too short");
            }
            return skey;
        }
        if (algorithm.equals("TlsPremasterSecret")) {
            return new SecretKeySpec(KeyUtil.trimZeroes(secret), "TlsPremasterSecret");
        }
        throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + algorithm);
    }

    private static class AllowKDF {
        private static final boolean VALUE = AllowKDF.getValue();

        private AllowKDF() {
        }

        private static boolean getValue() {
            return AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.crypto.KeyAgreement.legacyKDF"));
        }
    }
}

