/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService;

import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.WebsocketServerHandler;
import com.zkteco.zkbiosecurity.park.websocketService.WsDispatcher;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebsocketServerInitializer
extends ChannelInitializer<SocketChannel> {
    private String ishttps;
    private WsDispatcher wsDispatcher;
    private ChannelService channelService;

    public WebsocketServerInitializer(WsDispatcher wsDispatcher, ChannelService channelService, String ishttps) {
        this.wsDispatcher = wsDispatcher;
        this.channelService = channelService;
        this.ishttps = ishttps;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x640000));
        pipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)new WebsocketServerHandler(this.wsDispatcher, this.channelService));
    }
}

