/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.Service.task;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.scheduler.ScheduleService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkSDKServerTask {
    private static final Logger log = LoggerFactory.getLogger(ParkSDKServerTask.class);
    @Autowired
    private ScheduleService scheduleService;
    private ScheduledFuture<?> scedulefuture;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;
    @Autowired
    private ParkCacheService parkCacheService;

    public void startTask() {
        if (this.scedulefuture != null) {
            this.scedulefuture.cancel(true);
        }
        this.scedulefuture = this.scheduleService.startScheduleTask(() -> this.websocketServiceMonitor(), "0/10 * *  * * ?");
    }

    private void websocketServiceMonitor() {
        if (this.parkParamsService.printParkLogger()) {
            if (this.parkWebsocketService.getSDKSession() == null) {
                log.info("PARK_SDK_Check == SDKSession = null");
            } else {
                log.info("PARK_SDK_Check == IsOpen = " + this.parkWebsocketService.getSDKSession().isOpen());
            }
        }
        if ("lprCamera".equals(this.parkParamsService.getRunMode()) && (this.parkWebsocketService.getSDKSession() == null || !this.parkWebsocketService.getSDKSession().isOpen())) {
            this.parkCacheService.dels("park:dev_handle_");
            this.parkCacheService.dels("park:view_defa_content_");
            this.updateDeviceStatus();
            this.parkWebsocketService.setSDKSession();
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_SDK == SDK Disconnected ...");
            }
            this.parkWebsocketService.createSDKService();
        }
    }

    private void updateDeviceStatus() {
        String devIpStr = this.parkCacheService.getStr("park:alldev_ip");
        if (ParkWebCommonUtil.isNotNull(devIpStr)) {
            String[] devIpAry;
            for (String devIp : devIpAry = devIpStr.split(",")) {
                if (!this.parkCacheService.exists("park:dev_info_" + devIp)) continue;
                JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
                this.parkCacheService.del("park:dev_handle_" + devObj.getString("handle"));
                devObj.put("serialHand", (Object)"0");
                devObj.put("handle", (Object)"0");
                devObj.put("state", (Object)"offLine");
                this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            }
        }
    }
}

