/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ChannelService {
    private static final Logger log = LoggerFactory.getLogger(ChannelService.class);
    private static Map<String, ChannelId> cacheTemplate = new HashMap<String, ChannelId>();
    private static Map<String, String> cacheTempBySn = new HashMap<String, String>();
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkParamsService parkParamsService;
    private static ChannelGroup group = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private static Map<String, Optional<ChannelGroup>> channelGroupMap = new HashMap<String, Optional<ChannelGroup>>();
    @Value(value="${netty.http.websocket.url:localhost}")
    private String webcocketUrl;
    @Value(value="${netty.http.websocket.port:7397}")
    private int port;

    private Optional<Channel> find(ChannelId channelId) {
        Channel channel = group.find(channelId);
        return Optional.ofNullable(channel);
    }

    private Optional<Channel> find(String sn) {
        return this.find(this.getChannelId(sn));
    }

    private ChannelId getChannelId(String sn) {
        return cacheTemplate.get("park:biosecurity_" + sn);
    }

    public String getSNByChannelId(String channelId) {
        return cacheTempBySn.get("park:channel_id_" + channelId);
    }

    public void add(Channel channel) {
        group.add((Object)channel);
    }

    public void groupPush(String message) {
        String funcId = JSON.parseObject((String)message).getString("funcId");
        if (!"parkingLot".equals(funcId) && this.parkParamsService.printParkLogger()) {
            log.info("PARK_CS == Send Message >>>>> " + funcId + " \uff1a " + message);
        }
        TextWebSocketFrame tws = new TextWebSocketFrame(message);
        group.writeAndFlush((Object)tws);
    }

    public void remove(Channel channel) {
        group.remove((Object)channel);
    }

    public void bindGroup(String sn, String zone) {
        Optional<DefaultChannelGroup> channelGroupOptional = channelGroupMap.getOrDefault(zone, Optional.of(new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE)));
        Optional<Channel> channelOptional = this.find(sn);
        if (channelOptional.isPresent()) {
            ChannelGroup channelGroup = (ChannelGroup)channelGroupOptional.get();
            channelGroup.add((Object)channelOptional.get());
            channelGroupMap.putIfAbsent(zone, Optional.of(channelGroup));
        }
    }

    public void bindChannel(String sn, Channel channel) {
        cacheTemplate.put("park:biosecurity_" + sn, channel.id());
    }

    public void bindSNByChannelId(String channelId, String sn) {
        cacheTempBySn.put("park:channel_id_" + channelId, sn);
    }

    public void broadcast(String zone, String message) {
        Optional optional = channelGroupMap.getOrDefault(zone, Optional.empty());
        if (optional.isPresent()) {
            ((ChannelGroup)optional.get()).writeAndFlush((Object)new TextWebSocketFrame(message));
        }
    }

    public void single(String sn, String message) {
        try {
            Optional<Channel> optional;
            String funcId = JSON.parseObject((String)message).getString("funcId");
            if (!"parkingLot".equals(funcId) && this.parkParamsService.printParkLogger()) {
                log.info("PARK_CS == Send Message >>>>> " + funcId + " \uff1a " + message);
            }
            if ((optional = this.find(sn)).isPresent()) {
                optional.get().writeAndFlush((Object)new TextWebSocketFrame(message));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close(String sn) {
        Optional<Channel> optional = this.find(sn);
        if (optional.isPresent()) {
            optional.get().close();
        }
    }

    public String getWebcocketUrl() {
        return this.webcocketUrl;
    }

    public int getPort() {
        return this.port;
    }

    public void modifyPavilioStatus(String pavilioIp) {
        ParkPavilioItem item = this.parkPavilioService.getPavilioByIpAddress(pavilioIp);
        if (ParkWebCommonUtil.isNotNull(item) && this.parkCacheService.exists("park:pavilio_status_" + item.getId())) {
            this.parkCacheService.set("park:pavilio_status_" + item.getId(), (Object)"offline", 0L);
        }
    }
}

