/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.LoggingSupport;

public class PlatformLogger {
    private static final int OFF = Integer.MAX_VALUE;
    private static final int SEVERE = 1000;
    private static final int WARNING = 900;
    private static final int INFO = 800;
    private static final int CONFIG = 700;
    private static final int FINE = 500;
    private static final int FINER = 400;
    private static final int FINEST = 300;
    private static final int ALL = Integer.MIN_VALUE;
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private static boolean loggingEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String cname = System.getProperty("java.util.logging.config.class");
            String fname = System.getProperty("java.util.logging.config.file");
            return cname != null || fname != null;
        }
    });
    private static Map<String, WeakReference<PlatformLogger>> loggers;
    private volatile LoggerProxy loggerProxy;
    private volatile JavaLoggerProxy javaLoggerProxy;

    public static synchronized PlatformLogger getLogger(String name) {
        PlatformLogger log = null;
        WeakReference<PlatformLogger> ref = loggers.get(name);
        if (ref != null) {
            log = (PlatformLogger)ref.get();
        }
        if (log == null) {
            log = new PlatformLogger(name);
            loggers.put(name, new WeakReference<PlatformLogger>(log));
        }
        return log;
    }

    public static synchronized void redirectPlatformLoggers() {
        if (loggingEnabled || !LoggingSupport.isAvailable()) {
            return;
        }
        loggingEnabled = true;
        for (Map.Entry<String, WeakReference<PlatformLogger>> entry : loggers.entrySet()) {
            WeakReference<PlatformLogger> ref = entry.getValue();
            PlatformLogger plog = (PlatformLogger)ref.get();
            if (plog == null) continue;
            plog.redirectToJavaLoggerProxy();
        }
    }

    private void redirectToJavaLoggerProxy() {
        JavaLoggerProxy jlp;
        DefaultLoggerProxy lp = (DefaultLoggerProxy)DefaultLoggerProxy.class.cast(this.loggerProxy);
        this.javaLoggerProxy = jlp = new JavaLoggerProxy(lp.name, lp.level);
        this.loggerProxy = jlp;
    }

    private PlatformLogger(String name) {
        if (loggingEnabled) {
            this.javaLoggerProxy = new JavaLoggerProxy(name);
            this.loggerProxy = this.javaLoggerProxy;
        } else {
            this.loggerProxy = new DefaultLoggerProxy(name);
        }
    }

    public boolean isEnabled() {
        return this.loggerProxy.isEnabled();
    }

    public String getName() {
        return this.loggerProxy.name;
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        JavaLoggerProxy jlp = this.javaLoggerProxy;
        return jlp != null ? jlp.isLoggable(level) : this.loggerProxy.isLoggable(level);
    }

    public Level level() {
        return this.loggerProxy.getLevel();
    }

    public void setLevel(Level newLevel) {
        this.loggerProxy.setLevel(newLevel);
    }

    public void severe(String msg) {
        this.loggerProxy.doLog(Level.SEVERE, msg);
    }

    public void severe(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.SEVERE, msg, t);
    }

    public void severe(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.SEVERE, msg, params);
    }

    public void warning(String msg) {
        this.loggerProxy.doLog(Level.WARNING, msg);
    }

    public void warning(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.WARNING, msg, t);
    }

    public void warning(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.WARNING, msg, params);
    }

    public void info(String msg) {
        this.loggerProxy.doLog(Level.INFO, msg);
    }

    public void info(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.INFO, msg, t);
    }

    public void info(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.INFO, msg, params);
    }

    public void config(String msg) {
        this.loggerProxy.doLog(Level.CONFIG, msg);
    }

    public void config(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.CONFIG, msg, t);
    }

    public void config(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.CONFIG, msg, params);
    }

    public void fine(String msg) {
        this.loggerProxy.doLog(Level.FINE, msg);
    }

    public void fine(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.FINE, msg, t);
    }

    public void fine(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.FINE, msg, params);
    }

    public void finer(String msg) {
        this.loggerProxy.doLog(Level.FINER, msg);
    }

    public void finer(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.FINER, msg, t);
    }

    public void finer(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.FINER, msg, params);
    }

    public void finest(String msg) {
        this.loggerProxy.doLog(Level.FINEST, msg);
    }

    public void finest(String msg, Throwable t) {
        this.loggerProxy.doLog(Level.FINEST, msg, t);
    }

    public void finest(String msg, Object ... params) {
        this.loggerProxy.doLog(Level.FINEST, msg, params);
    }

    static {
        try {
            Class.forName("sun.util.logging.PlatformLogger$DefaultLoggerProxy", false, PlatformLogger.class.getClassLoader());
            Class.forName("sun.util.logging.PlatformLogger$JavaLoggerProxy", false, PlatformLogger.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new InternalError(ex);
        }
        loggers = new HashMap<String, WeakReference<PlatformLogger>>();
    }

    private static final class JavaLoggerProxy
    extends LoggerProxy {
        private final Object javaLogger;

        JavaLoggerProxy(String name) {
            this(name, null);
        }

        JavaLoggerProxy(String name, Level level) {
            super(name);
            this.javaLogger = LoggingSupport.getLogger(name);
            if (level != null) {
                LoggingSupport.setLevel(this.javaLogger, level.javaLevel);
            }
        }

        @Override
        void doLog(Level level, String msg) {
            LoggingSupport.log(this.javaLogger, level.javaLevel, msg);
        }

        @Override
        void doLog(Level level, String msg, Throwable t) {
            LoggingSupport.log(this.javaLogger, level.javaLevel, msg, t);
        }

        @Override
        void doLog(Level level, String msg, Object ... params) {
            if (!this.isLoggable(level)) {
                return;
            }
            int len = params != null ? params.length : 0;
            Object[] sparams = new String[len];
            for (int i = 0; i < len; ++i) {
                sparams[i] = String.valueOf(params[i]);
            }
            LoggingSupport.log(this.javaLogger, level.javaLevel, msg, sparams);
        }

        @Override
        boolean isEnabled() {
            return LoggingSupport.isLoggable(this.javaLogger, Level.OFF.javaLevel);
        }

        @Override
        Level getLevel() {
            Object javaLevel = LoggingSupport.getLevel(this.javaLogger);
            if (javaLevel == null) {
                return null;
            }
            try {
                return Level.valueOf(LoggingSupport.getLevelName(javaLevel));
            }
            catch (IllegalArgumentException e) {
                return Level.valueOf(LoggingSupport.getLevelValue(javaLevel));
            }
        }

        @Override
        void setLevel(Level level) {
            LoggingSupport.setLevel(this.javaLogger, level == null ? null : level.javaLevel);
        }

        @Override
        boolean isLoggable(Level level) {
            return LoggingSupport.isLoggable(this.javaLogger, level.javaLevel);
        }

        static {
            for (Level level : Level.values()) {
                level.javaLevel = LoggingSupport.parseLevel(level.name());
            }
        }
    }

    private static final class DefaultLoggerProxy
    extends LoggerProxy {
        volatile Level effectiveLevel;
        volatile Level level = null;
        private static final String formatString = LoggingSupport.getSimpleFormat(false);
        private Date date = new Date();

        private static PrintStream outputStream() {
            return System.err;
        }

        DefaultLoggerProxy(String name) {
            super(name);
            this.effectiveLevel = this.deriveEffectiveLevel(null);
        }

        @Override
        boolean isEnabled() {
            return this.effectiveLevel != Level.OFF;
        }

        @Override
        Level getLevel() {
            return this.level;
        }

        @Override
        void setLevel(Level newLevel) {
            Level oldLevel = this.level;
            if (oldLevel != newLevel) {
                this.level = newLevel;
                this.effectiveLevel = this.deriveEffectiveLevel(newLevel);
            }
        }

        @Override
        void doLog(Level level, String msg) {
            if (this.isLoggable(level)) {
                DefaultLoggerProxy.outputStream().print(this.format(level, msg, null));
            }
        }

        @Override
        void doLog(Level level, String msg, Throwable thrown) {
            if (this.isLoggable(level)) {
                DefaultLoggerProxy.outputStream().print(this.format(level, msg, thrown));
            }
        }

        @Override
        void doLog(Level level, String msg, Object ... params) {
            if (this.isLoggable(level)) {
                String newMsg = this.formatMessage(msg, params);
                DefaultLoggerProxy.outputStream().print(this.format(level, newMsg, null));
            }
        }

        @Override
        boolean isLoggable(Level level) {
            Level effectiveLevel = this.effectiveLevel;
            return level.intValue() >= effectiveLevel.intValue() && effectiveLevel != Level.OFF;
        }

        private Level deriveEffectiveLevel(Level level) {
            return level == null ? DEFAULT_LEVEL : level;
        }

        private String formatMessage(String format, Object ... parameters) {
            try {
                if (parameters == null || parameters.length == 0) {
                    return format;
                }
                if (format.indexOf("{0") >= 0 || format.indexOf("{1") >= 0 || format.indexOf("{2") >= 0 || format.indexOf("{3") >= 0) {
                    return MessageFormat.format(format, parameters);
                }
                return format;
            }
            catch (Exception ex) {
                return format;
            }
        }

        private synchronized String format(Level level, String msg, Throwable thrown) {
            this.date.setTime(System.currentTimeMillis());
            String throwable = "";
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                thrown.printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(formatString, this.date, this.getCallerInfo(), this.name, level.name(), msg, throwable);
        }

        private String getCallerInfo() {
            String sourceClassName = null;
            String sourceMethodName = null;
            JavaLangAccess access = SharedSecrets.getJavaLangAccess();
            Throwable throwable = new Throwable();
            int depth = access.getStackTraceDepth(throwable);
            String logClassName = "sun.util.logging.PlatformLogger";
            boolean lookingForLogger = true;
            for (int ix = 0; ix < depth; ++ix) {
                StackTraceElement frame = access.getStackTraceElement(throwable, ix);
                String cname = frame.getClassName();
                if (lookingForLogger) {
                    if (!cname.equals(logClassName)) continue;
                    lookingForLogger = false;
                    continue;
                }
                if (cname.equals(logClassName)) continue;
                sourceClassName = cname;
                sourceMethodName = frame.getMethodName();
                break;
            }
            if (sourceClassName != null) {
                return sourceClassName + " " + sourceMethodName;
            }
            return this.name;
        }
    }

    private static abstract class LoggerProxy {
        final String name;

        protected LoggerProxy(String name) {
            this.name = name;
        }

        abstract boolean isEnabled();

        abstract Level getLevel();

        abstract void setLevel(Level var1);

        abstract void doLog(Level var1, String var2);

        abstract void doLog(Level var1, String var2, Throwable var3);

        abstract void doLog(Level var1, String var2, Object ... var3);

        abstract boolean isLoggable(Level var1);
    }

    public static enum Level {
        ALL,
        FINEST,
        FINER,
        FINE,
        CONFIG,
        INFO,
        WARNING,
        SEVERE,
        OFF;

        Object javaLevel;
        private static final int[] LEVEL_VALUES;

        public int intValue() {
            return LEVEL_VALUES[this.ordinal()];
        }

        static Level valueOf(int level) {
            switch (level) {
                case 300: {
                    return FINEST;
                }
                case 500: {
                    return FINE;
                }
                case 400: {
                    return FINER;
                }
                case 800: {
                    return INFO;
                }
                case 900: {
                    return WARNING;
                }
                case 700: {
                    return CONFIG;
                }
                case 1000: {
                    return SEVERE;
                }
                case 0x7FFFFFFF: {
                    return OFF;
                }
                case -2147483648: {
                    return ALL;
                }
            }
            int i = Arrays.binarySearch(LEVEL_VALUES, 0, LEVEL_VALUES.length - 2, level);
            return Level.values()[i >= 0 ? i : -i - 1];
        }

        static {
            LEVEL_VALUES = new int[]{Integer.MIN_VALUE, 300, 400, 500, 700, 800, 900, 1000, Integer.MAX_VALUE};
        }
    }
}

