/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;
import sun.security.krb5.internal.ktab.KeyTabEntry;

public class Ktab {
    KeyTab table;
    char action;
    String name;
    String principal;
    boolean showEType;
    boolean showTime;
    int etype = -1;
    char[] password = null;
    boolean forced = false;
    boolean append = false;
    int vDel = -1;
    int vAdd = -1;

    public static void main(String[] args) {
        Ktab ktab = new Ktab();
        if (args.length == 1 && args[0].equalsIgnoreCase("-help")) {
            ktab.printHelp();
            return;
        }
        if (args == null || args.length == 0) {
            ktab.action = (char)108;
        } else {
            ktab.processArgs(args);
        }
        ktab.table = KeyTab.getInstance(ktab.name);
        if (ktab.table.isMissing() && ktab.action != 'a') {
            if (ktab.name == null) {
                System.out.println("No default key table exists.");
            } else {
                System.out.println("Key table " + ktab.name + " does not exist.");
            }
            System.exit(-1);
        }
        if (!ktab.table.isValid()) {
            if (ktab.name == null) {
                System.out.println("The format of the default key table  is incorrect.");
            } else {
                System.out.println("The format of key table " + ktab.name + " is incorrect.");
            }
            System.exit(-1);
        }
        switch (ktab.action) {
            case 'l': {
                ktab.listKt();
                break;
            }
            case 'a': {
                ktab.addEntry();
                break;
            }
            case 'd': {
                ktab.deleteEntry();
                break;
            }
            default: {
                ktab.error("A command must be provided");
            }
        }
    }

    void processArgs(String[] args) {
        boolean argAlreadyAppeared = false;
        block36: for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                switch (args[i].toLowerCase(Locale.US)) {
                    case "-l": {
                        this.action = (char)108;
                        break;
                    }
                    case "-a": {
                        this.action = (char)97;
                        if (++i >= args.length || args[i].startsWith("-")) {
                            this.error("A principal name must be specified after -a");
                        }
                        this.principal = args[i];
                        break;
                    }
                    case "-d": {
                        this.action = (char)100;
                        if (++i >= args.length || args[i].startsWith("-")) {
                            this.error("A principal name must be specified after -d");
                        }
                        this.principal = args[i];
                        break;
                    }
                    case "-e": {
                        if (this.action == 'l') {
                            this.showEType = true;
                            break;
                        }
                        if (this.action == 'd') {
                            if (++i >= args.length || args[i].startsWith("-")) {
                                this.error("An etype must be specified after -e");
                            }
                            try {
                                this.etype = Integer.parseInt(args[i]);
                                if (this.etype > 0) continue block36;
                                throw new NumberFormatException();
                            }
                            catch (NumberFormatException nfe) {
                                this.error(args[i] + " is not a valid etype");
                                break;
                            }
                        }
                        this.error(args[i] + " is not valid after -" + this.action);
                        break;
                    }
                    case "-n": {
                        if (++i >= args.length || args[i].startsWith("-")) {
                            this.error("A KVNO must be specified after -n");
                        }
                        try {
                            this.vAdd = Integer.parseInt(args[i]);
                            if (this.vAdd >= 0) continue block36;
                            throw new NumberFormatException();
                        }
                        catch (NumberFormatException nfe) {
                            this.error(args[i] + " is not a valid KVNO");
                            break;
                        }
                    }
                    case "-k": {
                        if (++i >= args.length || args[i].startsWith("-")) {
                            this.error("A keytab name must be specified after -k");
                        }
                        if (args[i].length() >= 5 && args[i].substring(0, 5).equalsIgnoreCase("FILE:")) {
                            this.name = args[i].substring(5);
                            break;
                        }
                        this.name = args[i];
                        break;
                    }
                    case "-t": {
                        this.showTime = true;
                        break;
                    }
                    case "-f": {
                        this.forced = true;
                        break;
                    }
                    case "-append": {
                        this.append = true;
                        break;
                    }
                    default: {
                        this.error("Unknown command: " + args[i]);
                    }
                }
                continue;
            }
            if (argAlreadyAppeared) {
                this.error("Useless extra argument " + args[i]);
            }
            if (this.action == 'a') {
                this.password = args[i].toCharArray();
            } else if (this.action == 'd') {
                switch (args[i]) {
                    case "all": {
                        this.vDel = -1;
                        break;
                    }
                    case "old": {
                        this.vDel = -2;
                        break;
                    }
                    default: {
                        try {
                            this.vDel = Integer.parseInt(args[i]);
                            if (this.vDel < 0) {
                                throw new NumberFormatException();
                            }
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            this.error(args[i] + " is not a valid KVNO");
                            break;
                        }
                    }
                }
            } else {
                this.error("Useless extra argument " + args[i]);
            }
            argAlreadyAppeared = true;
        }
    }

    void addEntry() {
        PrincipalName pname = null;
        try {
            pname = new PrincipalName(this.principal);
        }
        catch (KrbException e) {
            System.err.println("Failed to add " + this.principal + " to keytab.");
            e.printStackTrace();
            System.exit(-1);
        }
        if (this.password == null) {
            try {
                BufferedReader cis = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Password for " + pname.toString() + ":");
                System.out.flush();
                this.password = cis.readLine().toCharArray();
            }
            catch (IOException e) {
                System.err.println("Failed to read the password.");
                e.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            this.table.addEntry(pname, this.password, this.vAdd, this.append);
            Arrays.fill(this.password, '0');
            this.table.save();
            System.out.println("Done!");
            System.out.println("Service key for " + this.principal + " is saved in " + this.table.tabName());
        }
        catch (KrbException e) {
            System.err.println("Failed to add " + this.principal + " to keytab.");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("Failed to save new entry.");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    void listKt() {
        System.out.println("Keytab name: " + this.table.tabName());
        KeyTabEntry[] entries = this.table.getEntries();
        if (entries != null && entries.length > 0) {
            int j;
            String[][] output = new String[entries.length + 1][this.showTime ? 3 : 2];
            int column = 0;
            output[0][column++] = "KVNO";
            if (this.showTime) {
                output[0][column++] = "Timestamp";
            }
            output[0][column++] = "Principal";
            for (int i = 0; i < entries.length; ++i) {
                column = 0;
                output[i + 1][column++] = entries[i].getKey().getKeyVersionNumber().toString();
                if (this.showTime) {
                    output[i + 1][column++] = DateFormat.getDateTimeInstance(3, 3).format(new Date(entries[i].getTimeStamp().getTime()));
                }
                String princ = entries[i].getService().toString();
                if (this.showEType) {
                    int e = entries[i].getKey().getEType();
                    output[i + 1][column++] = princ + " (" + e + ":" + EType.toString(e) + ")";
                    continue;
                }
                output[i + 1][column++] = princ;
            }
            int[] width = new int[column];
            for (j = 0; j < column; ++j) {
                for (int i = 0; i <= entries.length; ++i) {
                    if (output[i][j].length() <= width[j]) continue;
                    width[j] = output[i][j].length();
                }
                if (j == 0) continue;
                width[j] = -width[j];
            }
            for (j = 0; j < column; ++j) {
                System.out.printf("%" + width[j] + "s ", output[0][j]);
            }
            System.out.println();
            for (j = 0; j < column; ++j) {
                for (int k = 0; k < Math.abs(width[j]); ++k) {
                    System.out.print("-");
                }
                System.out.print(" ");
            }
            System.out.println();
            for (int i = 0; i < entries.length; ++i) {
                for (int j2 = 0; j2 < column; ++j2) {
                    System.out.printf("%" + width[j2] + "s ", output[i + 1][j2]);
                }
                System.out.println();
            }
        } else {
            System.out.println("0 entry.");
        }
    }

    void deleteEntry() {
        PrincipalName pname = null;
        try {
            pname = new PrincipalName(this.principal);
            if (!this.forced) {
                BufferedReader cis = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Are you sure you want to delete service key(s) for " + pname.toString() + " (" + (this.etype == -1 ? "all etypes" : "etype=" + this.etype) + ", " + (this.vDel == -1 ? "all kvno" : (this.vDel == -2 ? "old kvno" : "kvno=" + this.vDel)) + ") in " + this.table.tabName() + "? (Y/[N]): ");
                System.out.flush();
                String answer = cis.readLine();
                if (!answer.equalsIgnoreCase("Y") && !answer.equalsIgnoreCase("Yes")) {
                    System.exit(0);
                }
            }
        }
        catch (KrbException e) {
            System.err.println("Error occurred while deleting the entry. Deletion failed.");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("Error occurred while deleting the entry.  Deletion failed.");
            e.printStackTrace();
            System.exit(-1);
        }
        int count = this.table.deleteEntries(pname, this.etype, this.vDel);
        if (count == 0) {
            System.err.println("No matched entry in the keytab. Deletion fails.");
            System.exit(-1);
        } else {
            try {
                this.table.save();
            }
            catch (IOException e) {
                System.err.println("Error occurs while saving the keytab. Deletion fails.");
                e.printStackTrace();
                System.exit(-1);
            }
            System.out.println("Done! " + count + " entries removed.");
        }
    }

    void error(String ... errors) {
        for (String error : errors) {
            System.out.println("Error: " + error + ".");
        }
        this.printHelp();
        System.exit(-1);
    }

    void printHelp() {
        System.out.println("\nUsage: ktab <commands> <options>");
        System.out.println();
        System.out.println("Available commands:");
        System.out.println();
        System.out.println("-l [-e] [-t]\n    list the keytab name and entries. -e with etype, -t with timestamp.");
        System.out.println("-a <principal name> [<password>] [-n <kvno>] [-append]\n    add new key entries to the keytab for the given principal name with\n    optional <password>. If a <kvno> is specified, new keys' Key Version\n    Numbers equal to the value, otherwise, automatically incrementing\n    the Key Version Numbers. If -append is specified, new keys are\n    appended to the keytab, otherwise, old keys for the\n    same principal are removed.");
        System.out.println("-d <principal name> [-f] [-e <etype>] [<kvno> | all | old]\n    delete key entries from the keytab for the specified principal. If\n    <kvno> is specified, delete keys whose Key Version Numbers match\n    kvno. If \"all\" is specified, delete all keys. If \"old\" is specified,\n    delete all keys except those with the highest kvno. Default action\n    is \"all\". If <etype> is specified, only keys of this encryption type\n    are deleted. <etype> should be specified as the numberic value etype\n    defined in RFC 3961, section 8. A prompt to confirm the deletion is\n    displayed unless -f is specified.");
        System.out.println();
        System.out.println("Common option(s):");
        System.out.println();
        System.out.println("-k <keytab name>\n    specify keytab name and path with prefix FILE:");
    }
}

