/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.security.Provider;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Ticket;

public class Krb5ProxyCredential
implements Krb5CredElement {
    public final Krb5InitCredential self;
    private final Krb5NameElement client;
    public final Ticket tkt;

    Krb5ProxyCredential(Krb5InitCredential self, Krb5NameElement client, Ticket tkt) {
        this.self = self;
        this.tkt = tkt;
        this.client = client;
    }

    @Override
    public final Krb5NameElement getName() throws GSSException {
        return this.client;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        return this.self.getInitLifetime();
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return 0;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return true;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return false;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.self.destroy();
        }
        catch (DestroyFailedException e) {
            GSSException gssException = new GSSException(11, -1, "Could not destroy credentials - " + e.getMessage());
            gssException.initCause(e);
        }
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi name) throws GSSException {
        throw new GSSException(11, -1, "Only an initiate credentials can impersonate");
    }

    static Krb5CredElement tryImpersonation(GSSCaller caller, Krb5InitCredential initiator) throws GSSException {
        try {
            KerberosTicket proxy = initiator.proxyTicket;
            if (proxy != null) {
                Credentials proxyCreds = Krb5Util.ticketToCreds(proxy);
                return new Krb5ProxyCredential(initiator, Krb5NameElement.getInstance(proxyCreds.getClient()), proxyCreds.getTicket());
            }
            return initiator;
        }
        catch (IOException | KrbException e) {
            throw new GSSException(9, -1, "Cannot create proxy credential");
        }
    }
}

