/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsChannelFactory;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final WindowsPath file;
    private final boolean followLinks;

    private String join(String file, String name) {
        if (name == null) {
            throw new NullPointerException("'name' is null");
        }
        return file + ":" + name;
    }

    private String join(WindowsPath file, String name) throws WindowsException {
        return this.join(file.getPathForWin32Calls(), name);
    }

    WindowsUserDefinedFileAttributeView(WindowsPath file, boolean followLinks) {
        this.file = file;
        this.followLinks = followLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listUsingStreamEnumeration() throws IOException {
        ArrayList<String> list;
        block7: {
            list = new ArrayList<String>();
            try {
                WindowsNativeDispatcher.FirstStream first = WindowsNativeDispatcher.FindFirstStream(this.file.getPathForWin32Calls());
                if (first == null) break block7;
                long handle = first.handle();
                try {
                    String[] segs;
                    String name = first.name();
                    if (!name.equals("::$DATA")) {
                        segs = name.split(":");
                        list.add(segs[1]);
                    }
                    while ((name = WindowsNativeDispatcher.FindNextStream(handle)) != null) {
                        segs = name.split(":");
                        list.add(segs[1]);
                    }
                }
                finally {
                    WindowsNativeDispatcher.FindClose(handle);
                }
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.file);
            }
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listUsingBackupRead() throws IOException {
        long handle = -1L;
        try {
            int flags = 0x2000000;
            if (!this.followLinks && this.file.getFileSystem().supportsLinks()) {
                flags |= 0x200000;
            }
            handle = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), Integer.MIN_VALUE, 1, 3, flags);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.file);
        }
        int BUFFER_SIZE = 4096;
        NativeBuffer buffer = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            buffer = NativeBuffers.getNativeBuffer(4096);
            long address = buffer.address();
            int SIZEOF_STREAM_HEADER = 20;
            boolean OFFSETOF_STREAM_ID = false;
            int OFFSETOF_STREAM_SIZE = 8;
            int OFFSETOF_STREAM_NAME_SIZE = 16;
            long context = 0L;
            try {
                while (true) {
                    WindowsNativeDispatcher.BackupResult result = WindowsNativeDispatcher.BackupRead(handle, address, 20, false, context);
                    context = result.context();
                    if (result.bytesTransferred() == 0) {
                        break;
                    }
                    int streamId = unsafe.getInt(address + 0L);
                    long streamSize = unsafe.getLong(address + 8L);
                    int nameSize = unsafe.getInt(address + 16L);
                    if (nameSize > 0 && (result = WindowsNativeDispatcher.BackupRead(handle, address, nameSize, false, context)).bytesTransferred() != nameSize) {
                        break;
                    }
                    if (streamId == 4) {
                        char[] nameAsArray = new char[nameSize / 2];
                        unsafe.copyMemory(null, address, nameAsArray, Unsafe.ARRAY_CHAR_BASE_OFFSET, nameSize);
                        String[] segs = new String(nameAsArray).split(":");
                        if (segs.length == 3) {
                            list.add(segs[1]);
                        }
                    }
                    if (streamId == 9) {
                        throw new IOException("Spare blocks not handled");
                    }
                    if (streamSize <= 0L) continue;
                    WindowsNativeDispatcher.BackupSeek(handle, streamSize, context);
                }
            }
            catch (WindowsException x) {
                throw new IOException(x.errorString());
            }
            finally {
                if (context != 0L) {
                    try {
                        WindowsNativeDispatcher.BackupRead(handle, 0L, 0, true, context);
                    }
                    catch (WindowsException windowsException) {}
                }
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
            WindowsNativeDispatcher.CloseHandle(handle);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        if (this.file.getFileSystem().supportsStreamEnumeration()) {
            return this.listUsingStreamEnumeration();
        }
        return this.listUsingBackupRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        FileChannel fc = null;
        try {
            HashSet<OpenOption> opts = new HashSet<OpenOption>();
            opts.add(StandardOpenOption.READ);
            if (!this.followLinks) {
                opts.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            fc = WindowsChannelFactory.newFileChannel(this.join(this.file, name), null, opts, 0L);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), name));
        }
        try {
            long size = fc.size();
            if (size > Integer.MAX_VALUE) {
                throw new ArithmeticException("Stream too large");
            }
            int n = (int)size;
            return n;
        }
        finally {
            fc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String name, ByteBuffer dst) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        FileChannel fc = null;
        try {
            HashSet<OpenOption> opts = new HashSet<OpenOption>();
            opts.add(StandardOpenOption.READ);
            if (!this.followLinks) {
                opts.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            fc = WindowsChannelFactory.newFileChannel(this.join(this.file, name), null, opts, 0L);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), name));
        }
        try {
            int n;
            if (fc.size() > (long)dst.remaining()) {
                throw new IOException("Stream too large");
            }
            int total = 0;
            while (dst.hasRemaining() && (n = fc.read(dst)) >= 0) {
                total += n;
            }
            int n2 = total;
            return n2;
        }
        finally {
            fc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String name, ByteBuffer src) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        long handle = -1L;
        try {
            int flags = 0x2000000;
            if (!this.followLinks) {
                flags |= 0x200000;
            }
            handle = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), Integer.MIN_VALUE, 7, 3, flags);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            int n;
            HashSet<OpenOption> opts = new HashSet<OpenOption>();
            if (!this.followLinks) {
                opts.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            opts.add(StandardOpenOption.CREATE);
            opts.add(StandardOpenOption.WRITE);
            opts.add(StandardOpenOption.TRUNCATE_EXISTING);
            FileChannel named = null;
            try {
                named = WindowsChannelFactory.newFileChannel(this.join(this.file, name), null, opts, 0L);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), name));
            }
            try {
                int rem = src.remaining();
                while (src.hasRemaining()) {
                    named.write(src);
                }
                n = rem;
            }
            catch (Throwable throwable) {
                named.close();
                throw throwable;
            }
            named.close();
            return n;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(handle);
        }
    }

    @Override
    public void delete(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        String path = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        String toDelete = this.join(path, name);
        try {
            WindowsNativeDispatcher.DeleteFile(toDelete);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(toDelete);
        }
    }
}

