/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.security.action.GetPropertyAction;

class WindowsFileAttributes
implements DosFileAttributes {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final short SIZEOF_FILE_INFORMATION = 52;
    private static final short OFFSETOF_FILE_INFORMATION_ATTRIBUTES = 0;
    private static final short OFFSETOF_FILE_INFORMATION_CREATETIME = 4;
    private static final short OFFSETOF_FILE_INFORMATION_LASTACCESSTIME = 12;
    private static final short OFFSETOF_FILE_INFORMATION_LASTWRITETIME = 20;
    private static final short OFFSETOF_FILE_INFORMATION_VOLSERIALNUM = 28;
    private static final short OFFSETOF_FILE_INFORMATION_SIZEHIGH = 32;
    private static final short OFFSETOF_FILE_INFORMATION_SIZELOW = 36;
    private static final short OFFSETOF_FILE_INFORMATION_INDEXHIGH = 44;
    private static final short OFFSETOF_FILE_INFORMATION_INDEXLOW = 48;
    private static final short SIZEOF_FILE_ATTRIBUTE_DATA = 36;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_ATTRIBUTES = 0;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_CREATETIME = 4;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_LASTACCESSTIME = 12;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_LASTWRITETIME = 20;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_SIZEHIGH = 28;
    private static final short OFFSETOF_FILE_ATTRIBUTE_DATA_SIZELOW = 32;
    private static final short SIZEOF_FIND_DATA = 592;
    private static final short OFFSETOF_FIND_DATA_ATTRIBUTES = 0;
    private static final short OFFSETOF_FIND_DATA_CREATETIME = 4;
    private static final short OFFSETOF_FIND_DATA_LASTACCESSTIME = 12;
    private static final short OFFSETOF_FIND_DATA_LASTWRITETIME = 20;
    private static final short OFFSETOF_FIND_DATA_SIZEHIGH = 28;
    private static final short OFFSETOF_FIND_DATA_SIZELOW = 32;
    private static final short OFFSETOF_FIND_DATA_RESERVED0 = 36;
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;
    private static final boolean ensureAccurateMetadata;
    private final int fileAttrs;
    private final long creationTime;
    private final long lastAccessTime;
    private final long lastWriteTime;
    private final long size;
    private final int reparseTag;
    private final int volSerialNumber;
    private final int fileIndexHigh;
    private final int fileIndexLow;

    static FileTime toFileTime(long time) {
        time /= 10L;
        return FileTime.from(time += -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    static long toWindowsTime(FileTime time) {
        long value = time.to(TimeUnit.MICROSECONDS);
        value -= -11644473600000000L;
        return value *= 10L;
    }

    private WindowsFileAttributes(int fileAttrs, long creationTime, long lastAccessTime, long lastWriteTime, long size, int reparseTag, int volSerialNumber, int fileIndexHigh, int fileIndexLow) {
        this.fileAttrs = fileAttrs;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.lastWriteTime = lastWriteTime;
        this.size = size;
        this.reparseTag = reparseTag;
        this.volSerialNumber = volSerialNumber;
        this.fileIndexHigh = fileIndexHigh;
        this.fileIndexLow = fileIndexLow;
    }

    private static WindowsFileAttributes fromFileInformation(long address, int reparseTag) {
        int fileAttrs = unsafe.getInt(address + 0L);
        long creationTime = unsafe.getLong(address + 4L);
        long lastAccessTime = unsafe.getLong(address + 12L);
        long lastWriteTime = unsafe.getLong(address + 20L);
        long size = ((long)unsafe.getInt(address + 32L) << 32) + ((long)unsafe.getInt(address + 36L) & 0xFFFFFFFFL);
        int volSerialNumber = unsafe.getInt(address + 28L);
        int fileIndexHigh = unsafe.getInt(address + 44L);
        int fileIndexLow = unsafe.getInt(address + 48L);
        return new WindowsFileAttributes(fileAttrs, creationTime, lastAccessTime, lastWriteTime, size, reparseTag, volSerialNumber, fileIndexHigh, fileIndexLow);
    }

    private static WindowsFileAttributes fromFileAttributeData(long address, int reparseTag) {
        int fileAttrs = unsafe.getInt(address + 0L);
        long creationTime = unsafe.getLong(address + 4L);
        long lastAccessTime = unsafe.getLong(address + 12L);
        long lastWriteTime = unsafe.getLong(address + 20L);
        long size = ((long)unsafe.getInt(address + 28L) << 32) + ((long)unsafe.getInt(address + 32L) & 0xFFFFFFFFL);
        return new WindowsFileAttributes(fileAttrs, creationTime, lastAccessTime, lastWriteTime, size, reparseTag, 0, 0, 0);
    }

    static NativeBuffer getBufferForFindData() {
        return NativeBuffers.getNativeBuffer(592);
    }

    static WindowsFileAttributes fromFindData(long address) {
        int fileAttrs = unsafe.getInt(address + 0L);
        long creationTime = unsafe.getLong(address + 4L);
        long lastAccessTime = unsafe.getLong(address + 12L);
        long lastWriteTime = unsafe.getLong(address + 20L);
        long size = ((long)unsafe.getInt(address + 28L) << 32) + ((long)unsafe.getInt(address + 32L) & 0xFFFFFFFFL);
        int reparseTag = WindowsFileAttributes.isReparsePoint(fileAttrs) ? unsafe.getInt(address + 36L) : 0;
        return new WindowsFileAttributes(fileAttrs, creationTime, lastAccessTime, lastWriteTime, size, reparseTag, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WindowsFileAttributes readAttributes(long handle) throws WindowsException {
        NativeBuffer buffer = NativeBuffers.getNativeBuffer(52);
        try {
            long address = buffer.address();
            WindowsNativeDispatcher.GetFileInformationByHandle(handle, address);
            int reparseTag = 0;
            int fileAttrs = unsafe.getInt(address + 0L);
            if (WindowsFileAttributes.isReparsePoint(fileAttrs)) {
                int size = 16384;
                NativeBuffer reparseBuffer = NativeBuffers.getNativeBuffer(size);
                try {
                    WindowsNativeDispatcher.DeviceIoControlGetReparsePoint(handle, reparseBuffer.address(), size);
                    reparseTag = (int)unsafe.getLong(reparseBuffer.address());
                }
                finally {
                    reparseBuffer.release();
                }
            }
            WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.fromFileInformation(address, reparseTag);
            return windowsFileAttributes;
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WindowsFileAttributes get(WindowsPath path, boolean followLinks) throws WindowsException {
        if (!ensureAccurateMetadata) {
            WindowsException firstException = null;
            NativeBuffer buffer = NativeBuffers.getNativeBuffer(36);
            try {
                long address = buffer.address();
                WindowsNativeDispatcher.GetFileAttributesEx(path.getPathForWin32Calls(), address);
                int fileAttrs = unsafe.getInt(address + 0L);
                if (!WindowsFileAttributes.isReparsePoint(fileAttrs)) {
                    WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.fromFileAttributeData(address, 0);
                    return windowsFileAttributes;
                }
            }
            catch (WindowsException x) {
                if (x.lastError() != 32) {
                    throw x;
                }
                firstException = x;
            }
            finally {
                buffer.release();
            }
            if (firstException != null) {
                String search = path.getPathForWin32Calls();
                char last = search.charAt(search.length() - 1);
                if (last == ':' || last == '\\') {
                    throw firstException;
                }
                buffer = WindowsFileAttributes.getBufferForFindData();
                try {
                    long handle = WindowsNativeDispatcher.FindFirstFile(search, buffer.address());
                    WindowsNativeDispatcher.FindClose(handle);
                    WindowsFileAttributes attrs = WindowsFileAttributes.fromFindData(buffer.address());
                    if (attrs.isReparsePoint()) {
                        throw firstException;
                    }
                    WindowsFileAttributes windowsFileAttributes = attrs;
                    return windowsFileAttributes;
                }
                catch (WindowsException ignore) {
                    throw firstException;
                }
                finally {
                    buffer.release();
                }
            }
        }
        long handle = path.openForReadAttributeAccess(followLinks);
        try {
            WindowsFileAttributes windowsFileAttributes = WindowsFileAttributes.readAttributes(handle);
            return windowsFileAttributes;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(handle);
        }
    }

    static boolean isSameFile(WindowsFileAttributes attrs1, WindowsFileAttributes attrs2) {
        return attrs1.volSerialNumber == attrs2.volSerialNumber && attrs1.fileIndexHigh == attrs2.fileIndexHigh && attrs1.fileIndexLow == attrs2.fileIndexLow;
    }

    static boolean isReparsePoint(int attributes) {
        return (attributes & 0x400) != 0;
    }

    int attributes() {
        return this.fileAttrs;
    }

    int volSerialNumber() {
        return this.volSerialNumber;
    }

    int fileIndexHigh() {
        return this.fileIndexHigh;
    }

    int fileIndexLow() {
        return this.fileIndexLow;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public FileTime lastModifiedTime() {
        return WindowsFileAttributes.toFileTime(this.lastWriteTime);
    }

    @Override
    public FileTime lastAccessTime() {
        return WindowsFileAttributes.toFileTime(this.lastAccessTime);
    }

    @Override
    public FileTime creationTime() {
        return WindowsFileAttributes.toFileTime(this.creationTime);
    }

    @Override
    public Object fileKey() {
        return null;
    }

    boolean isReparsePoint() {
        return WindowsFileAttributes.isReparsePoint(this.fileAttrs);
    }

    boolean isDirectoryLink() {
        return this.isSymbolicLink() && (this.fileAttrs & 0x10) != 0;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.reparseTag == -1610612724;
    }

    @Override
    public boolean isDirectory() {
        if (this.isSymbolicLink()) {
            return false;
        }
        return (this.fileAttrs & 0x10) != 0;
    }

    @Override
    public boolean isOther() {
        if (this.isSymbolicLink()) {
            return false;
        }
        return (this.fileAttrs & 0x440) != 0;
    }

    @Override
    public boolean isRegularFile() {
        return !this.isSymbolicLink() && !this.isDirectory() && !this.isOther();
    }

    @Override
    public boolean isReadOnly() {
        return (this.fileAttrs & 1) != 0;
    }

    @Override
    public boolean isHidden() {
        return (this.fileAttrs & 2) != 0;
    }

    @Override
    public boolean isArchive() {
        return (this.fileAttrs & 0x20) != 0;
    }

    @Override
    public boolean isSystem() {
        return (this.fileAttrs & 4) != 0;
    }

    static {
        String propValue = AccessController.doPrivileged(new GetPropertyAction("sun.nio.fs.ensureAccurateMetadata", "false"));
        ensureAccurateMetadata = propValue.length() == 0 ? true : Boolean.valueOf(propValue);
    }
}

