/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.ntlm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.NetProperties;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.ntlm.NTLMAuthSequence;
import sun.net.www.protocol.http.ntlm.NTLMAuthenticationCallback;
import sun.security.action.GetPropertyAction;

public class NTLMAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private static final NTLMAuthenticationCallback NTLMAuthCallback = NTLMAuthenticationCallback.getNTLMAuthenticationCallback();
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", "domain"));
    private static final boolean ntlmCache;
    private static final TransparentAuth authMode;
    String username;
    String ntdomain;
    String password;
    private static final boolean isTrustedSiteAvailable;

    private void init0() {
        this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String localhost;
                try {
                    localhost = InetAddress.getLocalHost().getHostName().toUpperCase();
                }
                catch (UnknownHostException e) {
                    localhost = "localhost";
                }
                return localhost;
            }
        });
        int x = this.hostname.indexOf(46);
        if (x != -1) {
            this.hostname = this.hostname.substring(0, x);
        }
    }

    public NTLMAuthentication(boolean isProxy, URL url, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', AuthScheme.NTLM, url, "");
        this.init(pw);
    }

    private void init(PasswordAuthentication pw) {
        this.pw = pw;
        if (pw != null) {
            String s = pw.getUserName();
            int i = s.indexOf(92);
            if (i == -1) {
                this.username = s;
                this.ntdomain = defaultDomain;
            } else {
                this.ntdomain = s.substring(0, i).toUpperCase();
                this.username = s.substring(i + 1);
            }
            this.password = new String(pw.getPassword());
        } else {
            this.username = null;
            this.ntdomain = null;
            this.password = null;
        }
        this.init0();
    }

    public NTLMAuthentication(boolean isProxy, String host, int port, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', AuthScheme.NTLM, host, port, "");
        this.init(pw);
    }

    @Override
    protected boolean useAuthCache() {
        return ntlmCache && super.useAuthCache();
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static boolean supportsTransparentAuth() {
        return true;
    }

    public static boolean isTrustedSite(URL url) {
        if (NTLMAuthCallback != null) {
            return NTLMAuthCallback.isTrustedSite(url);
        }
        switch (authMode) {
            case TRUSTED_HOSTS: {
                return NTLMAuthentication.isTrustedSite(url.toString());
            }
            case ALL_HOSTS: {
                return true;
            }
        }
        return false;
    }

    private static native boolean isTrustedSiteAvailable();

    private static boolean isTrustedSite(String url) {
        if (isTrustedSiteAvailable) {
            return NTLMAuthentication.isTrustedSite0(url);
        }
        return false;
    }

    private static native boolean isTrustedSite0(String var0);

    @Override
    public String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String header) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        try {
            NTLMAuthSequence seq = (NTLMAuthSequence)conn.authObj();
            if (seq == null) {
                seq = new NTLMAuthSequence(this.username, this.password, this.ntdomain);
                conn.authObj(seq);
            }
            String response = "NTLM " + seq.getAuthHeader(raw.length() > 6 ? raw.substring(5) : null);
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            if (seq.isComplete()) {
                conn.authObj(null);
            }
            return true;
        }
        catch (IOException e) {
            conn.authObj(null);
            return false;
        }
    }

    static {
        String ntlmCacheProp = AccessController.doPrivileged(new GetPropertyAction("jdk.ntlm.cache", "true"));
        ntlmCache = Boolean.parseBoolean(ntlmCacheProp);
        String modeProp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return NetProperties.get("jdk.http.ntlm.transparentAuth");
            }
        });
        authMode = "trustedHosts".equalsIgnoreCase(modeProp) ? TransparentAuth.TRUSTED_HOSTS : ("allHosts".equalsIgnoreCase(modeProp) ? TransparentAuth.ALL_HOSTS : TransparentAuth.DISABLED);
        isTrustedSiteAvailable = NTLMAuthentication.isTrustedSiteAvailable();
    }

    static enum TransparentAuth {
        DISABLED,
        TRUSTED_HOSTS,
        ALL_HOSTS;

    }
}

