/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Enumeration;
import sun.misc.FIFOQueueEnumerator;
import sun.misc.LIFOQueueEnumerator;
import sun.misc.QueueElement;

public class Queue<T> {
    int length = 0;
    QueueElement<T> head = null;
    QueueElement<T> tail = null;

    public synchronized void enqueue(T obj) {
        QueueElement<T> newElt = new QueueElement<T>(obj);
        if (this.head == null) {
            this.head = newElt;
            this.tail = newElt;
            this.length = 1;
        } else {
            newElt.next = this.head;
            this.head.prev = newElt;
            this.head = newElt;
            ++this.length;
        }
        this.notify();
    }

    public T dequeue() throws InterruptedException {
        return this.dequeue(0L);
    }

    public synchronized T dequeue(long timeOut) throws InterruptedException {
        while (this.tail == null) {
            this.wait(timeOut);
        }
        QueueElement<T> elt = this.tail;
        this.tail = elt.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        --this.length;
        return elt.obj;
    }

    public synchronized boolean isEmpty() {
        return this.tail == null;
    }

    public final synchronized Enumeration<T> elements() {
        return new LIFOQueueEnumerator(this);
    }

    public final synchronized Enumeration<T> reverseElements() {
        return new FIFOQueueEnumerator(this);
    }

    public synchronized void dump(String msg) {
        System.err.println(">> " + msg);
        System.err.println("[" + this.length + " elt(s); head = " + (this.head == null ? "null" : this.head.obj + "") + " tail = " + (this.tail == null ? "null" : this.tail.obj + ""));
        QueueElement<T> cursor = this.head;
        QueueElement<T> last = null;
        while (cursor != null) {
            System.err.println("  " + cursor);
            last = cursor;
            cursor = cursor.next;
        }
        if (last != this.tail) {
            System.err.println("  tail != last: " + this.tail + ", " + last);
        }
        System.err.println("]");
    }
}

