/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

public class FpUtils {
    private FpUtils() {
    }

    @Deprecated
    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    @Deprecated
    public static int getExponent(float f) {
        return Math.getExponent(f);
    }

    @Deprecated
    public static double rawCopySign(double magnitude, double sign) {
        return Math.copySign(magnitude, sign);
    }

    @Deprecated
    public static float rawCopySign(float magnitude, float sign) {
        return Math.copySign(magnitude, sign);
    }

    @Deprecated
    public static boolean isFinite(double d) {
        return Double.isFinite(d);
    }

    @Deprecated
    public static boolean isFinite(float f) {
        return Float.isFinite(f);
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public static boolean isInfinite(float f) {
        return Float.isInfinite(f);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(f);
    }

    public static boolean isUnordered(double arg1, double arg2) {
        return FpUtils.isNaN(arg1) || FpUtils.isNaN(arg2);
    }

    public static boolean isUnordered(float arg1, float arg2) {
        return FpUtils.isNaN(arg1) || FpUtils.isNaN(arg2);
    }

    public static int ilogb(double d) {
        int exponent = FpUtils.getExponent(d);
        switch (exponent) {
            case 1024: {
                if (FpUtils.isNaN(d)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -1023: {
                if (d == 0.0) {
                    return -268435456;
                }
                long transducer = Double.doubleToRawLongBits(d);
                assert ((transducer &= 0xFFFFFFFFFFFFFL) != 0L);
                while (transducer < 0x10000000000000L) {
                    transducer *= 2L;
                    --exponent;
                }
                assert (++exponent >= -1074 && exponent < -1022);
                return exponent;
            }
        }
        assert (exponent >= -1022 && exponent <= 1023);
        return exponent;
    }

    public static int ilogb(float f) {
        int exponent = FpUtils.getExponent(f);
        switch (exponent) {
            case 128: {
                if (FpUtils.isNaN(f)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -127: {
                if (f == 0.0f) {
                    return -268435456;
                }
                int transducer = Float.floatToRawIntBits(f);
                assert ((transducer &= 0x7FFFFF) != 0);
                while (transducer < 0x800000) {
                    transducer *= 2;
                    --exponent;
                }
                assert (++exponent >= -149 && exponent < -126);
                return exponent;
            }
        }
        assert (exponent >= -126 && exponent <= 127);
        return exponent;
    }

    @Deprecated
    public static double scalb(double d, int scale_factor) {
        return Math.scalb(d, scale_factor);
    }

    @Deprecated
    public static float scalb(float f, int scale_factor) {
        return Math.scalb(f, scale_factor);
    }

    @Deprecated
    public static double nextAfter(double start, double direction) {
        return Math.nextAfter(start, direction);
    }

    @Deprecated
    public static float nextAfter(float start, double direction) {
        return Math.nextAfter(start, direction);
    }

    @Deprecated
    public static double nextUp(double d) {
        return Math.nextUp(d);
    }

    @Deprecated
    public static float nextUp(float f) {
        return Math.nextUp(f);
    }

    @Deprecated
    public static double nextDown(double d) {
        return Math.nextDown(d);
    }

    @Deprecated
    public static double nextDown(float f) {
        return Math.nextDown(f);
    }

    @Deprecated
    public static double copySign(double magnitude, double sign) {
        return StrictMath.copySign(magnitude, sign);
    }

    @Deprecated
    public static float copySign(float magnitude, float sign) {
        return StrictMath.copySign(magnitude, sign);
    }

    @Deprecated
    public static double ulp(double d) {
        return Math.ulp(d);
    }

    @Deprecated
    public static float ulp(float f) {
        return Math.ulp(f);
    }

    @Deprecated
    public static double signum(double d) {
        return Math.signum(d);
    }

    @Deprecated
    public static float signum(float f) {
        return Math.signum(f);
    }
}

