/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MonitorInfo;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.LockInfoCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.StackTraceElementCompositeData;

public class MonitorInfoCompositeData
extends LazyCompositeData {
    private final MonitorInfo lock;
    private static final CompositeType monitorInfoCompositeType;
    private static final String[] monitorInfoItemNames;
    private static final String CLASS_NAME = "className";
    private static final String IDENTITY_HASH_CODE = "identityHashCode";
    private static final String LOCKED_STACK_FRAME = "lockedStackFrame";
    private static final String LOCKED_STACK_DEPTH = "lockedStackDepth";
    private static final long serialVersionUID = -5825215591822908529L;

    private MonitorInfoCompositeData(MonitorInfo mi) {
        this.lock = mi;
    }

    public MonitorInfo getMonitorInfo() {
        return this.lock;
    }

    public static CompositeData toCompositeData(MonitorInfo mi) {
        MonitorInfoCompositeData micd = new MonitorInfoCompositeData(mi);
        return micd.getCompositeData();
    }

    @Override
    protected CompositeData getCompositeData() {
        int len = monitorInfoItemNames.length;
        Object[] values = new Object[len];
        CompositeData li = LockInfoCompositeData.toCompositeData(this.lock);
        for (int i = 0; i < len; ++i) {
            StackTraceElement ste;
            String item = monitorInfoItemNames[i];
            values[i] = item.equals(LOCKED_STACK_FRAME) ? ((ste = this.lock.getLockedStackFrame()) != null ? StackTraceElementCompositeData.toCompositeData(ste) : null) : (item.equals(LOCKED_STACK_DEPTH) ? new Integer(this.lock.getLockedStackDepth()) : li.get(item));
        }
        try {
            return new CompositeDataSupport(monitorInfoCompositeType, monitorInfoItemNames, values);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    static CompositeType getMonitorInfoCompositeType() {
        return monitorInfoCompositeType;
    }

    public static String getClassName(CompositeData cd) {
        return MonitorInfoCompositeData.getString(cd, CLASS_NAME);
    }

    public static int getIdentityHashCode(CompositeData cd) {
        return MonitorInfoCompositeData.getInt(cd, IDENTITY_HASH_CODE);
    }

    public static StackTraceElement getLockedStackFrame(CompositeData cd) {
        CompositeData ste = (CompositeData)cd.get(LOCKED_STACK_FRAME);
        if (ste != null) {
            return StackTraceElementCompositeData.from(ste);
        }
        return null;
    }

    public static int getLockedStackDepth(CompositeData cd) {
        return MonitorInfoCompositeData.getInt(cd, LOCKED_STACK_DEPTH);
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!MonitorInfoCompositeData.isTypeMatched(monitorInfoCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for MonitorInfo");
        }
    }

    static {
        try {
            monitorInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(MonitorInfo.class);
            Set<String> s = monitorInfoCompositeType.keySet();
            monitorInfoItemNames = s.toArray(new String[0]);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }
}

