/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.loops.CompositeType;

abstract class D3DPaints {
    private static Map<Integer, D3DPaints> impls = new HashMap<Integer, D3DPaints>(4, 1.0f);

    D3DPaints() {
    }

    static boolean isValid(SunGraphics2D sg2d) {
        D3DPaints impl = impls.get(sg2d.paintState);
        return impl != null && impl.isPaintValid(sg2d);
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    static {
        impls.put(2, new Gradient());
        impls.put(3, new LinearGradient());
        impls.put(4, new RadialGradient());
        impls.put(5, new Texture());
    }

    private static class RadialGradient
    extends MultiGradient {
        private RadialGradient() {
        }
    }

    private static class LinearGradient
    extends MultiGradient {
        private LinearGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            D3DSurfaceData dstData;
            D3DGraphicsDevice gd;
            LinearGradientPaint paint = (LinearGradientPaint)sg2d.paint;
            if (paint.getFractions().length == 2 && paint.getCycleMethod() != MultipleGradientPaint.CycleMethod.REPEAT && paint.getColorSpace() != MultipleGradientPaint.ColorSpaceType.LINEAR_RGB && (gd = (D3DGraphicsDevice)(dstData = (D3DSurfaceData)sg2d.surfaceData).getDeviceConfiguration().getDevice()).isCapPresent(65536)) {
                return true;
            }
            return super.isPaintValid(sg2d);
        }
    }

    private static abstract class MultiGradient
    extends D3DPaints {
        public static final int MULTI_MAX_FRACTIONS_D3D = 8;

        protected MultiGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            MultipleGradientPaint paint = (MultipleGradientPaint)sg2d.paint;
            if (paint.getFractions().length > 8) {
                return false;
            }
            D3DSurfaceData dstData = (D3DSurfaceData)sg2d.surfaceData;
            D3DGraphicsDevice gd = (D3DGraphicsDevice)dstData.getDeviceConfiguration().getDevice();
            return gd.isCapPresent(65536);
        }
    }

    private static class Texture
    extends D3DPaints {
        private Texture() {
        }

        @Override
        public boolean isPaintValid(SunGraphics2D sg2d) {
            D3DSurfaceData d3dData;
            TexturePaint paint = (TexturePaint)sg2d.paint;
            D3DSurfaceData dstData = (D3DSurfaceData)sg2d.surfaceData;
            BufferedImage bi = paint.getImage();
            D3DGraphicsDevice gd = (D3DGraphicsDevice)dstData.getDeviceConfiguration().getDevice();
            int imgw = bi.getWidth();
            int imgh = bi.getHeight();
            if (!(gd.isCapPresent(32) || (imgw & imgw - 1) == 0 && (imgh & imgh - 1) == 0)) {
                return false;
            }
            if (!gd.isCapPresent(64) && imgw != imgh) {
                return false;
            }
            SurfaceData srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null);
            if (!(srcData instanceof D3DSurfaceData)) {
                srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null);
                if (!(srcData instanceof D3DSurfaceData)) {
                    return false;
                }
            }
            return (d3dData = (D3DSurfaceData)srcData).getType() == 3;
        }
    }

    private static class Gradient
    extends D3DPaints {
        private Gradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            D3DSurfaceData dstData = (D3DSurfaceData)sg2d.surfaceData;
            D3DGraphicsDevice gd = (D3DGraphicsDevice)dstData.getDeviceConfiguration().getDevice();
            return gd.isCapPresent(65536);
        }
    }
}

