/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.peer.CheckboxPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

final class WCheckboxPeer
extends WComponentPeer
implements CheckboxPeer {
    @Override
    public native void setState(boolean var1);

    @Override
    public native void setCheckboxGroup(CheckboxGroup var1);

    @Override
    public native void setLabel(String var1);

    private static native int getCheckMarkSize();

    @Override
    public Dimension getMinimumSize() {
        String lbl = ((Checkbox)this.target).getLabel();
        int marksize = WCheckboxPeer.getCheckMarkSize();
        if (lbl == null) {
            lbl = "";
        }
        FontMetrics fm = this.getFontMetrics(((Checkbox)this.target).getFont());
        return new Dimension(fm.stringWidth(lbl) + marksize / 2 + marksize, Math.max(fm.getHeight() + 8, marksize));
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    WCheckboxPeer(Checkbox target) {
        super(target);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        Checkbox t = (Checkbox)this.target;
        this.setState(t.getState());
        this.setCheckboxGroup(t.getCheckboxGroup());
        Color bg = ((Component)this.target).getBackground();
        if (bg != null) {
            this.setBackground(bg);
        }
        super.initialize();
    }

    @Override
    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    void handleAction(final boolean state) {
        final Checkbox cb = (Checkbox)this.target;
        WToolkit.executeOnEventHandlerThread(cb, new Runnable(){

            @Override
            public void run() {
                CheckboxGroup chg = cb.getCheckboxGroup();
                if (chg != null && cb == chg.getSelectedCheckbox() && cb.getState()) {
                    return;
                }
                cb.setState(state);
                WCheckboxPeer.this.postEvent(new ItemEvent(cb, 701, cb.getLabel(), state ? 1 : 2));
            }
        });
    }
}

