/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static final Actions SHARED_ACTION = new Actions();
    private Handler handler;
    private PropertyChangeListener pcl;
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    @Deprecated
    protected KeyStroke minimizeKey;
    @Deprecated
    protected KeyStroke maximizeKey;
    @Deprecated
    protected KeyStroke closeKey;
    @Deprecated
    protected KeyStroke navigateKey;
    @Deprecated
    protected KeyStroke navigateKey2;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDesktopPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.desktop = (JDesktopPane)c;
        this.installDefaults();
        this.installDesktopManager();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
        this.handler = null;
    }

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
        LookAndFeel.installProperty(this.desktop, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.pcl = this.createPropertyChangeListener();
        this.desktop.addPropertyChangeListener(this.pcl);
    }

    protected void uninstallListeners() {
        this.desktop.removePropertyChangeListener(this.pcl);
        this.pcl = null;
    }

    protected void installDesktopManager() {
        this.desktopManager = this.desktop.getDesktopManager();
        if (this.desktopManager == null) {
            this.desktopManager = new BasicDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() instanceof UIResource) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        LazyActionMap.installLazyActionMap(this.desktop, BasicDesktopPaneUI.class, "DesktopPane.actionMap");
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    InputMap getInputMap(int condition) {
        if (condition == 2) {
            return this.createInputMap(condition);
        }
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.desktop, this, "Desktop.ancestorInputMap");
        }
        return null;
    }

    InputMap createInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])DefaultLookup.get(this.desktop, this, "Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, bindings);
        }
        return null;
    }

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions(Actions.RESTORE));
        map.put(new Actions(Actions.CLOSE));
        map.put(new Actions(Actions.MOVE));
        map.put(new Actions(Actions.RESIZE));
        map.put(new Actions(Actions.LEFT));
        map.put(new Actions(Actions.SHRINK_LEFT));
        map.put(new Actions(Actions.RIGHT));
        map.put(new Actions(Actions.SHRINK_RIGHT));
        map.put(new Actions(Actions.UP));
        map.put(new Actions(Actions.SHRINK_UP));
        map.put(new Actions(Actions.DOWN));
        map.put(new Actions(Actions.SHRINK_DOWN));
        map.put(new Actions(Actions.ESCAPE));
        map.put(new Actions(Actions.MINIMIZE));
        map.put(new Actions(Actions.MAXIMIZE));
        map.put(new Actions(Actions.NEXT_FRAME));
        map.put(new Actions(Actions.PREVIOUS_FRAME));
        map.put(new Actions(Actions.NAVIGATE_NEXT));
        map.put(new Actions(Actions.NAVIGATE_PREVIOUS));
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JDesktopPane dp = (JDesktopPane)evt.getSource();
            dp.selectFrame(true);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JDesktopPane dp = (JDesktopPane)evt.getSource();
            SHARED_ACTION.setState(dp, Actions.MAXIMIZE);
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame iFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (iFrame != null) {
                return iFrame.isMaximizable();
            }
            return false;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JDesktopPane dp = (JDesktopPane)evt.getSource();
            SHARED_ACTION.setState(dp, Actions.MINIMIZE);
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame iFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (iFrame != null) {
                return iFrame.isIconifiable();
            }
            return false;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JDesktopPane dp = (JDesktopPane)evt.getSource();
            SHARED_ACTION.setState(dp, Actions.CLOSE);
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame iFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (iFrame != null) {
                return iFrame.isClosable();
            }
            return false;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JDesktopPane dp = (JDesktopPane)evt.getSource();
            SHARED_ACTION.setState(dp, Actions.RESTORE);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private static class Actions
    extends UIAction {
        private static String CLOSE = "close";
        private static String ESCAPE = "escape";
        private static String MAXIMIZE = "maximize";
        private static String MINIMIZE = "minimize";
        private static String MOVE = "move";
        private static String RESIZE = "resize";
        private static String RESTORE = "restore";
        private static String LEFT = "left";
        private static String RIGHT = "right";
        private static String UP = "up";
        private static String DOWN = "down";
        private static String SHRINK_LEFT = "shrinkLeft";
        private static String SHRINK_RIGHT = "shrinkRight";
        private static String SHRINK_UP = "shrinkUp";
        private static String SHRINK_DOWN = "shrinkDown";
        private static String NEXT_FRAME = "selectNextFrame";
        private static String PREVIOUS_FRAME = "selectPreviousFrame";
        private static String NAVIGATE_NEXT = "navigateNext";
        private static String NAVIGATE_PREVIOUS = "navigatePrevious";
        private final int MOVE_RESIZE_INCREMENT = 10;
        private static boolean moving = false;
        private static boolean resizing = false;
        private static JInternalFrame sourceFrame = null;
        private static Component focusOwner = null;

        Actions() {
            super(null);
        }

        Actions(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JDesktopPane dp = (JDesktopPane)e.getSource();
            String key = this.getName();
            if (CLOSE == key || MAXIMIZE == key || MINIMIZE == key || RESTORE == key) {
                this.setState(dp, key);
            } else if (ESCAPE == key) {
                if (sourceFrame == dp.getSelectedFrame() && focusOwner != null) {
                    focusOwner.requestFocus();
                }
                moving = false;
                resizing = false;
                sourceFrame = null;
                focusOwner = null;
            } else if (MOVE == key || RESIZE == key) {
                sourceFrame = dp.getSelectedFrame();
                if (sourceFrame == null) {
                    return;
                }
                moving = key == MOVE;
                resizing = key == RESIZE;
                focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (!SwingUtilities.isDescendingFrom(focusOwner, sourceFrame)) {
                    focusOwner = null;
                }
                sourceFrame.requestFocus();
            } else if (LEFT == key || RIGHT == key || UP == key || DOWN == key || SHRINK_RIGHT == key || SHRINK_LEFT == key || SHRINK_UP == key || SHRINK_DOWN == key) {
                JInternalFrame c = dp.getSelectedFrame();
                if (sourceFrame == null || c != sourceFrame || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != sourceFrame) {
                    return;
                }
                Insets minOnScreenInsets = UIManager.getInsets("Desktop.minOnScreenInsets");
                Dimension size = c.getSize();
                Dimension minSize = c.getMinimumSize();
                int dpWidth = dp.getWidth();
                int dpHeight = dp.getHeight();
                Point loc = c.getLocation();
                if (LEFT == key) {
                    if (moving) {
                        c.setLocation(loc.x + size.width - 10 < minOnScreenInsets.right ? -size.width + minOnScreenInsets.right : loc.x - 10, loc.y);
                    } else if (resizing) {
                        c.setLocation(loc.x - 10, loc.y);
                        c.setSize(size.width + 10, size.height);
                    }
                } else if (RIGHT == key) {
                    if (moving) {
                        c.setLocation(loc.x + 10 > dpWidth - minOnScreenInsets.left ? dpWidth - minOnScreenInsets.left : loc.x + 10, loc.y);
                    } else if (resizing) {
                        c.setSize(size.width + 10, size.height);
                    }
                } else if (UP == key) {
                    if (moving) {
                        c.setLocation(loc.x, loc.y + size.height - 10 < minOnScreenInsets.bottom ? -size.height + minOnScreenInsets.bottom : loc.y - 10);
                    } else if (resizing) {
                        c.setLocation(loc.x, loc.y - 10);
                        c.setSize(size.width, size.height + 10);
                    }
                } else if (DOWN == key) {
                    if (moving) {
                        c.setLocation(loc.x, loc.y + 10 > dpHeight - minOnScreenInsets.top ? dpHeight - minOnScreenInsets.top : loc.y + 10);
                    } else if (resizing) {
                        c.setSize(size.width, size.height + 10);
                    }
                } else if (SHRINK_LEFT == key && resizing) {
                    int delta = minSize.width < size.width - 10 ? 10 : size.width - minSize.width;
                    if (loc.x + size.width - delta < minOnScreenInsets.left) {
                        delta = loc.x + size.width - minOnScreenInsets.left;
                    }
                    c.setSize(size.width - delta, size.height);
                } else if (SHRINK_RIGHT == key && resizing) {
                    int delta = minSize.width < size.width - 10 ? 10 : size.width - minSize.width;
                    if (loc.x + delta > dpWidth - minOnScreenInsets.right) {
                        delta = dpWidth - minOnScreenInsets.right - loc.x;
                    }
                    c.setLocation(loc.x + delta, loc.y);
                    c.setSize(size.width - delta, size.height);
                } else if (SHRINK_UP == key && resizing) {
                    int delta = minSize.height < size.height - 10 ? 10 : size.height - minSize.height;
                    if (loc.y + size.height - delta < minOnScreenInsets.bottom) {
                        delta = loc.y + size.height - minOnScreenInsets.bottom;
                    }
                    c.setSize(size.width, size.height - delta);
                } else if (SHRINK_DOWN == key && resizing) {
                    int delta = minSize.height < size.height - 10 ? 10 : size.height - minSize.height;
                    if (loc.y + delta > dpHeight - minOnScreenInsets.top) {
                        delta = dpHeight - minOnScreenInsets.top - loc.y;
                    }
                    c.setLocation(loc.x, loc.y + delta);
                    c.setSize(size.width, size.height - delta);
                }
            } else if (NEXT_FRAME == key || PREVIOUS_FRAME == key) {
                dp.selectFrame(key == NEXT_FRAME);
            } else if (NAVIGATE_NEXT == key || NAVIGATE_PREVIOUS == key) {
                FocusTraversalPolicy policy;
                Container cycleRoot;
                boolean moveForward = true;
                if (NAVIGATE_PREVIOUS == key) {
                    moveForward = false;
                }
                if ((cycleRoot = dp.getFocusCycleRootAncestor()) != null && (policy = cycleRoot.getFocusTraversalPolicy()) != null && policy instanceof SortingFocusTraversalPolicy) {
                    SortingFocusTraversalPolicy sPolicy = (SortingFocusTraversalPolicy)policy;
                    boolean idc = sPolicy.getImplicitDownCycleTraversal();
                    try {
                        sPolicy.setImplicitDownCycleTraversal(false);
                        if (moveForward) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(dp);
                        } else {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(dp);
                        }
                    }
                    finally {
                        sPolicy.setImplicitDownCycleTraversal(idc);
                    }
                }
            }
        }

        private void setState(JDesktopPane dp, String state) {
            if (state == CLOSE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                f.doDefaultCloseAction();
            } else if (state == MAXIMIZE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                if (!f.isMaximum()) {
                    if (f.isIcon()) {
                        try {
                            f.setIcon(false);
                            f.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            f.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                }
            } else if (state == MINIMIZE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                if (!f.isIcon()) {
                    try {
                        f.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (state == RESTORE) {
                JInternalFrame f = dp.getSelectedFrame();
                if (f == null) {
                    return;
                }
                try {
                    if (f.isIcon()) {
                        f.setIcon(false);
                    } else if (f.isMaximum()) {
                        f.setMaximum(false);
                    }
                    f.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isEnabled(Object sender) {
            if (sender instanceof JDesktopPane) {
                JDesktopPane dp = (JDesktopPane)sender;
                String action = this.getName();
                if (action == NEXT_FRAME || action == PREVIOUS_FRAME) {
                    return true;
                }
                JInternalFrame iFrame = dp.getSelectedFrame();
                if (iFrame == null) {
                    return false;
                }
                if (action == CLOSE) {
                    return iFrame.isClosable();
                }
                if (action == MINIMIZE) {
                    return iFrame.isIconifiable();
                }
                if (action == MAXIMIZE) {
                    return iFrame.isMaximizable();
                }
                return true;
            }
            return false;
        }
    }

    private class BasicDesktopManager
    extends DefaultDesktopManager
    implements UIResource {
        private BasicDesktopManager() {
        }
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("desktopManager" == propertyName) {
                BasicDesktopPaneUI.this.installDesktopManager();
            }
        }
    }
}

