/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Arrays;

public class BatchUpdateException
extends SQLException {
    private int[] updateCounts;
    private long[] longUpdateCounts;
    private static final long serialVersionUID = 5977529877145521757L;

    public BatchUpdateException(String reason, String SQLState, int vendorCode, int[] updateCounts) {
        super(reason, SQLState, vendorCode);
        this.updateCounts = updateCounts == null ? null : Arrays.copyOf(updateCounts, updateCounts.length);
        this.longUpdateCounts = updateCounts == null ? null : BatchUpdateException.copyUpdateCount(updateCounts);
    }

    public BatchUpdateException(String reason, String SQLState, int[] updateCounts) {
        this(reason, SQLState, 0, updateCounts);
    }

    public BatchUpdateException(String reason, int[] updateCounts) {
        this(reason, null, 0, updateCounts);
    }

    public BatchUpdateException(int[] updateCounts) {
        this(null, null, 0, updateCounts);
    }

    public BatchUpdateException() {
        this((String)null, (String)null, 0, (int[])null);
    }

    public BatchUpdateException(Throwable cause) {
        this(cause == null ? null : cause.toString(), (String)null, 0, (int[])null, cause);
    }

    public BatchUpdateException(int[] updateCounts, Throwable cause) {
        this(cause == null ? null : cause.toString(), (String)null, 0, updateCounts, cause);
    }

    public BatchUpdateException(String reason, int[] updateCounts, Throwable cause) {
        this(reason, (String)null, 0, updateCounts, cause);
    }

    public BatchUpdateException(String reason, String SQLState, int[] updateCounts, Throwable cause) {
        this(reason, SQLState, 0, updateCounts, cause);
    }

    public BatchUpdateException(String reason, String SQLState, int vendorCode, int[] updateCounts, Throwable cause) {
        super(reason, SQLState, vendorCode, cause);
        this.updateCounts = updateCounts == null ? null : Arrays.copyOf(updateCounts, updateCounts.length);
        this.longUpdateCounts = updateCounts == null ? null : BatchUpdateException.copyUpdateCount(updateCounts);
    }

    public int[] getUpdateCounts() {
        return this.updateCounts == null ? null : Arrays.copyOf(this.updateCounts, this.updateCounts.length);
    }

    public BatchUpdateException(String reason, String SQLState, int vendorCode, long[] updateCounts, Throwable cause) {
        super(reason, SQLState, vendorCode, cause);
        this.longUpdateCounts = updateCounts == null ? null : Arrays.copyOf(updateCounts, updateCounts.length);
        this.updateCounts = this.longUpdateCounts == null ? null : BatchUpdateException.copyUpdateCount(this.longUpdateCounts);
    }

    public long[] getLargeUpdateCounts() {
        return this.longUpdateCounts == null ? null : Arrays.copyOf(this.longUpdateCounts, this.longUpdateCounts.length);
    }

    private static long[] copyUpdateCount(int[] uc) {
        long[] copy = new long[uc.length];
        for (int i = 0; i < uc.length; ++i) {
            copy[i] = uc[i];
        }
        return copy;
    }

    private static int[] copyUpdateCount(long[] uc) {
        int[] copy = new int[uc.length];
        for (int i = 0; i < uc.length; ++i) {
            copy[i] = (int)uc[i];
        }
        return copy;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        int[] tmp = (int[])fields.get("updateCounts", null);
        long[] tmp2 = (long[])fields.get("longUpdateCounts", null);
        if (tmp != null && tmp2 != null && tmp.length != tmp2.length) {
            throw new InvalidObjectException("update counts are not the expected size");
        }
        if (tmp != null) {
            this.updateCounts = (int[])tmp.clone();
        }
        if (tmp2 != null) {
            this.longUpdateCounts = (long[])tmp2.clone();
        }
        if (this.updateCounts == null && this.longUpdateCounts != null) {
            this.updateCounts = BatchUpdateException.copyUpdateCount(this.longUpdateCounts);
        }
        if (this.longUpdateCounts == null && this.updateCounts != null) {
            this.longUpdateCounts = BatchUpdateException.copyUpdateCount(this.updateCounts);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("updateCounts", this.updateCounts);
        fields.put("longUpdateCounts", this.longUpdateCounts);
        s.writeFields();
    }
}

