/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.WrapperInstance;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class MethodHandleProxies {
    private MethodHandleProxies() {
    }

    @CallerSensitive
    public static <T> T asInterfaceInstance(final Class<T> intfc, final MethodHandle target) {
        Object proxy;
        Method[] methods;
        MethodHandle mh;
        if (!intfc.isInterface() || !Modifier.isPublic(intfc.getModifiers())) {
            throw MethodHandleStatics.newIllegalArgumentException("not a public interface", intfc.getName());
        }
        if (System.getSecurityManager() != null) {
            Class<?> caller = Reflection.getCallerClass();
            ClassLoader ccl = caller != null ? caller.getClassLoader() : null;
            ReflectUtil.checkProxyPackageAccess(ccl, intfc);
            mh = ccl != null ? MethodHandleProxies.bindCaller(target, caller) : target;
        } else {
            mh = target;
        }
        ClassLoader proxyLoader = intfc.getClassLoader();
        if (proxyLoader == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = proxyLoader = cl != null ? cl : ClassLoader.getSystemClassLoader();
        }
        if ((methods = MethodHandleProxies.getSingleNameMethods(intfc)) == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not a single-method interface", intfc.getName());
        }
        final MethodHandle[] vaTargets = new MethodHandle[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method sm = methods[i];
            MethodType smMT = MethodType.methodType(sm.getReturnType(), sm.getParameterTypes());
            MethodHandle checkTarget = mh.asType(smMT);
            checkTarget = checkTarget.asType(checkTarget.type().changeReturnType(Object.class));
            vaTargets[i] = checkTarget.asSpreader(Object[].class, smMT.parameterCount());
        }
        final ConcurrentHashMap defaultMethodMap = MethodHandleProxies.hasDefaultMethods(intfc) ? new ConcurrentHashMap() : null;
        final InvocationHandler ih = new InvocationHandler(){

            private Object getArg(String name) {
                if (name == "getWrapperInstanceTarget") {
                    return target;
                }
                if (name == "getWrapperInstanceType") {
                    return intfc;
                }
                throw new AssertionError();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                for (int i = 0; i < methods.length; ++i) {
                    if (!method.equals(methods[i])) continue;
                    return vaTargets[i].invokeExact(args);
                }
                if (method.getDeclaringClass() == WrapperInstance.class) {
                    return this.getArg(method.getName());
                }
                if (MethodHandleProxies.isObjectMethod(method)) {
                    return MethodHandleProxies.callObjectMethod(proxy, method, args);
                }
                if (MethodHandleProxies.isDefaultMethod(method)) {
                    return MethodHandleProxies.callDefaultMethod(defaultMethodMap, proxy, intfc, method, args);
                }
                throw MethodHandleStatics.newInternalError("bad proxy method: " + method);
            }
        };
        if (System.getSecurityManager() != null) {
            final ClassLoader loader = proxyLoader;
            proxy = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return Proxy.newProxyInstance(loader, new Class[]{intfc, WrapperInstance.class}, ih);
                }
            });
        } else {
            proxy = Proxy.newProxyInstance(proxyLoader, new Class[]{intfc, WrapperInstance.class}, ih);
        }
        return intfc.cast(proxy);
    }

    private static MethodHandle bindCaller(MethodHandle target, Class<?> hostClass) {
        MethodHandle cbmh = MethodHandleImpl.bindCaller(target, hostClass);
        if (target.isVarargsCollector()) {
            MethodType type = cbmh.type();
            int arity = type.parameterCount();
            return cbmh.asVarargsCollector(type.parameterType(arity - 1));
        }
        return cbmh;
    }

    public static boolean isWrapperInstance(Object x) {
        return x instanceof WrapperInstance;
    }

    private static WrapperInstance asWrapperInstance(Object x) {
        try {
            if (x != null) {
                return (WrapperInstance)x;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw MethodHandleStatics.newIllegalArgumentException("not a wrapper instance");
    }

    public static MethodHandle wrapperInstanceTarget(Object x) {
        return MethodHandleProxies.asWrapperInstance(x).getWrapperInstanceTarget();
    }

    public static Class<?> wrapperInstanceType(Object x) {
        return MethodHandleProxies.asWrapperInstance(x).getWrapperInstanceType();
    }

    private static boolean isObjectMethod(Method m) {
        switch (m.getName()) {
            case "toString": {
                return m.getReturnType() == String.class && m.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return m.getReturnType() == Integer.TYPE && m.getParameterTypes().length == 0;
            }
            case "equals": {
                return m.getReturnType() == Boolean.TYPE && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private static Object callObjectMethod(Object self, Method m, Object[] args) {
        assert (MethodHandleProxies.isObjectMethod(m)) : m;
        switch (m.getName()) {
            case "toString": {
                return self.getClass().getName() + "@" + Integer.toHexString(self.hashCode());
            }
            case "hashCode": {
                return System.identityHashCode(self);
            }
            case "equals": {
                return self == args[0];
            }
        }
        return null;
    }

    private static Method[] getSingleNameMethods(Class<?> intfc) {
        ArrayList<Method> methods = new ArrayList<Method>();
        String uniqueName = null;
        for (Method m : intfc.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(m) || !Modifier.isAbstract(m.getModifiers())) continue;
            String mname = m.getName();
            if (uniqueName == null) {
                uniqueName = mname;
            } else if (!uniqueName.equals(mname)) {
                return null;
            }
            methods.add(m);
        }
        if (uniqueName == null) {
            return null;
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static boolean isDefaultMethod(Method m) {
        return !Modifier.isAbstract(m.getModifiers());
    }

    private static boolean hasDefaultMethods(Class<?> intfc) {
        for (Method m : intfc.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(m) || Modifier.isAbstract(m.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static Object callDefaultMethod(ConcurrentHashMap<Method, MethodHandle> defaultMethodMap, Object self, Class<?> intfc, Method m, Object[] args) throws Throwable {
        assert (MethodHandleProxies.isDefaultMethod(m) && !MethodHandleProxies.isObjectMethod(m)) : m;
        MethodHandle dmh = defaultMethodMap.computeIfAbsent(m, mk -> {
            try {
                MethodHandle mh = MethodHandles.Lookup.IMPL_LOOKUP.findSpecial(intfc, mk.getName(), MethodType.methodType(mk.getReturnType(), mk.getParameterTypes()), self.getClass());
                return mh.asSpreader(Object[].class, mk.getParameterCount());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new InternalError(e);
            }
        });
        return dmh.invoke(self, args);
    }
}

