/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.DontInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaFormEditor;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.Stable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import sun.invoke.util.Wrapper;

class LambdaForm {
    final int arity;
    final int result;
    final boolean forceInline;
    final MethodHandle customized;
    @Stable
    final Name[] names;
    final String debugName;
    MemberName vmentry;
    private boolean isCompiled;
    volatile Object transformCache;
    public static final int VOID_RESULT = -1;
    public static final int LAST_RESULT = -2;
    private static final boolean USE_PREDEFINED_INTERPRET_METHODS = true;
    private static final int COMPILE_THRESHOLD = Math.max(-1, MethodHandleStatics.COMPILE_THRESHOLD);
    private int invocationCounter = 0;
    static final int INTERNED_ARGUMENT_LIMIT = 10;
    private static final Name[][] INTERNED_ARGUMENTS = new Name[BasicType.ARG_TYPE_LIMIT][10];
    private static final MemberName.Factory IMPL_NAMES;
    private static final LambdaForm[] LF_identityForm;
    private static final LambdaForm[] LF_zeroForm;
    private static final NamedFunction[] NF_identity;
    private static final NamedFunction[] NF_zero;
    private static final HashMap<String, Integer> DEBUG_NAME_COUNTERS;
    private static final boolean TRACE_INTERPRETER;

    LambdaForm(String debugName, int arity, Name[] names, int result) {
        this(debugName, arity, names, result, true, null);
    }

    LambdaForm(String debugName, int arity, Name[] names, int result, boolean forceInline, MethodHandle customized) {
        assert (LambdaForm.namesOK(arity, names));
        this.arity = arity;
        this.result = LambdaForm.fixResult(result, names);
        this.names = (Name[])names.clone();
        this.debugName = LambdaForm.fixDebugName(debugName);
        this.forceInline = forceInline;
        this.customized = customized;
        int maxOutArity = this.normalize();
        if (maxOutArity > 253) {
            assert (maxOutArity <= 255);
            this.compileToBytecode();
        }
    }

    LambdaForm(String debugName, int arity, Name[] names) {
        this(debugName, arity, names, -2, true, null);
    }

    LambdaForm(String debugName, int arity, Name[] names, boolean forceInline) {
        this(debugName, arity, names, -2, forceInline, null);
    }

    LambdaForm(String debugName, Name[] formals, Name[] temps, Name result) {
        this(debugName, formals.length, LambdaForm.buildNames(formals, temps, result), -2, true, null);
    }

    LambdaForm(String debugName, Name[] formals, Name[] temps, Name result, boolean forceInline) {
        this(debugName, formals.length, LambdaForm.buildNames(formals, temps, result), -2, forceInline, null);
    }

    private static Name[] buildNames(Name[] formals, Name[] temps, Name result) {
        int arity = formals.length;
        int length = arity + temps.length + (result == null ? 0 : 1);
        Name[] names = Arrays.copyOf(formals, length);
        System.arraycopy(temps, 0, names, arity, temps.length);
        if (result != null) {
            names[length - 1] = result;
        }
        return names;
    }

    private LambdaForm(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        this.arity = LambdaForm.signatureArity(sig);
        this.result = LambdaForm.signatureReturn(sig) == BasicType.V_TYPE ? -1 : this.arity;
        this.names = LambdaForm.buildEmptyNames(this.arity, sig);
        this.debugName = "LF.zero";
        this.forceInline = true;
        this.customized = null;
        assert (this.nameRefsAreLegal());
        assert (this.isEmpty());
        assert (sig.equals(this.basicTypeSignature())) : sig + " != " + this.basicTypeSignature();
    }

    private static Name[] buildEmptyNames(int arity, String basicTypeSignature) {
        assert (LambdaForm.isValidSignature(basicTypeSignature));
        int resultPos = arity + 1;
        if (arity < 0 || basicTypeSignature.length() != resultPos + 1) {
            throw new IllegalArgumentException("bad arity for " + basicTypeSignature);
        }
        int numRes = BasicType.basicType(basicTypeSignature.charAt(resultPos)) == BasicType.V_TYPE ? 0 : 1;
        Name[] names = LambdaForm.arguments(numRes, basicTypeSignature.substring(0, arity));
        for (int i = 0; i < numRes; ++i) {
            Name zero = new Name(LambdaForm.constantZero(BasicType.basicType(basicTypeSignature.charAt(resultPos + i))), new Object[0]);
            names[arity + i] = zero.newIndex(arity + i);
        }
        return names;
    }

    private static int fixResult(int result, Name[] names) {
        if (result == -2) {
            result = names.length - 1;
        }
        if (result >= 0 && names[result].type == BasicType.V_TYPE) {
            result = -1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fixDebugName(String debugName) {
        if (DEBUG_NAME_COUNTERS != null) {
            Integer ctr;
            int under = debugName.indexOf(95);
            int length = debugName.length();
            if (under < 0) {
                under = length;
            }
            String debugNameStem = debugName.substring(0, under);
            HashMap<String, Integer> hashMap = DEBUG_NAME_COUNTERS;
            synchronized (hashMap) {
                ctr = DEBUG_NAME_COUNTERS.get(debugNameStem);
                if (ctr == null) {
                    ctr = 0;
                }
                DEBUG_NAME_COUNTERS.put(debugNameStem, ctr + 1);
            }
            StringBuilder buf = new StringBuilder(debugNameStem);
            buf.append('_');
            int leadingZero = buf.length();
            buf.append(ctr);
            for (int i = buf.length() - leadingZero; i < 3; ++i) {
                buf.insert(leadingZero, '0');
            }
            if (under < length) {
                ++under;
                while (under < length && Character.isDigit(debugName.charAt(under))) {
                    ++under;
                }
                if (under < length && debugName.charAt(under) == '_') {
                    ++under;
                }
                if (under < length) {
                    buf.append('_').append(debugName, under, length);
                }
            }
            return buf.toString();
        }
        return debugName;
    }

    private static boolean namesOK(int arity, Name[] names) {
        for (int i = 0; i < names.length; ++i) {
            Name n = names[i];
            assert (n != null) : "n is null";
            if (i < arity) {
                assert (n.isParam()) : n + " is not param at " + i;
                continue;
            }
            assert (!n.isParam()) : n + " is param at " + i;
        }
        return true;
    }

    LambdaForm customize(MethodHandle mh) {
        LambdaForm customForm = new LambdaForm(this.debugName, this.arity, this.names, this.result, this.forceInline, mh);
        if (COMPILE_THRESHOLD > 0 && this.isCompiled) {
            customForm.compileToBytecode();
        }
        customForm.transformCache = this;
        return customForm;
    }

    LambdaForm uncustomize() {
        if (this.customized == null) {
            return this;
        }
        assert (this.transformCache != null);
        LambdaForm uncustomizedForm = (LambdaForm)this.transformCache;
        if (COMPILE_THRESHOLD > 0 && this.isCompiled) {
            uncustomizedForm.compileToBytecode();
        }
        return uncustomizedForm;
    }

    private int normalize() {
        int i;
        Name[] oldNames = null;
        int maxOutArity = 0;
        int changesStart = 0;
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            Name n = this.names[i2];
            if (!n.initIndex(i2)) {
                if (oldNames == null) {
                    oldNames = (Name[])this.names.clone();
                    changesStart = i2;
                }
                this.names[i2] = n.cloneWithIndex(i2);
            }
            if (n.arguments == null || maxOutArity >= n.arguments.length) continue;
            maxOutArity = n.arguments.length;
        }
        if (oldNames != null) {
            int startFixing = this.arity;
            if (startFixing <= changesStart) {
                startFixing = changesStart + 1;
            }
            for (int i3 = startFixing; i3 < this.names.length; ++i3) {
                Name fixed = this.names[i3].replaceNames(oldNames, this.names, changesStart, i3);
                this.names[i3] = fixed.newIndex(i3);
            }
        }
        assert (this.nameRefsAreLegal());
        int maxInterned = Math.min(this.arity, 10);
        boolean needIntern = false;
        for (i = 0; i < maxInterned; ++i) {
            Name n = this.names[i];
            Name n2 = LambdaForm.internArgument(n);
            if (n == n2) continue;
            this.names[i] = n2;
            needIntern = true;
        }
        if (needIntern) {
            for (i = this.arity; i < this.names.length; ++i) {
                this.names[i].internArguments();
            }
        }
        assert (this.nameRefsAreLegal());
        return maxOutArity;
    }

    boolean nameRefsAreLegal() {
        Name n;
        int i;
        assert (this.arity >= 0 && this.arity <= this.names.length);
        assert (this.result >= -1 && this.result < this.names.length);
        for (i = 0; i < this.arity; ++i) {
            n = this.names[i];
            assert (n.index() == i) : Arrays.asList(n.index(), i);
            assert (n.isParam());
        }
        for (i = this.arity; i < this.names.length; ++i) {
            n = this.names[i];
            assert (n.index() == i);
            for (Object arg : n.arguments) {
                if (!(arg instanceof Name)) continue;
                Name n2 = (Name)arg;
                short i2 = n2.index;
                assert (0 <= i2 && i2 < this.names.length) : n.debugString() + ": 0 <= i2 && i2 < names.length: 0 <= " + i2 + " < " + this.names.length;
                assert (this.names[i2] == n2) : Arrays.asList("-1-", i, "-2-", n.debugString(), "-3-", i2, "-4-", n2.debugString(), "-5-", this.names[i2].debugString(), "-6-", this);
                assert (i2 < i);
            }
        }
        return true;
    }

    BasicType returnType() {
        if (this.result < 0) {
            return BasicType.V_TYPE;
        }
        Name n = this.names[this.result];
        return n.type;
    }

    BasicType parameterType(int n) {
        return this.parameter((int)n).type;
    }

    Name parameter(int n) {
        assert (n < this.arity);
        Name param = this.names[n];
        assert (param.isParam());
        return param;
    }

    Object parameterConstraint(int n) {
        return this.parameter((int)n).constraint;
    }

    int arity() {
        return this.arity;
    }

    int expressionCount() {
        return this.names.length - this.arity;
    }

    MethodType methodType() {
        return LambdaForm.signatureType(this.basicTypeSignature());
    }

    final String basicTypeSignature() {
        StringBuilder buf = new StringBuilder(this.arity() + 3);
        int a = this.arity();
        for (int i = 0; i < a; ++i) {
            buf.append(this.parameterType(i).basicTypeChar());
        }
        return buf.append('_').append(this.returnType().basicTypeChar()).toString();
    }

    static int signatureArity(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        return sig.indexOf(95);
    }

    static BasicType signatureReturn(String sig) {
        return BasicType.basicType(sig.charAt(LambdaForm.signatureArity(sig) + 1));
    }

    static boolean isValidSignature(String sig) {
        int arity = sig.indexOf(95);
        if (arity < 0) {
            return false;
        }
        int siglen = sig.length();
        if (siglen != arity + 2) {
            return false;
        }
        for (int i = 0; i < siglen; ++i) {
            if (i == arity) continue;
            char c = sig.charAt(i);
            if (c == 'V') {
                return i == siglen - 1 && arity == siglen - 2;
            }
            if (BasicType.isArgBasicTypeChar(c)) continue;
            return false;
        }
        return true;
    }

    static MethodType signatureType(String sig) {
        Class[] ptypes = new Class[LambdaForm.signatureArity(sig)];
        for (int i = 0; i < ptypes.length; ++i) {
            ptypes[i] = BasicType.basicType(sig.charAt(i)).btClass;
        }
        Class rtype = LambdaForm.signatureReturn(sig).btClass;
        return MethodType.methodType(rtype, ptypes);
    }

    public void prepare() {
        if (COMPILE_THRESHOLD == 0 && !this.isCompiled) {
            this.compileToBytecode();
        }
        if (this.vmentry != null) {
            return;
        }
        LambdaForm prep = LambdaForm.getPreparedForm(this.basicTypeSignature());
        this.vmentry = prep.vmentry;
    }

    MemberName compileToBytecode() {
        if (this.vmentry != null && this.isCompiled) {
            return this.vmentry;
        }
        MethodType invokerType = this.methodType();
        assert (this.vmentry == null || this.vmentry.getMethodType().basicType().equals((Object)invokerType));
        try {
            this.vmentry = InvokerBytecodeGenerator.generateCustomizedCode(this, invokerType);
            if (TRACE_INTERPRETER) {
                LambdaForm.traceInterpreter("compileToBytecode", this);
            }
            this.isCompiled = true;
            return this.vmentry;
        }
        catch (Error | Exception ex) {
            throw MethodHandleStatics.newInternalError(this.toString(), ex);
        }
    }

    private static void computeInitialPreparedForms() {
        for (MemberName m : MemberName.getFactory().getMethods(LambdaForm.class, false, null, null, null)) {
            MethodType mt;
            if (!m.isStatic() || !m.isPackage() || (mt = m.getMethodType()).parameterCount() <= 0 || mt.parameterType(0) != MethodHandle.class || !m.getName().startsWith("interpret_")) continue;
            String sig = LambdaForm.basicTypeSignature(mt);
            assert (m.getName().equals("interpret" + sig.substring(sig.indexOf(95))));
            LambdaForm form = new LambdaForm(sig);
            form.vmentry = m;
            form = mt.form().setCachedLambdaForm(6, form);
        }
    }

    static Object interpret_L(MethodHandle mh) throws Throwable {
        Object[] av = new Object[]{mh};
        String sig = null;
        if (!$assertionsDisabled) {
            sig = "L_L";
            if (!LambdaForm.argumentTypesMatch("L_L", av)) {
                throw new AssertionError();
            }
        }
        Object res = mh.form.interpretWithArguments(av);
        assert (LambdaForm.returnTypesMatch(sig, av, res));
        return res;
    }

    static Object interpret_L(MethodHandle mh, Object x1) throws Throwable {
        Object[] av = new Object[]{mh, x1};
        String sig = null;
        if (!$assertionsDisabled) {
            sig = "LL_L";
            if (!LambdaForm.argumentTypesMatch("LL_L", av)) {
                throw new AssertionError();
            }
        }
        Object res = mh.form.interpretWithArguments(av);
        assert (LambdaForm.returnTypesMatch(sig, av, res));
        return res;
    }

    static Object interpret_L(MethodHandle mh, Object x1, Object x2) throws Throwable {
        Object[] av = new Object[]{mh, x1, x2};
        String sig = null;
        if (!$assertionsDisabled) {
            sig = "LLL_L";
            if (!LambdaForm.argumentTypesMatch("LLL_L", av)) {
                throw new AssertionError();
            }
        }
        Object res = mh.form.interpretWithArguments(av);
        assert (LambdaForm.returnTypesMatch(sig, av, res));
        return res;
    }

    private static LambdaForm getPreparedForm(String sig) {
        MethodType mtype = LambdaForm.signatureType(sig);
        LambdaForm prep = mtype.form().cachedLambdaForm(6);
        if (prep != null) {
            return prep;
        }
        assert (LambdaForm.isValidSignature(sig));
        prep = new LambdaForm(sig);
        prep.vmentry = InvokerBytecodeGenerator.generateLambdaFormInterpreterEntryPoint(sig);
        return mtype.form().setCachedLambdaForm(6, prep);
    }

    private static boolean argumentTypesMatch(String sig, Object[] av) {
        int arity = LambdaForm.signatureArity(sig);
        assert (av.length == arity) : "av.length == arity: av.length=" + av.length + ", arity=" + arity;
        assert (av[0] instanceof MethodHandle) : "av[0] not instace of MethodHandle: " + av[0];
        MethodHandle mh = (MethodHandle)av[0];
        MethodType mt = mh.type();
        assert (mt.parameterCount() == arity - 1);
        for (int i = 0; i < av.length; ++i) {
            Class<MethodHandle> pt;
            Class clazz = pt = i == 0 ? MethodHandle.class : mt.parameterType(i - 1);
            assert (LambdaForm.valueMatches(BasicType.basicType(sig.charAt(i)), pt, av[i]));
        }
        return true;
    }

    private static boolean valueMatches(BasicType tc, Class<?> type, Object x) {
        if (type == Void.TYPE) {
            tc = BasicType.V_TYPE;
        }
        assert (tc == BasicType.basicType(type)) : (Object)((Object)tc) + " == basicType(" + type + ")=" + (Object)((Object)BasicType.basicType(type));
        switch (tc) {
            case I_TYPE: {
                assert (LambdaForm.checkInt(type, x)) : "checkInt(" + type + "," + x + ")";
                break;
            }
            case J_TYPE: {
                assert (x instanceof Long) : "instanceof Long: " + x;
                break;
            }
            case F_TYPE: {
                assert (x instanceof Float) : "instanceof Float: " + x;
                break;
            }
            case D_TYPE: {
                assert (x instanceof Double) : "instanceof Double: " + x;
                break;
            }
            case L_TYPE: {
                assert (LambdaForm.checkRef(type, x)) : "checkRef(" + type + "," + x + ")";
                break;
            }
            case V_TYPE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private static boolean returnTypesMatch(String sig, Object[] av, Object res) {
        MethodHandle mh = (MethodHandle)av[0];
        return LambdaForm.valueMatches(LambdaForm.signatureReturn(sig), mh.type().returnType(), res);
    }

    private static boolean checkInt(Class<?> type, Object x) {
        assert (x instanceof Integer);
        if (type == Integer.TYPE) {
            return true;
        }
        Wrapper w = Wrapper.forBasicType(type);
        assert (w.isSubwordOrInt());
        Object x1 = Wrapper.INT.wrap(w.wrap(x));
        return x.equals(x1);
    }

    private static boolean checkRef(Class<?> type, Object x) {
        assert (!type.isPrimitive());
        if (x == null) {
            return true;
        }
        if (type.isInterface()) {
            return true;
        }
        return type.isInstance(x);
    }

    @Hidden
    @DontInline
    Object interpretWithArguments(Object ... argumentValues) throws Throwable {
        Object rv;
        if (TRACE_INTERPRETER) {
            return this.interpretWithArgumentsTracing(argumentValues);
        }
        this.checkInvocationCounter();
        assert (this.arityCheck(argumentValues));
        Object[] values = Arrays.copyOf(argumentValues, this.names.length);
        for (int i = argumentValues.length; i < values.length; ++i) {
            values[i] = this.interpretName(this.names[i], values);
        }
        Object object = rv = this.result < 0 ? null : values[this.result];
        assert (this.resultCheck(argumentValues, rv));
        return rv;
    }

    @Hidden
    @DontInline
    Object interpretName(Name name, Object[] values) throws Throwable {
        if (TRACE_INTERPRETER) {
            LambdaForm.traceInterpreter("| interpretName", name.debugString(), null);
        }
        Object[] arguments = Arrays.copyOf(name.arguments, name.arguments.length, Object[].class);
        for (int i = 0; i < arguments.length; ++i) {
            Object a = arguments[i];
            if (!(a instanceof Name)) continue;
            int i2 = ((Name)a).index();
            assert (this.names[i2] == a);
            a = values[i2];
            arguments[i] = a;
        }
        return name.function.invokeWithArguments(arguments);
    }

    private void checkInvocationCounter() {
        if (COMPILE_THRESHOLD != 0 && this.invocationCounter < COMPILE_THRESHOLD) {
            ++this.invocationCounter;
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
    }

    Object interpretWithArgumentsTracing(Object ... argumentValues) throws Throwable {
        Object rval;
        LambdaForm.traceInterpreter("[ interpretWithArguments", this, argumentValues);
        if (this.invocationCounter < COMPILE_THRESHOLD) {
            int ctr = this.invocationCounter++;
            LambdaForm.traceInterpreter("| invocationCounter", ctr);
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
        try {
            assert (this.arityCheck(argumentValues));
            Object[] values = Arrays.copyOf(argumentValues, this.names.length);
            for (int i = argumentValues.length; i < values.length; ++i) {
                values[i] = this.interpretName(this.names[i], values);
            }
            rval = this.result < 0 ? null : values[this.result];
        }
        catch (Throwable ex) {
            LambdaForm.traceInterpreter("] throw =>", ex);
            throw ex;
        }
        LambdaForm.traceInterpreter("] return =>", rval);
        return rval;
    }

    static void traceInterpreter(String event, Object obj, Object ... args) {
        if (TRACE_INTERPRETER) {
            System.out.println("LFI: " + event + " " + (obj != null ? obj : "") + (args != null && args.length != 0 ? Arrays.asList(args) : ""));
        }
    }

    static void traceInterpreter(String event, Object obj) {
        LambdaForm.traceInterpreter(event, obj, null);
    }

    private boolean arityCheck(Object[] argumentValues) {
        assert (argumentValues.length == this.arity) : this.arity + "!=" + Arrays.asList(argumentValues) + ".length";
        assert (argumentValues[0] instanceof MethodHandle) : "not MH: " + argumentValues[0];
        MethodHandle mh = (MethodHandle)argumentValues[0];
        assert (mh.internalForm() == this);
        LambdaForm.argumentTypesMatch(this.basicTypeSignature(), argumentValues);
        return true;
    }

    private boolean resultCheck(Object[] argumentValues, Object result) {
        MethodHandle mh = (MethodHandle)argumentValues[0];
        MethodType mt = mh.type();
        assert (LambdaForm.valueMatches(this.returnType(), mt.returnType(), result));
        return true;
    }

    private boolean isEmpty() {
        if (this.result < 0) {
            return this.names.length == this.arity;
        }
        if (this.result == this.arity && this.names.length == this.arity + 1) {
            return this.names[this.arity].isConstantZero();
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.debugName + "=Lambda(");
        for (int i = 0; i < this.names.length; ++i) {
            if (i == this.arity) {
                buf.append(")=>{");
            }
            Name n = this.names[i];
            if (i >= this.arity) {
                buf.append("\n    ");
            }
            buf.append(n.paramString());
            if (i < this.arity) {
                if (i + 1 >= this.arity) continue;
                buf.append(",");
                continue;
            }
            buf.append("=").append(n.exprString());
            buf.append(";");
        }
        if (this.arity == this.names.length) {
            buf.append(")=>{");
        }
        buf.append(this.result < 0 ? "void" : this.names[this.result]).append("}");
        if (TRACE_INTERPRETER) {
            buf.append(":").append(this.basicTypeSignature());
            buf.append("/").append(this.vmentry);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof LambdaForm && this.equals((LambdaForm)obj);
    }

    public boolean equals(LambdaForm that) {
        if (this.result != that.result) {
            return false;
        }
        return Arrays.equals(this.names, that.names);
    }

    public int hashCode() {
        return this.result + 31 * Arrays.hashCode(this.names);
    }

    LambdaFormEditor editor() {
        return LambdaFormEditor.lambdaFormEditor(this);
    }

    boolean contains(Name name) {
        int pos = name.index();
        if (pos >= 0) {
            return pos < this.names.length && name.equals(this.names[pos]);
        }
        for (int i = this.arity; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return true;
        }
        return false;
    }

    LambdaForm addArguments(int pos, BasicType ... types) {
        int argpos = pos + 1;
        assert (argpos <= this.arity);
        int length = this.names.length;
        int inTypes = types.length;
        Name[] names2 = Arrays.copyOf(this.names, length + inTypes);
        int arity2 = this.arity + inTypes;
        int result2 = this.result;
        if (result2 >= argpos) {
            result2 += inTypes;
        }
        System.arraycopy(this.names, argpos, names2, argpos + inTypes, length - argpos);
        for (int i = 0; i < inTypes; ++i) {
            names2[argpos + i] = new Name(types[i]);
        }
        return new LambdaForm(this.debugName, arity2, names2, result2);
    }

    LambdaForm addArguments(int pos, List<Class<?>> types) {
        return this.addArguments(pos, BasicType.basicTypes(types));
    }

    LambdaForm permuteArguments(int skip, int[] reorder, BasicType[] types) {
        int k;
        Name n2;
        int j;
        int pos;
        int length = this.names.length;
        int inTypes = types.length;
        int outArgs = reorder.length;
        assert (skip + outArgs == this.arity);
        assert (LambdaForm.permutedTypesMatch(reorder, types, this.names, skip));
        for (pos = 0; pos < outArgs && reorder[pos] == pos; ++pos) {
        }
        Name[] names2 = new Name[length - outArgs + inTypes];
        System.arraycopy(this.names, 0, names2, 0, skip + pos);
        int bodyLength = length - this.arity;
        System.arraycopy(this.names, skip + outArgs, names2, skip + inTypes, bodyLength);
        int arity2 = names2.length - bodyLength;
        int result2 = this.result;
        if (result2 >= 0) {
            result2 = result2 < skip + outArgs ? reorder[result2 - skip] : result2 - outArgs + inTypes;
        }
        for (j = pos; j < outArgs; ++j) {
            Name n = this.names[skip + j];
            int i = reorder[j];
            n2 = names2[skip + i];
            if (n2 == null) {
                names2[skip + i] = n2 = new Name(types[i]);
            } else assert (n2.type == types[i]);
            for (k = arity2; k < names2.length; ++k) {
                names2[k] = names2[k].replaceName(n, n2);
            }
        }
        for (int i = skip + pos; i < arity2; ++i) {
            if (names2[i] != null) continue;
            names2[i] = LambdaForm.argument(i, types[i - skip]);
        }
        for (j = this.arity; j < this.names.length; ++j) {
            Name n = this.names[j];
            int i = j - this.arity + arity2;
            n2 = names2[i];
            if (n == n2) continue;
            for (k = i + 1; k < names2.length; ++k) {
                names2[k] = names2[k].replaceName(n, n2);
            }
        }
        return new LambdaForm(this.debugName, arity2, names2, result2);
    }

    static boolean permutedTypesMatch(int[] reorder, BasicType[] types, Name[] names, int skip) {
        int inTypes = types.length;
        int outArgs = reorder.length;
        for (int i = 0; i < outArgs; ++i) {
            assert (names[skip + i].isParam());
            assert (names[skip + i].type == types[reorder[i]]);
        }
        return true;
    }

    public static String basicTypeSignature(MethodType type) {
        char[] sig = new char[type.parameterCount() + 2];
        int sigp = 0;
        for (Class<?> pt : type.parameterList()) {
            sig[sigp++] = BasicType.basicTypeChar(pt);
        }
        sig[sigp++] = 95;
        sig[sigp++] = BasicType.basicTypeChar(type.returnType());
        assert (sigp == sig.length);
        return String.valueOf(sig);
    }

    public static String shortenSignature(String signature) {
        int NO_CHAR = -1;
        int MIN_RUN = 3;
        int c1 = -1;
        int c1reps = 0;
        StringBuilder buf = null;
        int len = signature.length();
        if (len < 3) {
            return signature;
        }
        for (int i = 0; i <= len; ++i) {
            int c0 = c1;
            int n = c1 = i == len ? -1 : (int)signature.charAt(i);
            if (c1 == c0) {
                ++c1reps;
                continue;
            }
            int c0reps = c1reps;
            c1reps = 1;
            if (c0reps < 3) {
                if (buf == null) continue;
                while (--c0reps >= 0) {
                    buf.append((char)c0);
                }
                continue;
            }
            if (buf == null) {
                buf = new StringBuilder().append(signature, 0, i - c0reps);
            }
            buf.append((char)c0).append(c0reps);
        }
        return buf == null ? signature : buf.toString();
    }

    int lastUseIndex(Name n) {
        short ni = n.index;
        int nmax = this.names.length;
        assert (this.names[ni] == n);
        if (this.result == ni) {
            return nmax;
        }
        int i = nmax;
        while (--i > ni) {
            if (this.names[i].lastUseIndex(n) < 0) continue;
            return i;
        }
        return -1;
    }

    int useCount(Name n) {
        int beg;
        short ni = n.index;
        int nmax = this.names.length;
        int end = this.lastUseIndex(n);
        if (end < 0) {
            return 0;
        }
        int count = 0;
        if (end == nmax) {
            ++count;
            --end;
        }
        if ((beg = n.index() + 1) < this.arity) {
            beg = this.arity;
        }
        for (int i = beg; i <= end; ++i) {
            count += this.names[i].useCount(n);
        }
        return count;
    }

    static Name argument(int which, char type) {
        return LambdaForm.argument(which, BasicType.basicType(type));
    }

    static Name argument(int which, BasicType type) {
        if (which >= 10) {
            return new Name(which, type);
        }
        return INTERNED_ARGUMENTS[type.ordinal()][which];
    }

    static Name internArgument(Name n) {
        assert (n.isParam()) : "not param: " + n;
        assert (n.index < 10);
        if (n.constraint != null) {
            return n;
        }
        return LambdaForm.argument((int)n.index, n.type);
    }

    static Name[] arguments(int extra, String types) {
        int length = types.length();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, types.charAt(i));
        }
        return names;
    }

    static Name[] arguments(int extra, char ... types) {
        int length = types.length;
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, types[i]);
        }
        return names;
    }

    static Name[] arguments(int extra, List<Class<?>> types) {
        int length = types.size();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, BasicType.basicType(types.get(i)));
        }
        return names;
    }

    static Name[] arguments(int extra, Class<?> ... types) {
        int length = types.length;
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, BasicType.basicType(types[i]));
        }
        return names;
    }

    static Name[] arguments(int extra, MethodType types) {
        int length = types.parameterCount();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, BasicType.basicType(types.parameterType(i)));
        }
        return names;
    }

    static LambdaForm identityForm(BasicType type) {
        return LF_identityForm[type.ordinal()];
    }

    static LambdaForm zeroForm(BasicType type) {
        return LF_zeroForm[type.ordinal()];
    }

    static NamedFunction identity(BasicType type) {
        return NF_identity[type.ordinal()];
    }

    static NamedFunction constantZero(BasicType type) {
        return NF_zero[type.ordinal()];
    }

    private static void createIdentityForms() {
        int ord;
        for (BasicType type : BasicType.ALL_TYPES) {
            LambdaForm zeForm;
            LambdaForm idForm;
            Name[] idNames;
            ord = type.ordinal();
            char btChar = type.basicTypeChar();
            boolean isVoid = type == BasicType.V_TYPE;
            Class btClass = type.btClass;
            MethodType zeType = MethodType.methodType(btClass);
            MethodType idType = isVoid ? zeType : zeType.appendParameterTypes(btClass);
            MemberName idMem = new MemberName(LambdaForm.class, "identity_" + btChar, idType, 6);
            MemberName zeMem = new MemberName(LambdaForm.class, "zero_" + btChar, zeType, 6);
            try {
                zeMem = IMPL_NAMES.resolveOrFail((byte)6, zeMem, null, NoSuchMethodException.class);
                idMem = IMPL_NAMES.resolveOrFail((byte)6, idMem, null, NoSuchMethodException.class);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            NamedFunction idFun = new NamedFunction(idMem);
            if (isVoid) {
                idNames = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE)};
                idForm = new LambdaForm(idMem.getName(), 1, idNames, -1);
            } else {
                idNames = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE), LambdaForm.argument(1, type)};
                idForm = new LambdaForm(idMem.getName(), 2, idNames, 1);
            }
            LambdaForm.LF_identityForm[ord] = idForm;
            LambdaForm.NF_identity[ord] = idFun;
            NamedFunction zeFun = new NamedFunction(zeMem);
            if (isVoid) {
                zeForm = idForm;
            } else {
                Object zeValue = Wrapper.forBasicType(btChar).zero();
                Name[] zeNames = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE), new Name(idFun, zeValue)};
                zeForm = new LambdaForm(zeMem.getName(), 1, zeNames, 1);
            }
            LambdaForm.LF_zeroForm[ord] = zeForm;
            LambdaForm.NF_zero[ord] = zeFun;
            assert (idFun.isIdentity());
            assert (zeFun.isConstantZero());
            assert (new Name(zeFun, new Object[0]).isConstantZero());
        }
        for (BasicType type : BasicType.ALL_TYPES) {
            ord = type.ordinal();
            NamedFunction idFun = NF_identity[ord];
            LambdaForm idForm = LF_identityForm[ord];
            MemberName idMem = idFun.member;
            idFun.resolvedHandle = SimpleMethodHandle.make(idMem.getInvocationType(), idForm);
            NamedFunction zeFun = NF_zero[ord];
            LambdaForm zeForm = LF_zeroForm[ord];
            MemberName zeMem = zeFun.member;
            zeFun.resolvedHandle = SimpleMethodHandle.make(zeMem.getInvocationType(), zeForm);
            assert (idFun.isIdentity());
            assert (zeFun.isConstantZero());
            assert (new Name(zeFun, new Object[0]).isConstantZero());
        }
    }

    private static int identity_I(int x) {
        return x;
    }

    private static long identity_J(long x) {
        return x;
    }

    private static float identity_F(float x) {
        return x;
    }

    private static double identity_D(double x) {
        return x;
    }

    private static Object identity_L(Object x) {
        return x;
    }

    private static void identity_V() {
    }

    private static int zero_I() {
        return 0;
    }

    private static long zero_J() {
        return 0L;
    }

    private static float zero_F() {
        return 0.0f;
    }

    private static double zero_D() {
        return 0.0;
    }

    private static Object zero_L() {
        return null;
    }

    private static void zero_V() {
    }

    static {
        for (BasicType type : BasicType.ARG_TYPES) {
            int ord = type.ordinal();
            for (int i = 0; i < INTERNED_ARGUMENTS[ord].length; ++i) {
                LambdaForm.INTERNED_ARGUMENTS[ord][i] = new Name(i, type);
            }
        }
        IMPL_NAMES = MemberName.getFactory();
        LF_identityForm = new LambdaForm[BasicType.TYPE_LIMIT];
        LF_zeroForm = new LambdaForm[BasicType.TYPE_LIMIT];
        NF_identity = new NamedFunction[BasicType.TYPE_LIMIT];
        NF_zero = new NamedFunction[BasicType.TYPE_LIMIT];
        DEBUG_NAME_COUNTERS = MethodHandleStatics.debugEnabled() ? new HashMap() : null;
        LambdaForm.createIdentityForms();
        LambdaForm.computeInitialPreparedForms();
        NamedFunction.initializeInvokers();
        TRACE_INTERPRETER = MethodHandleStatics.TRACE_INTERPRETER;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Hidden {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Compiled {
    }

    static final class Name {
        final BasicType type;
        private short index;
        final NamedFunction function;
        final Object constraint;
        @Stable
        final Object[] arguments;

        private Name(int index, BasicType type, NamedFunction function, Object[] arguments) {
            this.index = (short)index;
            this.type = type;
            this.function = function;
            this.arguments = arguments;
            this.constraint = null;
            assert (this.index == index);
        }

        private Name(Name that, Object constraint) {
            this.index = that.index;
            this.type = that.type;
            this.function = that.function;
            this.arguments = that.arguments;
            this.constraint = constraint;
            assert (constraint == null || this.isParam());
            assert (constraint == null || constraint instanceof BoundMethodHandle.SpeciesData || constraint instanceof Class);
        }

        Name(MethodHandle function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(MethodType functionType, Object ... arguments) {
            this(new NamedFunction(functionType), arguments);
            assert (arguments[0] instanceof Name && ((Name)arguments[0]).type == BasicType.L_TYPE);
        }

        Name(MemberName function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(NamedFunction function, Object ... arguments) {
            arguments = Arrays.copyOf(arguments, arguments.length, Object[].class);
            this(-1, function.returnType(), function, arguments);
            assert (arguments.length == function.arity()) : "arity mismatch: arguments.length=" + arguments.length + " == function.arity()=" + function.arity() + " in " + this.debugString();
            for (int i = 0; i < arguments.length; ++i) {
                assert (Name.typesMatch(function.parameterType(i), arguments[i])) : "types don't match: function.parameterType(" + i + ")=" + (Object)((Object)function.parameterType(i)) + ", arguments[" + i + "]=" + arguments[i] + " in " + this.debugString();
            }
        }

        Name(int index, BasicType type) {
            this(index, type, null, null);
        }

        Name(BasicType type) {
            this(-1, type);
        }

        BasicType type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        boolean initIndex(int i) {
            if (this.index != i) {
                if (this.index != -1) {
                    return false;
                }
                this.index = (short)i;
            }
            return true;
        }

        char typeChar() {
            return this.type.btChar;
        }

        void resolve() {
            if (this.function != null) {
                this.function.resolve();
            }
        }

        Name newIndex(int i) {
            if (this.initIndex(i)) {
                return this;
            }
            return this.cloneWithIndex(i);
        }

        Name cloneWithIndex(int i) {
            Object[] newArguments = this.arguments == null ? null : (Object[])this.arguments.clone();
            return new Name(i, this.type, this.function, newArguments).withConstraint(this.constraint);
        }

        Name withConstraint(Object constraint) {
            if (constraint == this.constraint) {
                return this;
            }
            return new Name(this, constraint);
        }

        Name replaceName(Name oldName, Name newName) {
            if (oldName == newName) {
                return this;
            }
            Object[] arguments = this.arguments;
            if (arguments == null) {
                return this;
            }
            boolean replaced = false;
            for (int j = 0; j < arguments.length; ++j) {
                if (arguments[j] != oldName) continue;
                if (!replaced) {
                    replaced = true;
                    arguments = (Object[])arguments.clone();
                }
                arguments[j] = newName;
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        Name replaceNames(Name[] oldNames, Name[] newNames, int start, int end) {
            if (start >= end) {
                return this;
            }
            Object[] arguments = this.arguments;
            boolean replaced = false;
            block0: for (int j = 0; j < arguments.length; ++j) {
                if (!(arguments[j] instanceof Name)) continue;
                Name n = (Name)arguments[j];
                short check = n.index;
                if (check >= 0 && check < newNames.length && n == newNames[check]) continue;
                for (int i = start; i < end; ++i) {
                    if (n != oldNames[i]) continue;
                    if (n == newNames[i]) continue block0;
                    if (!replaced) {
                        replaced = true;
                        arguments = (Object[])arguments.clone();
                    }
                    arguments[j] = newNames[i];
                    continue block0;
                }
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        void internArguments() {
            Object[] arguments = this.arguments;
            for (int j = 0; j < arguments.length; ++j) {
                Name n;
                if (!(arguments[j] instanceof Name) || !(n = (Name)arguments[j]).isParam() || n.index >= 10) continue;
                arguments[j] = LambdaForm.internArgument(n);
            }
        }

        boolean isParam() {
            return this.function == null;
        }

        boolean isConstantZero() {
            return !this.isParam() && this.arguments.length == 0 && this.function.isConstantZero();
        }

        public String toString() {
            return (this.isParam() ? "a" : "t") + (this.index >= 0 ? this.index : System.identityHashCode(this)) + ":" + this.typeChar();
        }

        public String debugString() {
            String s = this.paramString();
            return this.function == null ? s : s + "=" + this.exprString();
        }

        public String paramString() {
            String s = this.toString();
            Object c = this.constraint;
            if (c == null) {
                return s;
            }
            if (c instanceof Class) {
                c = ((Class)c).getSimpleName();
            }
            return s + "/" + c;
        }

        public String exprString() {
            if (this.function == null) {
                return this.toString();
            }
            StringBuilder buf = new StringBuilder(this.function.toString());
            buf.append("(");
            String cma = "";
            for (Object a : this.arguments) {
                buf.append(cma);
                cma = ",";
                if (a instanceof Name || a instanceof Integer) {
                    buf.append(a);
                    continue;
                }
                buf.append("(").append(a).append(")");
            }
            buf.append(")");
            return buf.toString();
        }

        static boolean typesMatch(BasicType parameterType, Object object) {
            if (object instanceof Name) {
                return ((Name)object).type == parameterType;
            }
            switch (parameterType) {
                case I_TYPE: {
                    return object instanceof Integer;
                }
                case J_TYPE: {
                    return object instanceof Long;
                }
                case F_TYPE: {
                    return object instanceof Float;
                }
                case D_TYPE: {
                    return object instanceof Double;
                }
            }
            assert (parameterType == BasicType.L_TYPE);
            return true;
        }

        int lastUseIndex(Name n) {
            if (this.arguments == null) {
                return -1;
            }
            int i = this.arguments.length;
            while (--i >= 0) {
                if (this.arguments[i] != n) continue;
                return i;
            }
            return -1;
        }

        int useCount(Name n) {
            if (this.arguments == null) {
                return 0;
            }
            int count = 0;
            int i = this.arguments.length;
            while (--i >= 0) {
                if (this.arguments[i] != n) continue;
                ++count;
            }
            return count;
        }

        boolean contains(Name n) {
            return this == n || this.lastUseIndex(n) >= 0;
        }

        public boolean equals(Name that) {
            if (this == that) {
                return true;
            }
            if (this.isParam()) {
                return false;
            }
            return this.type == that.type && this.function.equals(that.function) && Arrays.equals(this.arguments, that.arguments);
        }

        public boolean equals(Object x) {
            return x instanceof Name && this.equals((Name)x);
        }

        public int hashCode() {
            if (this.isParam()) {
                return this.index | this.type.ordinal() << 8;
            }
            return this.function.hashCode() ^ Arrays.hashCode(this.arguments);
        }
    }

    static class NamedFunction {
        final MemberName member;
        @Stable
        MethodHandle resolvedHandle;
        @Stable
        MethodHandle invoker;
        static final MethodType INVOKER_METHOD_TYPE = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);

        NamedFunction(MethodHandle resolvedHandle) {
            this(resolvedHandle.internalMemberName(), resolvedHandle);
        }

        NamedFunction(MemberName member, MethodHandle resolvedHandle) {
            this.member = member;
            this.resolvedHandle = resolvedHandle;
        }

        NamedFunction(MethodType basicInvokerType) {
            assert (basicInvokerType == basicInvokerType.basicType()) : basicInvokerType;
            if (basicInvokerType.parameterSlotCount() < 253) {
                this.resolvedHandle = basicInvokerType.invokers().basicInvoker();
                this.member = this.resolvedHandle.internalMemberName();
            } else {
                this.member = Invokers.invokeBasicMethod(basicInvokerType);
            }
            assert (NamedFunction.isInvokeBasic(this.member));
        }

        private static boolean isInvokeBasic(MemberName member) {
            return member != null && member.getDeclaringClass() == MethodHandle.class && "invokeBasic".equals(member.getName());
        }

        NamedFunction(Method method) {
            this(new MemberName(method));
        }

        NamedFunction(Field field) {
            this(new MemberName(field));
        }

        NamedFunction(MemberName member) {
            this.member = member;
            this.resolvedHandle = null;
        }

        MethodHandle resolvedHandle() {
            if (this.resolvedHandle == null) {
                this.resolve();
            }
            return this.resolvedHandle;
        }

        void resolve() {
            this.resolvedHandle = DirectMethodHandle.make(this.member);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof NamedFunction)) {
                return false;
            }
            NamedFunction that = (NamedFunction)other;
            return this.member != null && this.member.equals(that.member);
        }

        public int hashCode() {
            if (this.member != null) {
                return this.member.hashCode();
            }
            return super.hashCode();
        }

        static void initializeInvokers() {
            for (MemberName m : MemberName.getFactory().getMethods(NamedFunction.class, false, null, null, null)) {
                MethodType type;
                if (!m.isStatic() || !m.isPackage() || !(type = m.getMethodType()).equals((Object)INVOKER_METHOD_TYPE) || !m.getName().startsWith("invoke_")) continue;
                String sig = m.getName().substring("invoke_".length());
                int arity = LambdaForm.signatureArity(sig);
                MethodType srcType = MethodType.genericMethodType(arity);
                if (LambdaForm.signatureReturn(sig) == BasicType.V_TYPE) {
                    srcType = srcType.changeReturnType(Void.TYPE);
                }
                MethodTypeForm typeForm = srcType.form();
                typeForm.setCachedMethodHandle(1, DirectMethodHandle.make(m));
            }
        }

        @Hidden
        static Object invoke__V(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(0, Void.TYPE, mh, a));
            mh.invokeBasic();
            return null;
        }

        @Hidden
        static Object invoke_L_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(1, Void.TYPE, mh, a));
            mh.invokeBasic(a[0]);
            return null;
        }

        @Hidden
        static Object invoke_LL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(2, Void.TYPE, mh, a));
            mh.invokeBasic(a[0], a[1]);
            return null;
        }

        @Hidden
        static Object invoke_LLL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(3, Void.TYPE, mh, a));
            mh.invokeBasic(a[0], a[1], a[2]);
            return null;
        }

        @Hidden
        static Object invoke_LLLL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(4, Void.TYPE, mh, a));
            mh.invokeBasic(a[0], a[1], a[2], a[3]);
            return null;
        }

        @Hidden
        static Object invoke_LLLLL_V(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(5, Void.TYPE, mh, a));
            mh.invokeBasic(a[0], a[1], a[2], a[3], a[4]);
            return null;
        }

        @Hidden
        static Object invoke__L(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(0, mh, a));
            return mh.invokeBasic();
        }

        @Hidden
        static Object invoke_L_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(1, mh, a));
            return mh.invokeBasic(a[0]);
        }

        @Hidden
        static Object invoke_LL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(2, mh, a));
            return mh.invokeBasic(a[0], a[1]);
        }

        @Hidden
        static Object invoke_LLL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(3, mh, a));
            return mh.invokeBasic(a[0], a[1], a[2]);
        }

        @Hidden
        static Object invoke_LLLL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(4, mh, a));
            return mh.invokeBasic(a[0], a[1], a[2], a[3]);
        }

        @Hidden
        static Object invoke_LLLLL_L(MethodHandle mh, Object[] a) throws Throwable {
            assert (NamedFunction.arityCheck(5, mh, a));
            return mh.invokeBasic(a[0], a[1], a[2], a[3], a[4]);
        }

        private static boolean arityCheck(int arity, MethodHandle mh, Object[] a) {
            return NamedFunction.arityCheck(arity, Object.class, mh, a);
        }

        private static boolean arityCheck(int arity, Class<?> rtype, MethodHandle mh, Object[] a) {
            assert (a.length == arity) : Arrays.asList(a.length, arity);
            assert (mh.type().basicType() == MethodType.genericMethodType(arity).changeReturnType(rtype)) : Arrays.asList(mh, rtype, arity);
            MemberName member = mh.internalMemberName();
            if (NamedFunction.isInvokeBasic(member)) {
                assert (arity > 0);
                assert (a[0] instanceof MethodHandle);
                MethodHandle mh2 = (MethodHandle)a[0];
                assert (mh2.type().basicType() == MethodType.genericMethodType(arity - 1).changeReturnType(rtype)) : Arrays.asList(member, mh2, rtype, arity);
            }
            return true;
        }

        private static MethodHandle computeInvoker(MethodTypeForm typeForm) {
            MethodHandle mh = (typeForm = typeForm.basicType().form()).cachedMethodHandle(1);
            if (mh != null) {
                return mh;
            }
            MemberName invoker = InvokerBytecodeGenerator.generateNamedFunctionInvoker(typeForm);
            mh = DirectMethodHandle.make(invoker);
            MethodHandle mh2 = typeForm.cachedMethodHandle(1);
            if (mh2 != null) {
                return mh2;
            }
            if (!mh.type().equals((Object)INVOKER_METHOD_TYPE)) {
                throw MethodHandleStatics.newInternalError(mh.debugString());
            }
            return typeForm.setCachedMethodHandle(1, mh);
        }

        @Hidden
        Object invokeWithArguments(Object ... arguments) throws Throwable {
            if (TRACE_INTERPRETER) {
                return this.invokeWithArgumentsTracing(arguments);
            }
            assert (NamedFunction.checkArgumentTypes(arguments, this.methodType()));
            return this.invoker().invokeBasic(this.resolvedHandle(), arguments);
        }

        @Hidden
        Object invokeWithArgumentsTracing(Object[] arguments) throws Throwable {
            Object rval;
            try {
                LambdaForm.traceInterpreter("[ call", this, arguments);
                if (this.invoker == null) {
                    LambdaForm.traceInterpreter("| getInvoker", this);
                    this.invoker();
                }
                if (this.resolvedHandle == null) {
                    LambdaForm.traceInterpreter("| resolve", this);
                    this.resolvedHandle();
                }
                assert (NamedFunction.checkArgumentTypes(arguments, this.methodType()));
                rval = this.invoker().invokeBasic(this.resolvedHandle(), arguments);
            }
            catch (Throwable ex) {
                LambdaForm.traceInterpreter("] throw =>", ex);
                throw ex;
            }
            LambdaForm.traceInterpreter("] return =>", rval);
            return rval;
        }

        private MethodHandle invoker() {
            if (this.invoker != null) {
                return this.invoker;
            }
            this.invoker = NamedFunction.computeInvoker(this.methodType().form());
            return this.invoker;
        }

        private static boolean checkArgumentTypes(Object[] arguments, MethodType methodType) {
            return true;
        }

        MethodType methodType() {
            if (this.resolvedHandle != null) {
                return this.resolvedHandle.type();
            }
            return this.member.getInvocationType();
        }

        MemberName member() {
            assert (this.assertMemberIsConsistent());
            return this.member;
        }

        private boolean assertMemberIsConsistent() {
            if (this.resolvedHandle instanceof DirectMethodHandle) {
                MemberName m = this.resolvedHandle.internalMemberName();
                assert (m.equals(this.member));
            }
            return true;
        }

        Class<?> memberDeclaringClassOrNull() {
            return this.member == null ? null : this.member.getDeclaringClass();
        }

        BasicType returnType() {
            return BasicType.basicType(this.methodType().returnType());
        }

        BasicType parameterType(int n) {
            return BasicType.basicType(this.methodType().parameterType(n));
        }

        int arity() {
            return this.methodType().parameterCount();
        }

        public String toString() {
            if (this.member == null) {
                return String.valueOf(this.resolvedHandle);
            }
            return this.member.getDeclaringClass().getSimpleName() + "." + this.member.getName();
        }

        public boolean isIdentity() {
            return this.equals(LambdaForm.identity(this.returnType()));
        }

        public boolean isConstantZero() {
            return this.equals(LambdaForm.constantZero(this.returnType()));
        }

        public MethodHandleImpl.Intrinsic intrinsicName() {
            return this.resolvedHandle == null ? MethodHandleImpl.Intrinsic.NONE : this.resolvedHandle.intrinsicName();
        }
    }

    static final class BasicType
    extends Enum<BasicType> {
        public static final /* enum */ BasicType L_TYPE = new BasicType('L', Object.class, Wrapper.OBJECT);
        public static final /* enum */ BasicType I_TYPE = new BasicType('I', Integer.TYPE, Wrapper.INT);
        public static final /* enum */ BasicType J_TYPE = new BasicType('J', Long.TYPE, Wrapper.LONG);
        public static final /* enum */ BasicType F_TYPE = new BasicType('F', Float.TYPE, Wrapper.FLOAT);
        public static final /* enum */ BasicType D_TYPE = new BasicType('D', Double.TYPE, Wrapper.DOUBLE);
        public static final /* enum */ BasicType V_TYPE = new BasicType('V', Void.TYPE, Wrapper.VOID);
        static final BasicType[] ALL_TYPES;
        static final BasicType[] ARG_TYPES;
        static final int ARG_TYPE_LIMIT;
        static final int TYPE_LIMIT;
        private final char btChar;
        private final Class<?> btClass;
        private final Wrapper btWrapper;
        private static final /* synthetic */ BasicType[] $VALUES;

        public static BasicType[] values() {
            return (BasicType[])$VALUES.clone();
        }

        public static BasicType valueOf(String name) {
            return Enum.valueOf(BasicType.class, name);
        }

        private BasicType(char btChar, Class<?> btClass, Wrapper wrapper) {
            this.btChar = btChar;
            this.btClass = btClass;
            this.btWrapper = wrapper;
        }

        char basicTypeChar() {
            return this.btChar;
        }

        Class<?> basicTypeClass() {
            return this.btClass;
        }

        Wrapper basicTypeWrapper() {
            return this.btWrapper;
        }

        int basicTypeSlots() {
            return this.btWrapper.stackSlots();
        }

        static BasicType basicType(byte type) {
            return ALL_TYPES[type];
        }

        static BasicType basicType(char type) {
            switch (type) {
                case 'L': {
                    return L_TYPE;
                }
                case 'I': {
                    return I_TYPE;
                }
                case 'J': {
                    return J_TYPE;
                }
                case 'F': {
                    return F_TYPE;
                }
                case 'D': {
                    return D_TYPE;
                }
                case 'V': {
                    return V_TYPE;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    return I_TYPE;
                }
            }
            throw MethodHandleStatics.newInternalError("Unknown type char: '" + type + "'");
        }

        static BasicType basicType(Wrapper type) {
            char c = type.basicTypeChar();
            return BasicType.basicType(c);
        }

        static BasicType basicType(Class<?> type) {
            if (!type.isPrimitive()) {
                return L_TYPE;
            }
            return BasicType.basicType(Wrapper.forPrimitiveType(type));
        }

        static char basicTypeChar(Class<?> type) {
            return BasicType.basicType(type).btChar;
        }

        static BasicType[] basicTypes(List<Class<?>> types) {
            BasicType[] btypes = new BasicType[types.size()];
            for (int i = 0; i < btypes.length; ++i) {
                btypes[i] = BasicType.basicType(types.get(i));
            }
            return btypes;
        }

        static BasicType[] basicTypes(String types) {
            BasicType[] btypes = new BasicType[types.length()];
            for (int i = 0; i < btypes.length; ++i) {
                btypes[i] = BasicType.basicType(types.charAt(i));
            }
            return btypes;
        }

        static byte[] basicTypesOrd(BasicType[] btypes) {
            byte[] ords = new byte[btypes.length];
            for (int i = 0; i < btypes.length; ++i) {
                ords[i] = (byte)btypes[i].ordinal();
            }
            return ords;
        }

        static boolean isBasicTypeChar(char c) {
            return "LIJFDV".indexOf(c) >= 0;
        }

        static boolean isArgBasicTypeChar(char c) {
            return "LIJFD".indexOf(c) >= 0;
        }

        private static boolean checkBasicType() {
            int i;
            for (i = 0; i < ARG_TYPE_LIMIT; ++i) {
                assert (ARG_TYPES[i].ordinal() == i);
                assert (ARG_TYPES[i] == ALL_TYPES[i]);
            }
            for (i = 0; i < TYPE_LIMIT; ++i) {
                assert (ALL_TYPES[i].ordinal() == i);
            }
            assert (ALL_TYPES[TYPE_LIMIT - 1] == V_TYPE);
            assert (!Arrays.asList(ARG_TYPES).contains((Object)V_TYPE));
            return true;
        }

        static {
            $VALUES = new BasicType[]{L_TYPE, I_TYPE, J_TYPE, F_TYPE, D_TYPE, V_TYPE};
            ALL_TYPES = BasicType.values();
            ARG_TYPES = Arrays.copyOf(ALL_TYPES, ALL_TYPES.length - 1);
            ARG_TYPE_LIMIT = ARG_TYPES.length;
            TYPE_LIMIT = ALL_TYPES.length;
            assert (BasicType.checkBasicType());
        }
    }
}

