/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.LambdaFormEditor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.Stable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

abstract class BoundMethodHandle
extends MethodHandle {
    private static final int FIELD_COUNT_THRESHOLD = 12;
    private static final int FORM_EXPRESSION_THRESHOLD = 24;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.Lookup.IMPL_LOOKUP;
    static final SpeciesData SPECIES_DATA = SpeciesData.EMPTY;
    private static final SpeciesData[] SPECIES_DATA_CACHE = new SpeciesData[5];

    BoundMethodHandle(MethodType type, LambdaForm form) {
        super(type, form);
        assert (this.speciesData() == BoundMethodHandle.speciesData(form));
    }

    static BoundMethodHandle bindSingle(MethodType type, LambdaForm form, LambdaForm.BasicType xtype, Object x) {
        try {
            switch (xtype) {
                case L_TYPE: {
                    return BoundMethodHandle.bindSingle(type, form, x);
                }
                case I_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.I_TYPE).constructor().invokeBasic(type, form, ValueConversions.widenSubword(x));
                }
                case J_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.J_TYPE).constructor().invokeBasic(type, form, (Long)x);
                }
                case F_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.F_TYPE).constructor().invokeBasic(type, form, ((Float)x).floatValue());
                }
                case D_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.D_TYPE).constructor().invokeBasic(type, form, (Double)x);
                }
            }
            throw MethodHandleStatics.newInternalError("unexpected xtype: " + (Object)((Object)xtype));
        }
        catch (Throwable t) {
            throw MethodHandleStatics.newInternalError(t);
        }
    }

    LambdaFormEditor editor() {
        return this.form.editor();
    }

    static BoundMethodHandle bindSingle(MethodType type, LambdaForm form, Object x) {
        return Species_L.make(type, form, x);
    }

    @Override
    BoundMethodHandle bindArgumentL(int pos, Object value) {
        return this.editor().bindArgumentL(this, pos, value);
    }

    BoundMethodHandle bindArgumentI(int pos, int value) {
        return this.editor().bindArgumentI(this, pos, value);
    }

    BoundMethodHandle bindArgumentJ(int pos, long value) {
        return this.editor().bindArgumentJ(this, pos, value);
    }

    BoundMethodHandle bindArgumentF(int pos, float value) {
        return this.editor().bindArgumentF(this, pos, value);
    }

    BoundMethodHandle bindArgumentD(int pos, double value) {
        return this.editor().bindArgumentD(this, pos, value);
    }

    @Override
    BoundMethodHandle rebind() {
        if (!this.tooComplex()) {
            return this;
        }
        return BoundMethodHandle.makeReinvoker(this);
    }

    private boolean tooComplex() {
        return this.fieldCount() > 12 || this.form.expressionCount() > 24;
    }

    static BoundMethodHandle makeReinvoker(MethodHandle target) {
        LambdaForm form = DelegatingMethodHandle.makeReinvokerForm(target, 7, Species_L.SPECIES_DATA, Species_L.SPECIES_DATA.getterFunction(0));
        return Species_L.make(target.type(), form, target);
    }

    abstract SpeciesData speciesData();

    static SpeciesData speciesData(LambdaForm form) {
        Object c = form.names[0].constraint;
        if (c instanceof SpeciesData) {
            return (SpeciesData)c;
        }
        return SpeciesData.EMPTY;
    }

    abstract int fieldCount();

    @Override
    Object internalProperties() {
        return "\n& BMH=" + this.internalValues();
    }

    @Override
    final Object internalValues() {
        Object[] boundValues = new Object[this.speciesData().fieldCount()];
        for (int i = 0; i < boundValues.length; ++i) {
            boundValues[i] = this.arg(i);
        }
        return Arrays.asList(boundValues);
    }

    final Object arg(int i) {
        try {
            switch (this.speciesData().fieldType(i)) {
                case L_TYPE: {
                    return this.speciesData().getters[i].invokeBasic(this);
                }
                case I_TYPE: {
                    return this.speciesData().getters[i].invokeBasic(this);
                }
                case J_TYPE: {
                    return this.speciesData().getters[i].invokeBasic(this);
                }
                case F_TYPE: {
                    return Float.valueOf(this.speciesData().getters[i].invokeBasic(this));
                }
                case D_TYPE: {
                    return this.speciesData().getters[i].invokeBasic(this);
                }
            }
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        throw new InternalError("unexpected type: " + this.speciesData().typeChars + "." + i);
    }

    @Override
    abstract BoundMethodHandle copyWith(MethodType var1, LambdaForm var2);

    abstract BoundMethodHandle copyWithExtendL(MethodType var1, LambdaForm var2, Object var3);

    abstract BoundMethodHandle copyWithExtendI(MethodType var1, LambdaForm var2, int var3);

    abstract BoundMethodHandle copyWithExtendJ(MethodType var1, LambdaForm var2, long var3);

    abstract BoundMethodHandle copyWithExtendF(MethodType var1, LambdaForm var2, float var3);

    abstract BoundMethodHandle copyWithExtendD(MethodType var1, LambdaForm var2, double var3);

    static SpeciesData getSpeciesData(String types) {
        return SpeciesData.get(types);
    }

    private static SpeciesData checkCache(int size, String types) {
        int idx = size - 1;
        SpeciesData data = SPECIES_DATA_CACHE[idx];
        if (data != null) {
            return data;
        }
        BoundMethodHandle.SPECIES_DATA_CACHE[idx] = data = BoundMethodHandle.getSpeciesData(types);
        return data;
    }

    static SpeciesData speciesData_L() {
        return BoundMethodHandle.checkCache(1, "L");
    }

    static SpeciesData speciesData_LL() {
        return BoundMethodHandle.checkCache(2, "LL");
    }

    static SpeciesData speciesData_LLL() {
        return BoundMethodHandle.checkCache(3, "LLL");
    }

    static SpeciesData speciesData_LLLL() {
        return BoundMethodHandle.checkCache(4, "LLLL");
    }

    static SpeciesData speciesData_LLLLL() {
        return BoundMethodHandle.checkCache(5, "LLLLL");
    }

    static class Factory {
        static final String JLO_SIG = "Ljava/lang/Object;";
        static final String JLS_SIG = "Ljava/lang/String;";
        static final String JLC_SIG = "Ljava/lang/Class;";
        static final String MH = "java/lang/invoke/MethodHandle";
        static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
        static final String BMH = "java/lang/invoke/BoundMethodHandle";
        static final String BMH_SIG = "Ljava/lang/invoke/BoundMethodHandle;";
        static final String SPECIES_DATA = "java/lang/invoke/BoundMethodHandle$SpeciesData";
        static final String SPECIES_DATA_SIG = "Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String STABLE_SIG = "Ljava/lang/invoke/Stable;";
        static final String SPECIES_PREFIX_NAME = "Species_";
        static final String SPECIES_PREFIX_PATH = "java/lang/invoke/BoundMethodHandle$Species_";
        static final String BMHSPECIES_DATA_EWI_SIG = "(B)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String BMHSPECIES_DATA_GFC_SIG = "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String MYSPECIES_DATA_SIG = "()Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String VOID_SIG = "()V";
        static final String INT_SIG = "()I";
        static final String SIG_INCIPIT = "(Ljava/lang/invoke/MethodType;Ljava/lang/invoke/LambdaForm;";
        static final String[] E_THROWABLE = new String[]{"java/lang/Throwable"};
        static final ConcurrentMap<String, Class<? extends BoundMethodHandle>> CLASS_CACHE = new ConcurrentHashMap<String, Class<? extends BoundMethodHandle>>();

        Factory() {
        }

        static Class<? extends BoundMethodHandle> getConcreteBMHClass(String types) {
            return CLASS_CACHE.computeIfAbsent(types, new Function<String, Class<? extends BoundMethodHandle>>(){

                @Override
                public Class<? extends BoundMethodHandle> apply(String types) {
                    return Factory.generateConcreteBMHClass(types);
                }
            });
        }

        static Class<? extends BoundMethodHandle> generateConcreteBMHClass(String types) {
            ClassWriter cw = new ClassWriter(3);
            String shortTypes = LambdaForm.shortenSignature(types);
            String className = SPECIES_PREFIX_PATH + shortTypes;
            String sourceFile = SPECIES_PREFIX_NAME + shortTypes;
            boolean NOT_ACC_PUBLIC = false;
            cw.visit(50, 48, className, null, BMH, null);
            cw.visitSource(sourceFile, null);
            FieldVisitor fw = cw.visitField(8, "SPECIES_DATA", SPECIES_DATA_SIG, null, null);
            fw.visitAnnotation(STABLE_SIG, true);
            fw.visitEnd();
            for (int i = 0; i < types.length(); ++i) {
                char t = types.charAt(i);
                String fieldName = Factory.makeFieldName(types, i);
                String fieldDesc = t == 'L' ? JLO_SIG : String.valueOf(t);
                cw.visitField(16, fieldName, fieldDesc, null, null).visitEnd();
            }
            MethodVisitor mv = cw.visitMethod(2, "<init>", Factory.makeSignature(types, true), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(183, BMH, "<init>", Factory.makeSignature("", true), false);
            int i = 0;
            int j = 0;
            while (i < types.length()) {
                char t = types.charAt(i);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(Factory.typeLoadOp(t), j + 3);
                mv.visitFieldInsn(181, className, Factory.makeFieldName(types, i), Factory.typeSig(t));
                if (t == 'J' || t == 'D') {
                    ++j;
                }
                ++i;
                ++j;
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(16, "speciesData", MYSPECIES_DATA_SIG, null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, className, "SPECIES_DATA", SPECIES_DATA_SIG);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(16, "fieldCount", INT_SIG, null, null);
            mv.visitCode();
            int fc = types.length();
            if (fc <= 5) {
                mv.visitInsn(3 + fc);
            } else {
                mv.visitIntInsn(17, fc);
            }
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(8, "make", Factory.makeSignature(types, false), null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            int i2 = 0;
            int j2 = 0;
            while (i2 < types.length()) {
                char t = types.charAt(i2);
                mv.visitVarInsn(Factory.typeLoadOp(t), j2 + 2);
                if (t == 'J' || t == 'D') {
                    ++j2;
                }
                ++i2;
                ++j2;
            }
            mv.visitMethodInsn(183, className, "<init>", Factory.makeSignature(types, true), false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(16, "copyWith", Factory.makeSignature("", false), null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            Factory.emitPushFields(types, className, mv);
            mv.visitMethodInsn(183, className, "<init>", Factory.makeSignature(types, true), false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            for (LambdaForm.BasicType type : LambdaForm.BasicType.ARG_TYPES) {
                int ord = type.ordinal();
                char btChar = type.basicTypeChar();
                mv = cw.visitMethod(16, "copyWithExtend" + btChar, Factory.makeSignature(String.valueOf(btChar), false), null, E_THROWABLE);
                mv.visitCode();
                mv.visitFieldInsn(178, className, "SPECIES_DATA", SPECIES_DATA_SIG);
                int iconstInsn = 3 + ord;
                assert (iconstInsn <= 8);
                mv.visitInsn(iconstInsn);
                mv.visitMethodInsn(182, SPECIES_DATA, "extendWith", BMHSPECIES_DATA_EWI_SIG, false);
                mv.visitMethodInsn(182, SPECIES_DATA, "constructor", "()Ljava/lang/invoke/MethodHandle;", false);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                Factory.emitPushFields(types, className, mv);
                mv.visitVarInsn(Factory.typeLoadOp(btChar), 3);
                mv.visitMethodInsn(182, MH, "invokeBasic", Factory.makeSignature(types + btChar, false), false);
                mv.visitInsn(176);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            cw.visitEnd();
            byte[] classFile = cw.toByteArray();
            InvokerBytecodeGenerator.maybeDump(className, classFile);
            Class<BoundMethodHandle> bmhClass = MethodHandleStatics.UNSAFE.defineClass(className, classFile, 0, classFile.length, BoundMethodHandle.class.getClassLoader(), null).asSubclass(BoundMethodHandle.class);
            return bmhClass;
        }

        private static int typeLoadOp(char t) {
            switch (t) {
                case 'L': {
                    return 25;
                }
                case 'I': {
                    return 21;
                }
                case 'J': {
                    return 22;
                }
                case 'F': {
                    return 23;
                }
                case 'D': {
                    return 24;
                }
            }
            throw MethodHandleStatics.newInternalError("unrecognized type " + t);
        }

        private static void emitPushFields(String types, String className, MethodVisitor mv) {
            for (int i = 0; i < types.length(); ++i) {
                char tc = types.charAt(i);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, Factory.makeFieldName(types, i), Factory.typeSig(tc));
            }
        }

        static String typeSig(char t) {
            return t == 'L' ? JLO_SIG : String.valueOf(t);
        }

        private static MethodHandle makeGetter(Class<?> cbmhClass, String types, int index) {
            String fieldName = Factory.makeFieldName(types, index);
            Class<?> fieldType = Wrapper.forBasicType(types.charAt(index)).primitiveType();
            try {
                return LOOKUP.findGetter(cbmhClass, fieldName, fieldType);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        }

        static MethodHandle[] makeGetters(Class<?> cbmhClass, String types, MethodHandle[] mhs) {
            if (mhs == null) {
                mhs = new MethodHandle[types.length()];
            }
            for (int i = 0; i < mhs.length; ++i) {
                mhs[i] = Factory.makeGetter(cbmhClass, types, i);
                assert (mhs[i].internalMemberName().getDeclaringClass() == cbmhClass);
            }
            return mhs;
        }

        static MethodHandle[] makeCtors(Class<? extends BoundMethodHandle> cbmh, String types, MethodHandle[] mhs) {
            if (mhs == null) {
                mhs = new MethodHandle[1];
            }
            if (types.equals("")) {
                return mhs;
            }
            mhs[0] = Factory.makeCbmhCtor(cbmh, types);
            return mhs;
        }

        static LambdaForm.NamedFunction[] makeNominalGetters(String types, LambdaForm.NamedFunction[] nfs, MethodHandle[] getters) {
            if (nfs == null) {
                nfs = new LambdaForm.NamedFunction[types.length()];
            }
            for (int i = 0; i < nfs.length; ++i) {
                nfs[i] = new LambdaForm.NamedFunction(getters[i]);
            }
            return nfs;
        }

        static SpeciesData getSpeciesDataFromConcreteBMHClass(Class<? extends BoundMethodHandle> cbmh) {
            try {
                Field F_SPECIES_DATA = cbmh.getDeclaredField("SPECIES_DATA");
                return (SpeciesData)F_SPECIES_DATA.get(null);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }

        static void setSpeciesDataToConcreteBMHClass(Class<? extends BoundMethodHandle> cbmh, SpeciesData speciesData) {
            try {
                Field F_SPECIES_DATA = cbmh.getDeclaredField("SPECIES_DATA");
                assert (F_SPECIES_DATA.getDeclaredAnnotation(Stable.class) != null);
                F_SPECIES_DATA.set(null, speciesData);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }

        private static String makeFieldName(String types, int index) {
            assert (index >= 0 && index < types.length());
            return "arg" + types.charAt(index) + index;
        }

        private static String makeSignature(String types, boolean ctor) {
            StringBuilder buf = new StringBuilder(SIG_INCIPIT);
            for (char c : types.toCharArray()) {
                buf.append(Factory.typeSig(c));
            }
            return buf.append(')').append(ctor ? "V" : BMH_SIG).toString();
        }

        static MethodHandle makeCbmhCtor(Class<? extends BoundMethodHandle> cbmh, String types) {
            try {
                return LOOKUP.findStatic(cbmh, "make", MethodType.fromMethodDescriptorString(Factory.makeSignature(types, false), null));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | TypeNotPresentException e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        }
    }

    static class SpeciesData {
        private final String typeChars;
        private final LambdaForm.BasicType[] typeCodes;
        private final Class<? extends BoundMethodHandle> clazz;
        @Stable
        private final MethodHandle[] constructor;
        @Stable
        private final MethodHandle[] getters;
        @Stable
        private final LambdaForm.NamedFunction[] nominalGetters;
        @Stable
        private final SpeciesData[] extensions;
        static final SpeciesData EMPTY = new SpeciesData("", BoundMethodHandle.class);
        private static final ConcurrentMap<String, SpeciesData> CACHE = new ConcurrentHashMap<String, SpeciesData>();
        private static final boolean INIT_DONE;

        int fieldCount() {
            return this.typeCodes.length;
        }

        LambdaForm.BasicType fieldType(int i) {
            return this.typeCodes[i];
        }

        char fieldTypeChar(int i) {
            return this.typeChars.charAt(i);
        }

        Object fieldSignature() {
            return this.typeChars;
        }

        public Class<? extends BoundMethodHandle> fieldHolder() {
            return this.clazz;
        }

        public String toString() {
            return "SpeciesData<" + this.fieldSignature() + ">";
        }

        LambdaForm.NamedFunction getterFunction(int i) {
            LambdaForm.NamedFunction nf = this.nominalGetters[i];
            assert (nf.memberDeclaringClassOrNull() == this.fieldHolder());
            assert (nf.returnType() == this.fieldType(i));
            return nf;
        }

        LambdaForm.NamedFunction[] getterFunctions() {
            return this.nominalGetters;
        }

        MethodHandle[] getterHandles() {
            return this.getters;
        }

        MethodHandle constructor() {
            return this.constructor[0];
        }

        SpeciesData(String types, Class<? extends BoundMethodHandle> clazz) {
            this.typeChars = types;
            this.typeCodes = LambdaForm.BasicType.basicTypes(types);
            this.clazz = clazz;
            if (!INIT_DONE) {
                this.constructor = new MethodHandle[1];
                this.getters = new MethodHandle[types.length()];
                this.nominalGetters = new LambdaForm.NamedFunction[types.length()];
            } else {
                this.constructor = Factory.makeCtors(clazz, types, null);
                this.getters = Factory.makeGetters(clazz, types, null);
                this.nominalGetters = Factory.makeNominalGetters(types, null, this.getters);
            }
            this.extensions = new SpeciesData[LambdaForm.BasicType.ARG_TYPE_LIMIT];
        }

        private void initForBootstrap() {
            assert (!INIT_DONE);
            if (this.constructor() == null) {
                String types = this.typeChars;
                CACHE.put(types, this);
                Factory.makeCtors(this.clazz, types, this.constructor);
                Factory.makeGetters(this.clazz, types, this.getters);
                Factory.makeNominalGetters(types, this.nominalGetters, this.getters);
            }
        }

        SpeciesData extendWith(byte type) {
            return this.extendWith(LambdaForm.BasicType.basicType(type));
        }

        SpeciesData extendWith(LambdaForm.BasicType type) {
            int ord = type.ordinal();
            SpeciesData d = this.extensions[ord];
            if (d != null) {
                return d;
            }
            this.extensions[ord] = d = SpeciesData.get(this.typeChars + type.basicTypeChar());
            return d;
        }

        private static SpeciesData get(String types) {
            return CACHE.computeIfAbsent(types, new Function<String, SpeciesData>(){

                @Override
                public SpeciesData apply(String types) {
                    Class<? extends BoundMethodHandle> bmhcl = Factory.getConcreteBMHClass(types);
                    SpeciesData speciesData = new SpeciesData(types, bmhcl);
                    Factory.setSpeciesDataToConcreteBMHClass(bmhcl, speciesData);
                    return speciesData;
                }
            });
        }

        static boolean speciesDataCachePopulated() {
            Class<BoundMethodHandle> rootCls = BoundMethodHandle.class;
            try {
                for (Class<?> c : rootCls.getDeclaredClasses()) {
                    if (!rootCls.isAssignableFrom(c)) continue;
                    Class<BoundMethodHandle> cbmh = c.asSubclass(BoundMethodHandle.class);
                    SpeciesData d = Factory.getSpeciesDataFromConcreteBMHClass(cbmh);
                    assert (d != null) : cbmh.getName();
                    assert (d.clazz == cbmh);
                    assert (CACHE.get(d.typeChars) == d);
                }
            }
            catch (Throwable e) {
                throw MethodHandleStatics.newInternalError(e);
            }
            return true;
        }

        static {
            EMPTY.initForBootstrap();
            Species_L.SPECIES_DATA.initForBootstrap();
            assert (SpeciesData.speciesDataCachePopulated());
            INIT_DONE = Boolean.TRUE;
        }
    }

    private static final class Species_L
    extends BoundMethodHandle {
        final Object argL0;
        static final SpeciesData SPECIES_DATA = new SpeciesData("L", Species_L.class);

        private Species_L(MethodType mt, LambdaForm lf, Object argL0) {
            super(mt, lf);
            this.argL0 = argL0;
        }

        @Override
        SpeciesData speciesData() {
            return SPECIES_DATA;
        }

        @Override
        int fieldCount() {
            return 1;
        }

        static BoundMethodHandle make(MethodType mt, LambdaForm lf, Object argL0) {
            return new Species_L(mt, lf, argL0);
        }

        @Override
        final BoundMethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Species_L(mt, lf, this.argL0);
        }

        @Override
        final BoundMethodHandle copyWithExtendL(MethodType mt, LambdaForm lf, Object narg) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.L_TYPE).constructor().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendI(MethodType mt, LambdaForm lf, int narg) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.I_TYPE).constructor().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendJ(MethodType mt, LambdaForm lf, long narg) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.J_TYPE).constructor().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendF(MethodType mt, LambdaForm lf, float narg) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.F_TYPE).constructor().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendD(MethodType mt, LambdaForm lf, double narg) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.D_TYPE).constructor().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }
    }
}

