/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.LdapPrincipal;
import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jdk.Exported;

@Exported
public class LdapLoginModule
implements LoginModule {
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private static final String USERNAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private static final String USER_PROVIDER = "userProvider";
    private static final String USER_FILTER = "userFilter";
    private static final String AUTHC_IDENTITY = "authIdentity";
    private static final String AUTHZ_IDENTITY = "authzIdentity";
    private static final String USERNAME_TOKEN = "{USERNAME}";
    private static final Pattern USERNAME_PATTERN = Pattern.compile("\\{USERNAME\\}");
    private String userProvider;
    private String userFilter;
    private String authcIdentity;
    private String authzIdentity;
    private String authzIdentityAttr = null;
    private boolean useSSL = true;
    private boolean authFirst = false;
    private boolean authOnly = false;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private LdapPrincipal ldapPrincipal;
    private UserPrincipal userPrincipal;
    private UserPrincipal authzPrincipal;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Map<String, ?> options;
    private LdapContext ctx;
    private Matcher identityMatcher = null;
    private Matcher filterMatcher = null;
    private Hashtable<String, Object> ldapEnvironment;
    private SearchControls constraints = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.ldapEnvironment = new Hashtable(9);
        this.ldapEnvironment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        for (String key : options.keySet()) {
            if (key.indexOf(".") <= -1) continue;
            this.ldapEnvironment.put(key, options.get(key));
        }
        this.userProvider = (String)options.get(USER_PROVIDER);
        if (this.userProvider != null) {
            this.ldapEnvironment.put("java.naming.provider.url", this.userProvider);
        }
        this.authcIdentity = (String)options.get(AUTHC_IDENTITY);
        if (this.authcIdentity != null && this.authcIdentity.indexOf(USERNAME_TOKEN) != -1) {
            this.identityMatcher = USERNAME_PATTERN.matcher(this.authcIdentity);
        }
        this.userFilter = (String)options.get(USER_FILTER);
        if (this.userFilter != null) {
            if (this.userFilter.indexOf(USERNAME_TOKEN) != -1) {
                this.filterMatcher = USERNAME_PATTERN.matcher(this.userFilter);
            }
            this.constraints = new SearchControls();
            this.constraints.setSearchScope(2);
            this.constraints.setReturningAttributes(new String[0]);
        }
        this.authzIdentity = (String)options.get(AUTHZ_IDENTITY);
        if (this.authzIdentity != null && this.authzIdentity.startsWith("{") && this.authzIdentity.endsWith("}")) {
            if (this.constraints != null) {
                this.authzIdentityAttr = this.authzIdentity.substring(1, this.authzIdentity.length() - 1);
                this.constraints.setReturningAttributes(new String[]{this.authzIdentityAttr});
            }
            this.authzIdentity = null;
        }
        if (this.authcIdentity != null) {
            if (this.userFilter != null) {
                this.authFirst = true;
            } else {
                this.authOnly = true;
            }
        }
        if ("false".equalsIgnoreCase((String)options.get("useSSL"))) {
            this.useSSL = false;
            this.ldapEnvironment.remove("java.naming.security.protocol");
        } else {
            this.ldapEnvironment.put("java.naming.security.protocol", "ssl");
        }
        this.tryFirstPass = "true".equalsIgnoreCase((String)options.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)options.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)options.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)options.get("clearPass"));
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (this.debug) {
            if (this.authFirst) {
                System.out.println("\t\t[LdapLoginModule] authentication-first mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            } else if (this.authOnly) {
                System.out.println("\t\t[LdapLoginModule] authentication-only mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            } else {
                System.out.println("\t\t[LdapLoginModule] search-first mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        if (this.userProvider == null) {
            throw new LoginException("Unable to locate the LDAP directory service");
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] user provider: " + this.userProvider);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] tryFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl29
                System.out.println("\t\t[LdapLoginModule] tryFirstPass failed: " + le.toString());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] useFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] useFirstPass failed");
                }
                throw le;
            }
        }
lbl29:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] authentication succeeded");
            }
            return true;
        }
        catch (LoginException le) {
            this.cleanState();
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] authentication failed");
            }
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.ldapPrincipal)) {
            principals.add(this.ldapPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] added LdapPrincipal \"" + this.ldapPrincipal + "\" to Subject");
        }
        if (!principals.contains(this.userPrincipal)) {
            principals.add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] added UserPrincipal \"" + this.userPrincipal + "\" to Subject");
        }
        if (this.authzPrincipal != null && !principals.contains(this.authzPrincipal)) {
            principals.add(this.authzPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] added UserPrincipal \"" + this.authzPrincipal + "\" to Subject");
            }
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] aborted authentication");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.ldapPrincipal = null;
            this.userPrincipal = null;
            this.authzPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(this.ldapPrincipal);
        principals.remove(this.userPrincipal);
        if (this.authzIdentity != null) {
            principals.remove(this.authzPrincipal);
        }
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.ldapPrincipal = null;
        this.userPrincipal = null;
        this.authzPrincipal = null;
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] logged out Subject");
        }
        return true;
    }

    private void attemptAuthentication(boolean getPasswdFromSharedState) throws LoginException {
        this.getUsernamePassword(getPasswdFromSharedState);
        if (this.password == null || this.password.length == 0) {
            throw new FailedLoginException("No password was supplied");
        }
        String dn = "";
        if (this.authFirst || this.authOnly) {
            String id = this.replaceUsernameToken(this.identityMatcher, this.authcIdentity, this.username);
            this.ldapEnvironment.put("java.naming.security.credentials", this.password);
            this.ldapEnvironment.put("java.naming.security.principal", id);
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] attempting to authenticate user: " + this.username);
            }
            try {
                this.ctx = new InitialLdapContext(this.ldapEnvironment, null);
            }
            catch (NamingException e) {
                throw (LoginException)new FailedLoginException("Cannot bind to LDAP server").initCause(e);
            }
            dn = this.userFilter != null ? this.findUserDN(this.ctx) : id;
        } else {
            try {
                this.ctx = new InitialLdapContext(this.ldapEnvironment, null);
            }
            catch (NamingException e) {
                throw (LoginException)new FailedLoginException("Cannot connect to LDAP server").initCause(e);
            }
            dn = this.findUserDN(this.ctx);
            try {
                this.ctx.addToEnvironment("java.naming.security.authentication", "simple");
                this.ctx.addToEnvironment("java.naming.security.principal", dn);
                this.ctx.addToEnvironment("java.naming.security.credentials", this.password);
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] attempting to authenticate user: " + this.username);
                }
                this.ctx.reconnect(null);
            }
            catch (NamingException e) {
                throw (LoginException)new FailedLoginException("Cannot bind to LDAP server").initCause(e);
            }
        }
        if (this.storePass && !this.sharedState.containsKey(USERNAME_KEY) && !this.sharedState.containsKey(PASSWORD_KEY)) {
            this.sharedState.put(USERNAME_KEY, this.username);
            this.sharedState.put(PASSWORD_KEY, this.password);
        }
        this.userPrincipal = new UserPrincipal(this.username);
        if (this.authzIdentity != null) {
            this.authzPrincipal = new UserPrincipal(this.authzIdentity);
        }
        try {
            this.ldapPrincipal = new LdapPrincipal(dn);
        }
        catch (InvalidNameException e) {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] cannot create LdapPrincipal: bad DN");
            }
            throw (LoginException)new FailedLoginException("Cannot create LdapPrincipal").initCause(e);
        }
    }

    private String findUserDN(LdapContext ctx) throws LoginException {
        String userDN = "";
        if (this.userFilter != null) {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] searching for entry belonging to user: " + this.username);
            }
        } else {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] cannot search for entry belonging to user: " + this.username);
            }
            throw new FailedLoginException("Cannot find user's LDAP entry");
        }
        try {
            String canonicalUserFilter = this.replaceUsernameToken(this.filterMatcher, this.userFilter, this.escapeUsernameChars());
            NamingEnumeration<SearchResult> results = ctx.search("", canonicalUserFilter, this.constraints);
            if (results.hasMore()) {
                Object val;
                Attribute attr;
                SearchResult entry = results.next();
                userDN = entry.getNameInNamespace();
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] found entry: " + userDN);
                }
                if (this.authzIdentityAttr != null && (attr = entry.getAttributes().get(this.authzIdentityAttr)) != null && (val = attr.get()) instanceof String) {
                    this.authzIdentity = (String)val;
                }
                results.close();
            } else if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] user's entry not found");
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (userDN.equals("")) {
            throw new FailedLoginException("Cannot find user's LDAP entry");
        }
        return userDN;
    }

    private String escapeUsernameChars() {
        int len = this.username.length();
        StringBuilder escapedUsername = new StringBuilder(len + 16);
        block7: for (int i = 0; i < len; ++i) {
            char c = this.username.charAt(i);
            switch (c) {
                case '*': {
                    escapedUsername.append("\\\\2A");
                    continue block7;
                }
                case '(': {
                    escapedUsername.append("\\\\28");
                    continue block7;
                }
                case ')': {
                    escapedUsername.append("\\\\29");
                    continue block7;
                }
                case '\\': {
                    escapedUsername.append("\\\\5C");
                    continue block7;
                }
                case '\u0000': {
                    escapedUsername.append("\\\\00");
                    continue block7;
                }
                default: {
                    escapedUsername.append(c);
                }
            }
        }
        return escapedUsername.toString();
    }

    private String replaceUsernameToken(Matcher matcher, String string, String username) {
        return matcher != null ? matcher.replaceAll(username) : string;
    }

    private void getUsernamePassword(boolean getPasswdFromSharedState) throws LoginException {
        if (getPasswdFromSharedState) {
            this.username = (String)this.sharedState.get(USERNAME_KEY);
            this.password = (char[])this.sharedState.get(PASSWORD_KEY);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to acquire authentication information from the user");
        }
        Callback[] callbacks = new Callback[]{new NameCallback(rb.getString("username.")), new PasswordCallback(rb.getString("password."), false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to acquire authentication information from the user");
        }
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        try {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.ctx = null;
        if (this.clearPass) {
            this.sharedState.remove(USERNAME_KEY);
            this.sharedState.remove(PASSWORD_KEY);
        }
    }
}

