/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="AUTH_PERMISSION t LEFT JOIN AUTH_PERMISSION p ON t.AUTH_PERMISSION_PARENT_ID = p.ID ")
@OrderBy(after="t.ID")
@GridConfig(operate=true, idField="id", winHeight=320, winWidth=470, operates={@GridOperate(type="edit", permission="auth:permission:menu:edit", url="authPermissionMenu.do?edit", label="common_op_edit")})
public class AuthPermissionMenuItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.CODE")
    @GridColumn(columnType="edit", label="auth_resource_number", width="150", editPermission="auth:permission:menu:edit", editUrl="authPermissionMenu.do?edit&id=(id)")
    private String code;
    @Column(name="t.NAME")
    @GridColumn(label="auth_resource_name", width="150")
    private String name;
    @Column(name="t.PERMISSION")
    @GridColumn(label="auth_resource_permissionCode", width="150")
    private String permission;
    @Column(name="t.ACTION_LINK")
    private String actionLink;
    @Column(name="t.RESOURCE_TYPE")
    private String resourceType;
    private String parentId;
    private String parentName;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="common_createdTime", width="130")
    private Date createTime;
    @Column(name="t.AVAILABLE")
    @GridColumn(label="common_status", columnType="custom", convert="convertToIcon")
    private String available;
    @GridColumn(label="auth_resource_ownedSystem", width="150")
    @Condition(value="p.id in (SELECT a.id FROM auth_permission a LEFT JOIN auth_permission pa ON a.auth_permission_parent_id = pa.id WHERE pa.name LIKE '%%%s%%' AND pa.resource_type = 'system')")
    private String systemName;

    public AuthPermissionMenuItem() {
    }

    public AuthPermissionMenuItem(Boolean equals) {
        super(equals);
    }

    public AuthPermissionMenuItem(String id) {
        this.id = id;
    }

    public AuthPermissionMenuItem(String id, String code, String name, String permission, String resourceType, String available, Date createTime, String parentName) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.permission = permission;
        this.resourceType = resourceType;
        this.available = available;
        this.createTime = createTime;
        this.parentName = parentName;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getActionLink() {
        return this.actionLink;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getAvailable() {
        return this.available;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public AuthPermissionMenuItem setId(String id) {
        this.id = id;
        return this;
    }

    public AuthPermissionMenuItem setCode(String code) {
        this.code = code;
        return this;
    }

    public AuthPermissionMenuItem setName(String name) {
        this.name = name;
        return this;
    }

    public AuthPermissionMenuItem setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public AuthPermissionMenuItem setActionLink(String actionLink) {
        this.actionLink = actionLink;
        return this;
    }

    public AuthPermissionMenuItem setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public AuthPermissionMenuItem setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public AuthPermissionMenuItem setParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public AuthPermissionMenuItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public AuthPermissionMenuItem setAvailable(String available) {
        this.available = available;
        return this;
    }

    public AuthPermissionMenuItem setSystemName(String systemName) {
        this.systemName = systemName;
        return this;
    }
}

