/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.led.sdk;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.led.sdk.LedSdk;
import com.zkteco.zkbiosecurity.led.vo.LedDeviceItem;

public class LedSdkDeal {
    private static LedSdk ledSdk = null;

    public static synchronized JSONObject init(String ip, int port, String idCode, int timeOut) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_Init(LedSdkDeal.ipToInt(ip), port, LedSdkDeal.ipToInt(idCode), timeOut);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized int ipToInt(String strIp) {
        int[] ip = new int[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Integer.parseInt(strIp.substring(0, position1));
        ip[1] = Integer.parseInt(strIp.substring(position1 + 1, position2));
        ip[2] = Integer.parseInt(strIp.substring(position2 + 1, position3));
        ip[3] = Integer.parseInt(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static synchronized JSONObject connect() {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_Connect();
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject isConnected() {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_IsConnected();
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject disconnect() {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_Disconnect();
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject testController(int cardID) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_TestController(cardID);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject testCommunication(int cardID) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_TestCommunication(cardID);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject splitScreen(int cardID, int scrWidth, int scrHeight, int wndCnt, int[] args, LedDeviceItem item) {
        JSONObject retObj = new JSONObject();
        Memory pArrIntInput = null;
        try {
            pArrIntInput = new Memory((long)(args.length * 4));
            for (int i = 0; i < args.length; ++i) {
                pArrIntInput.setInt((long)(i * 4), args[i]);
            }
            LedSdkDeal.init(item.getIp(), Integer.parseInt(item.getPort()), item.getIdCode(), 600);
            int ret = ledSdk.CP5200_Net_SplitScreen(cardID, scrWidth, scrHeight, wndCnt, (Pointer)pArrIntInput);
            retObj.put("result", (Object)ret);
        }
        catch (JSONException e) {
            try {
                throw new ZKBusinessException(e.getMessage());
            }
            catch (Throwable throwable) {
                Native.free((long)Pointer.nativeValue(pArrIntInput));
                Pointer.nativeValue(pArrIntInput, (long)0L);
                throw throwable;
            }
        }
        Native.free((long)Pointer.nativeValue((Pointer)pArrIntInput));
        Pointer.nativeValue((Pointer)pArrIntInput, (long)0L);
        return retObj;
    }

    public static synchronized JSONObject exitSplitScreen(int cardID) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_ExitSplitScreen(cardID);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject sendText(int cardID, int wndNo, String text, int color, int fontSize, int speed, int effect, int stayTime, int alignment, LedDeviceItem item) {
        System.setProperty("jna.encoding", "GBK");
        JSONObject retObj = new JSONObject();
        try {
            LedSdkDeal.init(item.getIp(), Integer.parseInt(item.getPort()), item.getIdCode(), 6000);
            int ret = ledSdk.CP5200_Net_SendText(cardID, wndNo, text, color, fontSize, speed, effect, stayTime, alignment);
            retObj.put("result", (Object)ret);
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new ZKBusinessException(e.getMessage());
        }
        return retObj;
    }

    public static synchronized JSONObject sendClock(int cardID, int wndNo, int stayTime, int calendar, int format, int content, int font, int red, int green, int blue, String txt, LedDeviceItem item) {
        JSONObject retObj = new JSONObject();
        LedSdkDeal.init(item.getIp(), Integer.parseInt(item.getPort()), item.getIdCode(), 600);
        int ret = ledSdk.CP5200_Net_SendClock(cardID, wndNo, stayTime, calendar, format, content, font, red, green, blue, txt);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject sendPicture(int cardID, int wndNo, int nPosX, int nPosY, int nCx, int nCy, String imageFilePath, int nSpeed, int nEffect, int nStayTime, LedDeviceItem item) {
        System.setProperty("jna.encoding", "GBK");
        JSONObject retObj = new JSONObject();
        LedSdkDeal.init(item.getIp(), Integer.parseInt(item.getPort()), item.getIdCode(), 600);
        int ret = ledSdk.CP5200_Net_SendPicture(cardID, wndNo, nPosX, nPosY, nCx, nCy, imageFilePath, nSpeed, nEffect, nStayTime, 0);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject restartApp(int cardID) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_RestartApp(cardID);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject restartSys(int cardID) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_RestartSys(cardID);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject writeNetworkParam(int cardID, String ip, String gateway, String ipMast, int port, String idCode) {
        JSONObject retObj = new JSONObject();
        int ret = ledSdk.CP5200_Net_WriteNetworkParam(cardID, LedSdkDeal.ipToInt(ip), LedSdkDeal.ipToInt(gateway), LedSdkDeal.ipToInt(ipMast), port, LedSdkDeal.ipToInt(idCode));
        retObj.put("result", (Object)ret);
        return retObj;
    }

    public static synchronized JSONObject setTime(byte cardID, byte[] byTimeInfo, LedDeviceItem item) {
        System.setProperty("jna.encoding", "GBK");
        JSONObject retObj = new JSONObject();
        LedSdkDeal.init(item.getIp(), Integer.parseInt(item.getPort()), item.getIdCode(), 600);
        int ret = ledSdk.CP5200_Net_SetTime(cardID, byTimeInfo);
        retObj.put("result", (Object)ret);
        return retObj;
    }

    static {
        ledSdk = (LedSdk)Native.loadLibrary((String)"CP5200", LedSdk.class);
    }
}

