/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.types;

import java.math.BigDecimal;
import org.postgresql.core.types.PGBigDecimal;
import org.postgresql.core.types.PGBoolean;
import org.postgresql.core.types.PGDouble;
import org.postgresql.core.types.PGFloat;
import org.postgresql.core.types.PGShort;
import org.postgresql.core.types.PGString;
import org.postgresql.core.types.PGType;
import org.postgresql.core.types.PGUnknown;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGInteger
implements PGType {
    private Integer val;

    protected PGInteger(Integer x2) {
        this.val = x2;
    }

    public static PGType castToServerType(Integer val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -7: {
                    return new PGBoolean(val == 0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case 7: {
                    return new PGFloat(new Float(val.floatValue()));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(val.doubleValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(val.toString());
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(val.shortValue()));
                }
                case 4: {
                    return new PGInteger(val);
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val.toString()));
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.val.toString();
    }
}

