/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Util {
    static final String SYSTEM_SPEC_VERSION = System.getProperty("java.specification.version");
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String WSIDNotAvailable = "";

    Util() {
    }

    static short readShort(byte[] byArray, int n2) {
        return (short)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
    }

    static int readUnsignedShort(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    static int readUnsignedShortBigEndian(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    static void writeShort(short s2, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(s2 >> 0 & 0xFF);
        byArray[n2 + 1] = (byte)(s2 >> 8 & 0xFF);
    }

    static void writeShortBigEndian(short s2, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(s2 >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(s2 >> 0 & 0xFF);
    }

    static int readInt(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 0] & 0xFF;
        int n4 = (byArray[n2 + 1] & 0xFF) << 8;
        int n5 = (byArray[n2 + 2] & 0xFF) << 16;
        int n6 = (byArray[n2 + 3] & 0xFF) << 24;
        return n6 | n5 | n4 | n3;
    }

    static int readIntBigEndian(byte[] byArray, int n2) {
        return (byArray[n2 + 3] & 0xFF) << 0 | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 0] & 0xFF) << 24;
    }

    static void writeInt(int n2, byte[] byArray, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 0 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    static void writeIntBigEndian(int n2, byte[] byArray, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 0 & 0xFF);
    }

    static long readLong(byte[] byArray, int n2) {
        long l2 = 0L;
        for (int i2 = 7; i2 > 0; --i2) {
            l2 += (long)(byArray[n2 + i2] & 0xFF);
            l2 <<= 8;
        }
        return l2 + (long)(byArray[n2] & 0xFF);
    }

    static Properties parseUrl(String string, Logger logger) throws SQLServerException {
        Properties properties = new Properties();
        String string2 = string;
        String string3 = "jdbc:sqlserver://";
        String string4 = WSIDNotAvailable;
        String string5 = WSIDNotAvailable;
        String string6 = WSIDNotAvailable;
        if (!string2.startsWith(string3)) {
            return null;
        }
        string2 = string2.substring(string3.length());
        int n2 = 0;
        int n3 = 0;
        block18: for (n2 = 0; n2 < string2.length(); ++n2) {
            char c2 = string2.charAt(n2);
            switch (n3) {
                case 0: {
                    if (c2 == ';') {
                        n3 = 7;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    if (c2 == ';' || c2 == ':' || c2 == '\\') {
                        if ((string4 = string4.trim()).length() > 0) {
                            properties.put("serverName", string4);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Property : serverName Value:" + string4);
                            }
                        }
                        string4 = WSIDNotAvailable;
                        if (c2 == ';') {
                            n3 = 7;
                            continue block18;
                        }
                        if (c2 == ':') {
                            n3 = 2;
                            continue block18;
                        }
                        n3 = 3;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    continue block18;
                }
                case 2: {
                    if (c2 == ';') {
                        string4 = string4.trim();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Property : portNumber Value:" + string4);
                        }
                        properties.put("portNumber", string4);
                        string4 = WSIDNotAvailable;
                        n3 = 7;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    continue block18;
                }
                case 3: {
                    if (c2 == ';' || c2 == ':') {
                        string4 = string4.trim();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Property : instanceName Value:" + string6);
                        }
                        properties.put("instanceName", string4.toLowerCase(Locale.US));
                        string4 = WSIDNotAvailable;
                        if (c2 == ';') {
                            n3 = 7;
                            continue block18;
                        }
                        n3 = 2;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    continue block18;
                }
                case 7: {
                    if (c2 == '=') {
                        if ((string5 = string5.trim()).length() <= 0) {
                            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        }
                        n3 = 6;
                        continue block18;
                    }
                    if (c2 == ';') {
                        if ((string5 = string5.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string5 = string5 + c2;
                    continue block18;
                }
                case 6: {
                    if (c2 == ';') {
                        string6 = string6.trim();
                        if (null != (string5 = SQLServerDriver.getNormalizedPropertyName(string5, logger))) {
                            if (logger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                logger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = WSIDNotAvailable;
                        string6 = WSIDNotAvailable;
                        n3 = 7;
                        continue block18;
                    }
                    if (c2 == '{') {
                        n3 = 4;
                        if ((string6 = string6.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string6 = string6 + c2;
                    continue block18;
                }
                case 4: {
                    if (c2 == '}') {
                        if (null != (string5 = SQLServerDriver.getNormalizedPropertyName(string5, logger))) {
                            if (logger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                logger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = WSIDNotAvailable;
                        string6 = WSIDNotAvailable;
                        n3 = 5;
                        continue block18;
                    }
                    string6 = string6 + c2;
                    continue block18;
                }
                case 5: {
                    if (c2 == ';') {
                        n3 = 7;
                        continue block18;
                    }
                    if (c2 == ' ') continue block18;
                    SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                    continue block18;
                }
                default: {
                    assert (false) : "parseURL: Invalid state " + n3;
                    continue block18;
                }
            }
        }
        switch (n3) {
            case 1: {
                string4 = string4.trim();
                if (string4.length() <= 0) break;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Property : serverName Value:" + string4);
                }
                properties.put("serverName", string4);
                break;
            }
            case 2: {
                string4 = string4.trim();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Property : portNumber Value:" + string4);
                }
                properties.put("portNumber", string4);
                break;
            }
            case 3: {
                string4 = string4.trim();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Property : instanceName Value:" + string4);
                }
                properties.put("instanceName", string4);
                break;
            }
            case 6: {
                string6 = string6.trim();
                string5 = SQLServerDriver.getNormalizedPropertyName(string5, logger);
                if (null == string5) break;
                if (logger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                    logger.fine("Property:" + string5 + "Value:" + string6);
                }
                properties.put(string5, string6);
                break;
            }
            case 0: 
            case 5: {
                break;
            }
            case 7: {
                string5 = string5.trim();
                if (string5.length() <= 0) break;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                break;
            }
            default: {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
        }
        return properties;
    }

    static String escapeSQLId(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('[');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (']' == c2) {
                stringBuilder.append("]]");
                continue;
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static String readUnicodeString(byte[] byArray, int n2, int n3) throws SQLServerException {
        try {
            return new String(byArray, n2, n3, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String byteToHexDisplayString(byte[] byArray) {
        if (null == byArray) {
            return "(null)";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2 + 2);
        stringBuilder.append("0x");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuilder.append(hexChars[(n2 & 0xF0) >> 4]);
            stringBuilder.append(hexChars[n2 & 0xF]);
        }
        return stringBuilder.toString();
    }

    static String bytesToHexString(byte[] byArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            stringBuilder.append(hexChars[(n3 & 0xF0) >> 4]);
            stringBuilder.append(hexChars[n3 & 0xF]);
        }
        return stringBuilder.toString();
    }

    static String lookupHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (null != inetAddress) {
                String string = inetAddress.getHostName();
                if (null != string && string.length() > 0) {
                    return string;
                }
                string = inetAddress.getHostAddress();
                if (null != string && string.length() > 0) {
                    return string;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            return WSIDNotAvailable;
        }
        return WSIDNotAvailable;
    }
}

