/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;

final class PLPXMLInputStream
extends PLPInputStream {
    private static final byte[] xmlBOM = new byte[]{-1, -2};
    private final ByteArrayInputStream bomStream = new ByteArrayInputStream(xmlBOM);

    static final PLPXMLInputStream makeXMLStream(TDSReader tDSReader, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        long l2 = tDSReader.readLong();
        if (-1L == l2) {
            return null;
        }
        PLPXMLInputStream pLPXMLInputStream = new PLPXMLInputStream(tDSReader, l2, inputStreamGetterArgs, serverDTVImpl);
        if (null != pLPXMLInputStream) {
            pLPXMLInputStream.setLoggingInfo(inputStreamGetterArgs.logContext);
        }
        return pLPXMLInputStream;
    }

    PLPXMLInputStream(TDSReader tDSReader, long l2, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, l2, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    int readBytes(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        assert (n2 >= 0);
        assert (n3 >= 0);
        if (0 == n3) {
            return 0;
        }
        int n6 = 0;
        if (null == byArray) {
            n5 = 0;
            for (n4 = 0; n4 < n3 && 0 != (n5 = (int)this.bomStream.skip(n3 - n4)); n4 += n5) {
            }
        } else {
            n5 = 0;
            while (n4 < n3 && -1 != (n5 = this.bomStream.read(byArray, n2 + n4, n3 - n4))) {
                n4 += n5;
            }
        }
        while (n4 < n3 && -1 != (n6 = super.readBytes(byArray, n2 + n4, n3 - n4))) {
            n4 += n6;
        }
        if (n4 > 0) {
            return n4;
        }
        assert (-1 == n6);
        return -1;
    }

    @Override
    public void mark(int n2) {
        this.bomStream.mark(xmlBOM.length);
        super.mark(n2);
    }

    @Override
    public void reset() throws IOException {
        this.bomStream.reset();
        super.reset();
    }

    @Override
    byte[] getBytes() throws SQLServerException {
        byte[] byArray = new byte[2];
        try {
            int n2 = this.bomStream.read(byArray);
            byte[] byArray2 = super.getBytes();
            if (n2 > 0) {
                assert (2 == n2);
                byte[] byArray3 = new byte[byArray2.length + n2];
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
                return byArray3;
            }
            return byArray2;
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            return null;
        }
    }
}

