/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.util.Calendar;

final class Column {
    private TypeInfo typeInfo;
    private DTV updaterDTV;
    private final DTV getterDTV = new DTV();
    private String columnName;
    private String baseColumnName;
    private int tableNum;
    private int infoStatus;
    private SQLIdentifier tableName;
    ColumnFilter filter;

    final TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    final void setColumnName(String string) {
        this.columnName = string;
    }

    final String getColumnName() {
        return this.columnName;
    }

    final void setBaseColumnName(String string) {
        this.baseColumnName = string;
    }

    final String getBaseColumnName() {
        return this.baseColumnName;
    }

    final void setTableNum(int n2) {
        this.tableNum = n2;
    }

    final int getTableNum() {
        return this.tableNum;
    }

    final void setInfoStatus(int n2) {
        this.infoStatus = n2;
    }

    final boolean hasDifferentName() {
        return 0 != (this.infoStatus & 0x20);
    }

    final boolean isHidden() {
        return 0 != (this.infoStatus & 0x10);
    }

    final boolean isKey() {
        return 0 != (this.infoStatus & 8);
    }

    final boolean isExpression() {
        return 0 != (this.infoStatus & 4);
    }

    final boolean isUpdatable() {
        return !this.isExpression() && !this.isHidden() && this.tableName.getObjectName().length() > 0;
    }

    final void setTableName(SQLIdentifier sQLIdentifier) {
        this.tableName = sQLIdentifier;
    }

    final SQLIdentifier getTableName() {
        return this.tableName;
    }

    Column(TypeInfo typeInfo, String string, SQLIdentifier sQLIdentifier) {
        this.typeInfo = typeInfo;
        this.columnName = string;
        this.baseColumnName = string;
        this.tableName = sQLIdentifier;
    }

    final void clear() {
        this.getterDTV.clear();
    }

    final void skipValue(TDSReader tDSReader, boolean bl) throws SQLServerException {
        this.getterDTV.skipValue(this.typeInfo, tDSReader, bl);
    }

    void setFilter(ColumnFilter columnFilter) {
        this.filter = columnFilter;
    }

    final boolean isNull() {
        return this.getterDTV.isNull();
    }

    Object getValue(JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        Object object = this.getterDTV.getValue(jDBCType, this.typeInfo.getScale(), inputStreamGetterArgs, calendar, this.typeInfo, tDSReader);
        return null != this.filter ? this.filter.apply(object, jDBCType) : object;
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        return (Integer)this.getValue(JDBCType.INTEGER, null, null, tDSReader);
    }

    void updateValue(JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        SSType sSType = this.typeInfo.getSSType();
        if (null != streamSetterArgs) {
            if (!streamSetterArgs.streamType.convertsTo(this.typeInfo)) {
                DataTypes.throwConversionError(streamSetterArgs.streamType.toString(), sSType.toString());
            }
        } else if (!jDBCType.convertsTo(sSType)) {
            DataTypes.throwConversionError(jDBCType.toString(), sSType.toString());
        }
        if (!(JDBCType.DATETIMEOFFSET != jDBCType && JavaType.DATETIMEOFFSET != javaType || sQLServerConnection.isKatmaiOrLater())) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        if (!(SSType.NCHAR != sSType && SSType.NVARCHAR != sSType && SSType.NVARCHARMAX != sSType && SSType.NTEXT != sSType && SSType.XML != sSType || JDBCType.CHAR != jDBCType && JDBCType.VARCHAR != jDBCType && JDBCType.LONGVARCHAR != jDBCType && JDBCType.CLOB != jDBCType)) {
            jDBCType = JDBCType.CLOB == jDBCType ? JDBCType.NCLOB : JDBCType.NVARCHAR;
        } else if (!(SSType.BINARY != sSType && SSType.VARBINARY != sSType && SSType.VARBINARYMAX != sSType && SSType.IMAGE != sSType && SSType.UDT != sSType || JDBCType.CHAR != jDBCType && JDBCType.VARCHAR != jDBCType && JDBCType.LONGVARCHAR != jDBCType)) {
            jDBCType = JDBCType.VARBINARY;
        } else if (!(JDBCType.TIMESTAMP != jDBCType && JDBCType.DATE != jDBCType && JDBCType.TIME != jDBCType || SSType.CHAR != sSType && SSType.VARCHAR != sSType && SSType.VARCHARMAX != sSType && SSType.TEXT != sSType && SSType.NCHAR != sSType && SSType.NVARCHAR != sSType && SSType.NVARCHARMAX != sSType && SSType.NTEXT != sSType)) {
            jDBCType = JDBCType.NCHAR;
        }
        if (null == this.updaterDTV) {
            this.updaterDTV = new DTV();
        }
        this.updaterDTV.setValue(this.typeInfo.getSQLCollation(), jDBCType, object, javaType, streamSetterArgs, calendar, n2, sQLServerConnection);
    }

    boolean hasUpdates() {
        return null != this.updaterDTV;
    }

    void cancelUpdates() {
        this.updaterDTV = null;
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.updaterDTV) {
            return;
        }
        this.updaterDTV.sendByRPC(this.baseColumnName, this.typeInfo, this.typeInfo.getSQLCollation(), this.typeInfo.getScale(), false, tDSWriter, sQLServerConnection);
    }
}

