/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.model;

import com.zkteco.zkbiosecurity.core.model.BaseModel;
import com.zkteco.zkbiosecurity.pers.model.PersBioTemplate;
import com.zkteco.zkbiosecurity.pers.model.PersCertificate;
import com.zkteco.zkbiosecurity.pers.model.PersPersonChange;
import com.zkteco.zkbiosecurity.pers.model.PersPosition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PERS_PERSON", indexes={@Index(name="PERS_PERSON_PIN_IDX", columnList="PIN"), @Index(name="PERS_PERSON_NAME_IDX", columnList="NAME"), @Index(name="PERS_PERSON_DEPT_ID_IDX", columnList="AUTH_DEPT_ID"), @Index(name="PERS_PERSON_CREATE_TIME_IDX", columnList="CREATE_TIME"), @Index(name="PERS_PERSON_UPDATE_TIME_IDX", columnList="UPDATE_TIME")})
public class PersPerson
extends BaseModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="AUTH_DEPT_ID", length=50, nullable=false)
    private String deptId;
    @ManyToOne
    @JoinColumn(name="POSITION_ID")
    private PersPosition persPosition;
    @Column(name="PIN", length=30, nullable=false, updatable=false, unique=true)
    private String pin;
    @Column(name="NAME", length=50)
    private String name;
    @Column(name="LAST_NAME", length=50)
    private String lastName;
    @Column(name="GENDER", length=1)
    private String gender;
    @Column(name="PHOTO_PATH", length=200)
    private String photoPath;
    @Column(name="STATUS")
    private Short status;
    @Column(name="NAME_SPELL", length=420)
    private String nameSpell;
    @Column(name="PERSON_TYPE")
    private Short personType;
    @Column(name="BIRTHDAY")
    @Temporal(value=TemporalType.DATE)
    private Date birthday;
    @Column(name="MOBILE_PHONE", length=20)
    private String mobilePhone;
    @Column(name="EMAIL", length=100)
    private String email;
    @Column(name="PERSON_PWD", length=32)
    private String personPwd;
    @Column(name="SSN", length=20)
    private String ssn;
    @Column(name="CAR_PLATE", length=20)
    private String carPlate;
    @Column(name="SELF_PWD", length=32)
    private String selfPwd;
    @Column(name="EXCEPTION_FLAG")
    private Short exceptionFlag;
    @Column(name="IS_SENDMAIL")
    private Boolean isSendMail;
    @Column(name="HIRE_DATE")
    @Temporal(value=TemporalType.DATE)
    private Date hireDate;
    @Column(name="ID_CARD", length=20)
    private String idCard;
    @Column(name="ID_CARD_PHYSICAL_NO", length=50)
    private String idCardPhysicalNo;
    @Column(name="IS_FROM", length=100, updatable=false)
    private String isFrom;
    @Column(name="PIN_LETTER", updatable=false)
    private Boolean pinLetter;
    @Column(name="PERS_LOGIN_LIMIT")
    private Integer persLoginLimit;
    @Column(name="MINI_APP_OPEN_ID", length=100)
    private String miniAppOpenId;
    @Column(name="MINI_APP_SESSION_KEY", length=100)
    private String miniAppSessionKey;
    @Column(name="UNION_ID", length=100)
    private String unionId;
    @Column(name="SEND_SMS")
    private Boolean sendSMS;
    @OneToMany(mappedBy="persPerson", cascade={CascadeType.ALL})
    private List<PersPersonChange> persPersonChangeList = new ArrayList<PersPersonChange>();
    @OneToMany(mappedBy="persPerson", cascade={CascadeType.ALL})
    private List<PersCertificate> persCertificateList = new ArrayList<PersCertificate>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="PERSON_ID")
    private Set<PersBioTemplate> persBioTemplateSet = new HashSet<PersBioTemplate>();

    public PersPerson() {
    }

    public PersPerson(String id, String pin, String name, String lastName, String personPwd, Short personType, String photoPath, String idCard) {
        this.id = id;
        this.pin = pin;
        this.name = name;
        this.lastName = lastName;
        this.photoPath = photoPath;
        this.personPwd = personPwd;
        this.idCard = idCard;
        this.personType = personType;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public PersPosition getPersPosition() {
        return this.persPosition;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getNameSpell() {
        return this.nameSpell;
    }

    public Short getPersonType() {
        return this.personType;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPersonPwd() {
        return this.personPwd;
    }

    public String getSsn() {
        return this.ssn;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getSelfPwd() {
        return this.selfPwd;
    }

    public Short getExceptionFlag() {
        return this.exceptionFlag;
    }

    public Boolean getIsSendMail() {
        return this.isSendMail;
    }

    public Date getHireDate() {
        return this.hireDate;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public String getIdCardPhysicalNo() {
        return this.idCardPhysicalNo;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public Boolean getPinLetter() {
        return this.pinLetter;
    }

    public Integer getPersLoginLimit() {
        return this.persLoginLimit;
    }

    public String getMiniAppOpenId() {
        return this.miniAppOpenId;
    }

    public String getMiniAppSessionKey() {
        return this.miniAppSessionKey;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public Boolean getSendSMS() {
        return this.sendSMS;
    }

    public List<PersPersonChange> getPersPersonChangeList() {
        return this.persPersonChangeList;
    }

    public List<PersCertificate> getPersCertificateList() {
        return this.persCertificateList;
    }

    public Set<PersBioTemplate> getPersBioTemplateSet() {
        return this.persBioTemplateSet;
    }

    public PersPerson setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersPerson setPersPosition(PersPosition persPosition) {
        this.persPosition = persPosition;
        return this;
    }

    public PersPerson setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersPerson setName(String name) {
        this.name = name;
        return this;
    }

    public PersPerson setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersPerson setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PersPerson setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public PersPerson setStatus(Short status) {
        this.status = status;
        return this;
    }

    public PersPerson setNameSpell(String nameSpell) {
        this.nameSpell = nameSpell;
        return this;
    }

    public PersPerson setPersonType(Short personType) {
        this.personType = personType;
        return this;
    }

    public PersPerson setBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    public PersPerson setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public PersPerson setEmail(String email) {
        this.email = email;
        return this;
    }

    public PersPerson setPersonPwd(String personPwd) {
        this.personPwd = personPwd;
        return this;
    }

    public PersPerson setSsn(String ssn) {
        this.ssn = ssn;
        return this;
    }

    public PersPerson setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public PersPerson setSelfPwd(String selfPwd) {
        this.selfPwd = selfPwd;
        return this;
    }

    public PersPerson setExceptionFlag(Short exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
        return this;
    }

    public PersPerson setIsSendMail(Boolean isSendMail) {
        this.isSendMail = isSendMail;
        return this;
    }

    public PersPerson setHireDate(Date hireDate) {
        this.hireDate = hireDate;
        return this;
    }

    public PersPerson setIdCard(String idCard) {
        this.idCard = idCard;
        return this;
    }

    public PersPerson setIdCardPhysicalNo(String idCardPhysicalNo) {
        this.idCardPhysicalNo = idCardPhysicalNo;
        return this;
    }

    public PersPerson setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public PersPerson setPinLetter(Boolean pinLetter) {
        this.pinLetter = pinLetter;
        return this;
    }

    public PersPerson setPersLoginLimit(Integer persLoginLimit) {
        this.persLoginLimit = persLoginLimit;
        return this;
    }

    public PersPerson setMiniAppOpenId(String miniAppOpenId) {
        this.miniAppOpenId = miniAppOpenId;
        return this;
    }

    public PersPerson setMiniAppSessionKey(String miniAppSessionKey) {
        this.miniAppSessionKey = miniAppSessionKey;
        return this;
    }

    public PersPerson setUnionId(String unionId) {
        this.unionId = unionId;
        return this;
    }

    public PersPerson setSendSMS(Boolean sendSMS) {
        this.sendSMS = sendSMS;
        return this;
    }

    public PersPerson setPersPersonChangeList(List<PersPersonChange> persPersonChangeList) {
        this.persPersonChangeList = persPersonChangeList;
        return this;
    }

    public PersPerson setPersCertificateList(List<PersCertificate> persCertificateList) {
        this.persCertificateList = persCertificateList;
        return this;
    }

    public PersPerson setPersBioTemplateSet(Set<PersBioTemplate> persBioTemplateSet) {
        this.persBioTemplateSet = persBioTemplateSet;
        return this;
    }
}

