/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisTrainingTipRemote;
import com.zkteco.zkbiosecurity.sis.service.SisTrainingTipService;
import com.zkteco.zkbiosecurity.sis.vo.SisTrainingTipItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisTrainingTipController
extends BaseController
implements SisTrainingTipRemote {
    @Autowired
    private SisTrainingTipService sisTrainingTipService;

    @RequiresPermissions(value={"sis:trainingTip"})
    public ModelAndView index() {
        return new ModelAndView("sis/trainingTip/sisTrainingTip");
    }

    @RequiresPermissions(value={"sis:trainingTip:edit"})
    public ModelAndView edit(String id) {
        return new ModelAndView("sis/trainingTip/editSisTrainingTip");
    }

    @RequiresPermissions(value={"sis:trainingTip:edit"})
    @LogRequest(module="sis_module", object="sis_tip_trainTipGallery", opType="common_op_edit", requestParams={"name"}, opContent="sis_tip_trainTipGallery")
    public ZKResultMsg save(SisTrainingTipItem item) {
        return null;
    }

    @RequiresPermissions(value={"sis:trainingTip:refresh"})
    public DxGrid list(SisTrainingTipItem condition) {
        Pager pager = this.sisTrainingTipService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:trainingTip:del"})
    @LogRequest(module="sis_module", object="sis_tip_trainTipGallery", opType="common_op_del", requestParams={"name"}, opContent="sis_tip_trainTipGallery")
    public ZKResultMsg del(String ids) {
        this.sisTrainingTipService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

