/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.sis.remote.SisMonitorWindowRemote;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisFluidTransactionService;
import com.zkteco.zkbiosecurity.sis.service.SisIEDTransactionService;
import com.zkteco.zkbiosecurity.sis.service.SisMonitorWindowService;
import com.zkteco.zkbiosecurity.sis.service.SisPackageTransactionService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import com.zkteco.zkbiosecurity.sis.vo.SisFluidTransactionItem;
import com.zkteco.zkbiosecurity.sis.vo.SisIEDTransactionItem;
import com.zkteco.zkbiosecurity.sis.vo.SisMonitorWindowItem;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;

@Controller
public class SisMonitorWindowController
extends ExportController
implements SisMonitorWindowRemote {
    @Autowired
    private SisMonitorWindowService sisMonitorWindowService;
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisIEDTransactionService sisIEDTransactionService;
    @Autowired
    private SisFluidTransactionService sisFluidTransactionService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SisPackageTransactionService sisPackageTransactionService;

    public DxGrid list(SisMonitorWindowItem codition) {
        Pager pager = this.sisMonitorWindowService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getDevAll(String model, String devSn, String areaId) throws IOException {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONArray retArray = new JSONArray();
        SisDeviceItem sisDeviceItem = new SisDeviceItem();
        SisIEDTransactionItem sisIEDTransactionItem = new SisIEDTransactionItem();
        if (StringUtils.isNotBlank((CharSequence)model)) {
            sisDeviceItem.setModel(model);
        } else if (StringUtils.isNotBlank((CharSequence)devSn)) {
            sisDeviceItem.setSn(devSn);
        } else if (StringUtils.isNotBlank((CharSequence)areaId)) {
            sisDeviceItem.setAuthAreaId(areaId);
        }
        List devList = this.sisDeviceService.getByCondition(sisDeviceItem);
        for (SisDeviceItem dev : devList) {
            JSONObject ret = new JSONObject();
            ret.put("winId", (Object)dev.getId());
            ret.put("devName", (Object)dev.getName());
            String status = "";
            if (StringUtils.isNotBlank((CharSequence)dev.getModel()) && (StringUtils.equals((CharSequence)dev.getModel(), (CharSequence)"4330") || StringUtils.equals((CharSequence)dev.getModel(), (CharSequence)"3180"))) {
                ret.put("devType", (Object)1);
                this.stringRedisTemplate.opsForValue().set((Object)("SIS_GATE_RT_WORK_PARAM_LOG_PERSON_COUNT_" + dev.getIp()), (Object)"0");
                this.stringRedisTemplate.opsForValue().set((Object)("SIS_GATE_RT_WORK_PARAM_LOG_ALARM_TIMES_" + dev.getIp()), (Object)"0");
                status = this.stringRedisTemplate.hasKey((Object)("SIS_GATE_DEVICE_STATUS_" + dev.getIp())).booleanValue() && StringUtils.equals((CharSequence)((CharSequence)this.stringRedisTemplate.opsForValue().get((Object)("SIS_GATE_DEVICE_STATUS_" + dev.getIp()))), (CharSequence)"0") ? "1" : "0";
            } else if (StringUtils.isNotBlank((CharSequence)dev.getType()) && StringUtils.equals((CharSequence)dev.getType(), (CharSequence)"5030")) {
                ret.put("devType", (Object)0);
                String data = (String)this.stringRedisTemplate.opsForValue().get((Object)("SIS_DEVICE_MONITOR_" + dev.getSn()));
                JSONObject conn = JSONObject.parseObject((String)data);
                if (conn.getShort("connect") == 1) {
                    status = "1";
                    String packagePhotoPath = this.sisPackageTransactionService.findItemBydevId(dev.getId());
                    if (StringUtils.isNotBlank((CharSequence)packagePhotoPath)) {
                        ret.put("img", (Object)packagePhotoPath);
                    } else {
                        ret.put("img", (Object)"public/images/check_online.png");
                    }
                    String realPhotoPath = FileUtil.getLocalFullPath((String)packagePhotoPath);
                    File picture = new File(realPhotoPath);
                    if (picture.exists()) {
                        BufferedImage sourceImg = ImageIO.read(new FileInputStream(picture));
                        ret.put("imgWidth", (Object)sourceImg.getWidth());
                        ret.put("imgHeight", (Object)sourceImg.getHeight());
                    } else {
                        ret.put("imgWidth", (Object)0);
                        ret.put("imgHeight", (Object)0);
                    }
                } else {
                    status = "0";
                }
            } else if (StringUtils.isNotBlank((CharSequence)dev.getModel()) && StringUtils.equals((CharSequence)dev.getModel(), (CharSequence)"ZK-E8800D")) {
                status = (String)this.stringRedisTemplate.opsForValue().get((Object)("SIS_IED_HEARBEAT_" + dev.getIp()));
                ret.put("devType", (Object)2);
                Integer successCount = this.sisIEDTransactionService.findIEDTransactionSumCountByDevId(dev.getId());
                Integer errorCount = this.sisIEDTransactionService.findIEDTransactionCountByDevId(dev.getId(), "03");
                SisIEDTransactionItem iedTransactionItem = this.sisIEDTransactionService.findMaxItemByDevId(dev.getId());
                if (iedTransactionItem != null) {
                    String endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(iedTransactionItem.getEventTime());
                    ret.put("time", (Object)endTime);
                    ret.put("matter", (Object)iedTransactionItem.getMatter());
                } else {
                    ret.put("time", (Object)"");
                }
                if (successCount != null) {
                    ret.put("successCount", (Object)successCount);
                } else {
                    ret.put("successCount", (Object)0);
                }
                if (errorCount != null) {
                    ret.put("errorCount", (Object)errorCount);
                } else {
                    ret.put("errorCount", (Object)0);
                }
            } else if (StringUtils.isNotBlank((CharSequence)dev.getModel()) && StringUtils.equals((CharSequence)dev.getModel(), (CharSequence)"ZK-LD5000")) {
                status = (String)this.stringRedisTemplate.opsForValue().get((Object)("SIS_ZK-LD5000_DEVICE_STATUS_TIME_" + dev.getIp()));
                ret.put("devType", (Object)3);
                SisFluidTransactionItem item = this.sisFluidTransactionService.findMaxItemByDevId(dev.getId());
                if (item != null) {
                    String endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(item.getEventTime());
                    ret.put("time", (Object)endTime);
                } else {
                    ret.put("time", (Object)"");
                }
                Integer successCount = this.sisFluidTransactionService.findFluidTransactionCountByDevId(dev.getId(), I18nUtil.i18nCode((String)"sis_fluid_securit", (Object[])new Object[0]));
                Integer errorCount = this.sisFluidTransactionService.findFluidTransactionCountByDevId(dev.getId(), I18nUtil.i18nCode((String)"sis_fluid_alarm", (Object[])new Object[0]));
                if (successCount != null) {
                    ret.put("successCount", (Object)successCount);
                } else {
                    ret.put("successCount", (Object)0);
                }
                if (errorCount != null) {
                    ret.put("errorCount", (Object)errorCount);
                } else {
                    ret.put("errorCount", (Object)0);
                }
            }
            ret.put("status", (Object)status);
            ret.put("devSn", (Object)dev.getSn());
            ret.put("devId", (Object)dev.getId());
            ret.put("devArea", (Object)dev.getAuthAreaName());
            retArray.add((Object)ret);
        }
        resultMsg.setData((Object)retArray);
        return resultMsg;
    }
}

