/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vid.remote.VidParamsRemote;
import com.zkteco.zkbiosecurity.vid.service.VidParamsService;
import java.io.File;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidParamsController
extends BaseController
implements VidParamsRemote {
    @Autowired
    private VidParamsService vidParamsService;

    @RequiresPermissions(value={"vid:params"})
    public ModelAndView index() {
        Map vidParams = this.vidParamsService.getVidParams();
        this.request.setAttribute("vidParams", (Object)vidParams);
        return new ModelAndView("vid/params/vidParams");
    }

    @RequiresPermissions(value={"vid:params:edit"})
    @LogRequest(module="vid_module", object="common_leftMenu_paramSet", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        boolean flag = false;
        File[] listRoots = File.listRoots();
        String filePath = params.get("vid.file_path");
        for (File rootFile : listRoots) {
            if (!filePath.toUpperCase().startsWith(rootFile.getPath())) continue;
            flag = true;
            File file = new File(filePath);
            if (file.exists()) continue;
            file.mkdirs();
        }
        if (flag) {
            this.vidParamsService.saveItem(params);
        } else {
            res.setRet("fail");
            res.setMsg("vid_param_diskNotExist");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vid:params"})
    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.vidParamsService.getVidParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

