/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vid.remote.VidChannel2EntityRemote;
import com.zkteco.zkbiosecurity.vid.service.VidChannel2EntityService;
import com.zkteco.zkbiosecurity.vid.vo.VidChannel2EntityItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidChannel2EntityController
extends BaseController
implements VidChannel2EntityRemote {
    @Autowired
    private VidChannel2EntityService vidChannel2EntityService;

    @RequiresPermissions(value={"vid:channel2Entity:view"})
    public ModelAndView index() {
        return new ModelAndView("vid/channel2Entity/vidChannel2Entity");
    }

    @RequiresPermissions(value={"vid:channel2Entity:edit"})
    @LogRequest
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.vidChannel2EntityService.getItemById(id));
        }
        return new ModelAndView("vid/channel2Entity/editVidChannel2Entity");
    }

    @RequiresPermissions(value={"vid:channel2Entity:edit"})
    public ZKResultMsg save(VidChannel2EntityItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vidChannel2EntityService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(VidChannel2EntityItem condition) {
        Pager pager = this.vidChannel2EntityService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.vidChannel2EntityService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg bindOrUnbindChannel() {
        ZKResultMsg ret = new ZKResultMsg();
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        this.vidChannel2EntityService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return ret;
    }
}

