/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttOvertimeRemote;
import com.zkteco.zkbiosecurity.att.service.AttOvertimeService;
import com.zkteco.zkbiosecurity.att.vo.AttOvertimeItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttOvertimeController
extends ExportController
implements AttOvertimeRemote {
    @Autowired
    private AttOvertimeService attOvertimeService;

    @RequiresPermissions(value={"att:overtime"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/overtime/attOvertime");
    }

    @RequiresPermissions(value={"att:overtime:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        AttOvertimeItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attOvertimeService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttOvertimeItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/overtime/editAttOvertime");
    }

    @RequiresPermissions(value={"att:overtime:add"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="common_op_new", requestParams={"personPin"}, opContent="att_person_pin")
    public ZKResultMsg save(AttOvertimeItem item) {
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -2);
        calendar.set(5, 1);
        Date theFirstDayOfLastMonth = DateUtil.getDayBeginTime((Date)calendar.getTime());
        if (theFirstDayOfLastMonth.compareTo(item.getStartDatetime()) > 0) {
            return ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"att_apply_overLastMonth", (Object[])new Object[0]));
        }
        ZKResultMsg res = new ZKResultMsg();
        this.attOvertimeService.saveItem(item, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:overtime:refresh"})
    public DxGrid list(AttOvertimeItem condition) {
        condition.setFlowStatus("2");
        Pager pager = this.attOvertimeService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:overtime:del"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attOvertimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:overtime:export"})
    @LogRequest(module="att_module", object="att_leftMenu_overtime", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttOvertimeItem attOvertimeItem = new AttOvertimeItem();
        this.setConditionValue((BaseItem)attOvertimeItem);
        attOvertimeItem.setFlowStatus("2");
        List intemList = this.attOvertimeService.getItemData(request.getSession().getId(), attOvertimeItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttOvertimeItem.class);
    }

    public ZKResultMsg checkOvertime(String personPin, String startDatetime, String endDatetime) {
        Date startDate = DateUtil.stringToDate((String)startDatetime);
        Date endDate = DateUtil.stringToDate((String)endDatetime);
        ZKResultMsg zkResultMsg = this.attOvertimeService.checkOvertimeTimeLong(personPin, startDate, endDate);
        return zkResultMsg;
    }
}

