/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttHolidayRemote;
import com.zkteco.zkbiosecurity.att.service.AttHolidayService;
import com.zkteco.zkbiosecurity.att.vo.AttHolidayItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttHolidayController
extends BaseController
implements AttHolidayRemote {
    @Autowired
    private AttHolidayService attHolidayService;

    @RequiresPermissions(value={"att:holiday"})
    public ModelAndView index() {
        return new ModelAndView("att/holiday/attHoliday");
    }

    @RequiresPermissions(value={"att:holiday:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attHolidayService.getItemById(id));
        }
        return new ModelAndView("att/holiday/editAttHoliday");
    }

    @RequiresPermissions(value={"att:holiday:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_holiday", opType="common_op_new", requestParams={"holidayName"}, opContent="common_name")
    public ZKResultMsg save(AttHolidayItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attHolidayService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:holiday:refresh"})
    public DxGrid list(AttHolidayItem condition) {
        Pager pager = this.attHolidayService.loadPagerByFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:holiday:del"})
    @LogRequest(module="att_module", object="att_leftMenu_holiday", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.attHolidayService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String holidayName) {
        boolean rs = !this.attHolidayService.existsByHolidayName(holidayName);
        return rs + "";
    }

    public ZKResultMsg validDate(String id, Date startDatetime, Date endDateTime) {
        ZKResultMsg zkResultMsg = this.attHolidayService.validDate(id, startDatetime, endDateTime);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

