/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AppAttQueryTeamAttItem;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiSignInItem;
import com.zkteco.zkbiosecurity.att.h5.service.AttApiH5SignService;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5SignController {
    @Autowired
    private AttApiH5SignService attApiH5SignService;

    @RequestMapping(path={"/signIn"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg signIn(@RequestBody AttApiSignInItem appAttSignInItem) {
        String customerId = appAttSignInItem.getCustomerId();
        String latLongitude = appAttSignInItem.getLatLongitude();
        String areaId = appAttSignInItem.getAreaId();
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)latLongitude)) {
            throw ZKBusinessException.errorException((String)"att_h5_attPlaceNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)areaId)) {
            throw ZKBusinessException.errorException((String)"att_h5_attAreaNull", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5SignService.signIn(customerId, latLongitude, areaId));
    }

    @RequestMapping(path={"/verifyAttArea"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg verifyAttArea(@RequestBody AttApiSignInItem appAttSignInItem) {
        String customerId = appAttSignInItem.getCustomerId();
        String latLongitude = appAttSignInItem.getLatLongitude();
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)latLongitude)) {
            throw ZKBusinessException.errorException((String)"att_h5_latLongitudeNull", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5SignService.verifyAttArea(customerId, latLongitude));
    }

    @RequestMapping(path={"/getAttParams"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getAttParams() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5SignService.getAttParams());
    }

    @RequestMapping(path={"/verifySignTime"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg verifySignTime(@RequestParam(name="signDatetime") String signDatetime, @RequestParam(name="customerId") String customerId) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5SignService.verifySignTime(signDatetime, customerId));
    }

    @RequestMapping(path={"/getPersonMonthSignCount"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getPersonMonthSignCount(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isMonth(appAttQueryTeamAttItem.getAttDate())) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5SignService.getPersonMonthSignCount(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getAttSignAddress"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getAttSignAddress(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKResultMsg resultMsg = this.attApiH5SignService.getAttSignAddress(appAttQueryTeamAttItem.getCustomerId());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

